"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const auth_routes_1 = require("./routes/auth_routes");
const cookie_parser_1 = __importDefault(require("cookie-parser"));
const ad_routes_1 = require("./routes/ad_routes");
const cors_1 = __importDefault(require("cors"));
const multer_1 = __importDefault(require("multer"));
const https_1 = __importDefault(require("https"));
const view_routes_1 = require("./routes/view_routes");
const fs_1 = require("fs");
const req_routes_1 = require("./routes/req_routes");
const app = (0, express_1.default)();
//config
const host = process.env.HOST ? process.env.HOST : "localhost";
const port = parseInt(process.env.PORT ? process.env.PORT : "1234");
const storage = multer_1.default.diskStorage({
    destination: (req, file, cb) => { cb(null, "imgs/"); },
    filename: (req, file, cb) => {
        const uniqueSuffix = `${Date.now()}-${Math.round(Math.random() * 1e9)}`;
        cb(null, `${uniqueSuffix}-${file.originalname}`);
    },
});
const upload = (0, multer_1.default)({ storage: storage });
app.use(express_1.default.json());
app.use(express_1.default.urlencoded({ extended: true }));
app.use((0, cookie_parser_1.default)());
app.use((0, cors_1.default)());
//Auth
app.use("/auth/login", auth_routes_1.loginRoute);
app.use("/auth/is_logged_in", auth_routes_1.isLoggedinRoute);
app.use("/auth/logout", auth_routes_1.logoutRoute);
app.use("/auth/register", auth_routes_1.registerRoute);
app.use("/auth/delete", auth_routes_1.deleteUserRoute);
app.use("/auth/verify", auth_routes_1.verifyRoute);
app.use("/auth/pass_reset", auth_routes_1.passResetRoute);
app.use("/auth/validate_reset", auth_routes_1.validateResetRoute);
app.use("/auth/is_verified", auth_routes_1.isVerifiedRoute);
app.use("/auth/send_code", auth_routes_1.resendCodeRoute);
app.use("/auth/change_pass", auth_routes_1.changePassRoute);
app.use("/auth/is_admin", auth_routes_1.isAdminRoute);
app.use("/auth/profile", auth_routes_1.profileRoute);
//Ads
app.use("/ad/create_ad", upload.single("file"), ad_routes_1.createAdRoute);
app.use("/ad/edit_ad", upload.single("file"), ad_routes_1.editAdRoute);
app.use("/ad/get_user_ads", ad_routes_1.getUserAdsRoute);
app.use("/ad/fetch_cat", ad_routes_1.getAdsForCatRoute);
app.use("/ad/renew", req_routes_1.renewAdRoute);
//Views
app.use("/view/watch", view_routes_1.watchAdRoute);
//authority
app.use("/authority/default_req", req_routes_1.getCreateAdRoute);
app.use("/authority/renew_req", req_routes_1.getRenewAdRoute);
app.use("/authority/money_req", req_routes_1.getMoneyRequestRoute);
app.use("/authority/my_req", req_routes_1.getMyRequestRoute);
app.use("/authority/handle_req", req_routes_1.handleReqRoute);
app.use("/authority/delete_req", req_routes_1.deleteRequestRoute);
app.use("/authority/leaderboard", view_routes_1.getLeaderboardRoute);
app.use("/authority/points_exchange", req_routes_1.exchangePointsRoute);
//Static
app.use("/imgs", express_1.default.static("imgs"));
app.get("/", (req, res) => { res.send("Hello World"); });
app.listen(port, host, () => { console.log(`Server is Running on https://${host}:${port}`); });
//app.listen(port, host, () => {console.log(`Server is Running on http://${host}:${port}`)});
