"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.profile_response = exports.auth_response = void 0;
class auth_response {
    constructor(status, id, session) {
        this.status = status;
        this.id = id;
        this.session = session;
    }
    static valid(id, session) {
        return new auth_response("Valid", id, session);
    }
    static success() {
        return new auth_response("Success");
    }
    static invalid_request() {
        return new auth_response("Invalid Request");
    }
    static invalid_session() {
        return new auth_response("Invalid Session");
    }
    static invalid_auth() {
        return new auth_response("Invalid Auth");
    }
    static custom(status) {
        return new auth_response(status);
    }
}
exports.auth_response = auth_response;
class profile_response {
    constructor(name = "", username = "", email = "", phone = "", points = 0, join = new Date()) {
        this.name = name;
        this.username = username;
        this.email = email;
        this.phone = phone;
        this.points = points;
        this.join = join;
    }
}
exports.profile_response = profile_response;
