"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAdsForCatRoute = exports.editAdRoute = exports.getUserAdsRoute = exports.createAdRoute = void 0;
const express_1 = require("express");
const validate_session_1 = require("../middlewares/validate_session");
const ad_handle_1 = require("../handles/ad_handle");
const createAdRoute = (0, express_1.Router)();
exports.createAdRoute = createAdRoute;
const getUserAdsRoute = (0, express_1.Router)();
exports.getUserAdsRoute = getUserAdsRoute;
const getAdsForCatRoute = (0, express_1.Router)();
exports.getAdsForCatRoute = getAdsForCatRoute;
const editAdRoute = (0, express_1.Router)();
exports.editAdRoute = editAdRoute;
createAdRoute.put("/", validate_session_1.validate_session_middleware, ad_handle_1.create_ad_handle);
editAdRoute.put("/", validate_session_1.validate_session_middleware, ad_handle_1.editAdHandle);
getUserAdsRoute.get("/", validate_session_1.validate_session_middleware, ad_handle_1.getUserAdsHandle);
getAdsForCatRoute.get("/", ad_handle_1.getCategoryAdsHandle);
