"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.watch_ad = watch_ad;
exports.get_recommendations = get_recommendations;
exports.get_leaderboard = get_leaderboard;
const client_1 = require("@prisma/client");
const session_utils_1 = require("./session_utils");
const user_utils_1 = require("./user_utils");
const category_utils_1 = require("./category_utils");
const user_response_1 = require("../responses/user_response");
const add_points = process.env.AD_VIEW_POINTS ? parseInt(process.env.AD_VIEW_POINTS) : 10;
const base_url = `${process.env.HOST}`;
function watch_ad(session, user, ad) {
    return __awaiter(this, void 0, void 0, function* () {
        const prisma = new client_1.PrismaClient();
        const data = yield prisma.ad.findFirst({ where: { id: ad } });
        if (data) {
            if (session && user) {
                // Check user view
                const view = yield prisma.views.findFirst({
                    where: {
                        ad: ad,
                        user: user
                    }
                });
                // Insert View
                yield prisma.views.create({ data: {
                        ad: ad,
                        user: user,
                        points: add_points,
                        time: new Date
                    } });
                if (!view) {
                    // Update User points
                    yield (0, user_utils_1.add_points_to_user)(user, add_points);
                }
            }
            // Update Views of Ad
            yield prisma.ad.update({
                data: {
                    views: data.views + 1
                },
                where: {
                    id: data.id
                }
            });
        }
        if (session && user) {
            // Update Session
            yield (0, session_utils_1.update_session)(session);
        }
        yield prisma.$disconnect();
    });
}
function get_recommendations(user) {
    return __awaiter(this, void 0, void 0, function* () {
        const prisma = new client_1.PrismaClient();
        //Get Last Viewed
        const ads = yield prisma.views.findMany({
            select: { ad_views_adToad: true },
            where: { user: user },
            take: 50,
            orderBy: { time: "desc" }
        });
        //Get Keywords of interset
        const keywords = new Map();
        ads.forEach((ad) => {
            ad.ad_views_adToad.keywords.split(",").forEach((word) => {
                var _a;
                keywords.set(word.trim(), ((_a = keywords.get(word.trim())) !== null && _a !== void 0 ? _a : 0) + 1);
            });
        });
        //Get Best Keywords
        const bestKeyWordsFilter = new Array;
        Array.from(keywords.entries()).sort((a, b) => a[1] - b[1])
            .map(([key]) => key).slice(0, 5).forEach((word) => {
            bestKeyWordsFilter.push({ keywords: { contains: word } });
        });
        //Get candidates based on keywords
        const candidates = yield prisma.ad.findMany({
            where: {
                OR: bestKeyWordsFilter,
                views: {
                    lt: prisma.ad.fields.targetViews
                }
            },
            take: 50,
            orderBy: {
                renewal_date: "desc"
            }
        });
        //Get Categories
        const categoriesOfInterest = new Set();
        const categories = yield prisma.views.findMany({
            select: { ad_views_adToad: { select: { category: true } } },
            where: { user: user, ad_views_adToad: { isPublished: true, type: "Dynamic", views: {
                        lt: prisma.ad.fields.targetViews
                    } }, },
            take: 50,
            orderBy: { time: "desc" }
        });
        categories.forEach((cat) => { categoriesOfInterest.add(cat.ad_views_adToad.category); });
        const candidatesMap = new Map();
        //Build Recommendation
        candidates.forEach((can) => {
            candidatesMap.set(can, 
            //Recomendation Metric
            can.views * 0.0001 + (can.targetViews - can.views) * 0.003
                + (categoriesOfInterest.has(can.category) ? 1 : 0) * 100);
        });
        const bestAds = new Array;
        Array.from(candidatesMap.entries()).sort((a, b) => a[1] - b[1])
            .map(([key]) => key).slice(0, 7);
        //Top Watched
        const top = yield prisma.ad.findMany({
            where: { isPublished: true, type: "Dynamic" },
            orderBy: { views: "desc" },
            take: 10 - bestAds.length
        });
        //Combine Results
        const res = new Array();
        bestAds.forEach((obj) => {
            res.push({
                id: obj.id,
                name: obj.name,
                image: `https://${base_url}/${obj.image}`,
                category: (0, category_utils_1.category_to_number)(obj.category),
                isPublished: obj.isPublished,
                keywords: obj.keywords,
                lastUpdate: obj.renewal_date,
                path: obj.path,
                type: obj.type,
                views: obj.views,
                targetViews: obj.targetViews
            });
        });
        top.forEach((obj) => {
            res.push({
                id: obj.id,
                name: obj.name,
                image: `https://${base_url}/${obj.image}`,
                category: (0, category_utils_1.category_to_number)(obj.category),
                isPublished: obj.isPublished,
                keywords: obj.keywords,
                lastUpdate: obj.renewal_date,
                path: obj.path,
                type: obj.type,
                views: obj.views,
                targetViews: obj.targetViews
            });
        });
        yield prisma.$disconnect();
        return res;
    });
}
function get_leaderboard() {
    return __awaiter(this, void 0, void 0, function* () {
        const prisma = new client_1.PrismaClient();
        let res = [];
        const data = yield prisma.user.findMany({
            select: {
                username: true,
                fullname: true,
                phone: true,
                email: true,
                _count: { select: { views_views_userTouser: true } },
                points: true
            },
            orderBy: {
                views_views_userTouser: { _count: "desc" },
            },
            where: {
                isDeleted: false
            },
            take: 5
        });
        data.forEach((obj) => {
            var _a;
            res.push(new user_response_1.leaderboard_user(obj.username, obj.fullname, obj.email, (_a = obj.phone) !== null && _a !== void 0 ? _a : "", obj._count.views_views_userTouser, obj.points));
        });
        yield prisma.$disconnect();
        return res;
    });
}
