
Object.defineProperty(exports, "__esModule", { value: true });

const {
  Decimal,
  objectEnumValues,
  makeStrictEnum,
  Public,
  getRuntime,
  skip
} = require('@prisma/client/runtime/index-browser.js')


const Prisma = {}

exports.Prisma = Prisma
exports.$Enums = {}

/**
 * Prisma Client JS version: 6.3.1
 * Query Engine version: acc0b9dd43eb689cbd20c9470515d719db10d0b0
 */
Prisma.prismaVersion = {
  client: "6.3.1",
  engine: "acc0b9dd43eb689cbd20c9470515d719db10d0b0"
}

Prisma.PrismaClientKnownRequestError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientKnownRequestError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)};
Prisma.PrismaClientUnknownRequestError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientUnknownRequestError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.PrismaClientRustPanicError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientRustPanicError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.PrismaClientInitializationError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientInitializationError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.PrismaClientValidationError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientValidationError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.Decimal = Decimal

/**
 * Re-export of sql-template-tag
 */
Prisma.sql = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`sqltag is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.empty = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`empty is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.join = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`join is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.raw = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`raw is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.validator = Public.validator

/**
* Extensions
*/
Prisma.getExtensionContext = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`Extensions.getExtensionContext is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.defineExtension = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`Extensions.defineExtension is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}

/**
 * Shorthand utilities for JSON filtering
 */
Prisma.DbNull = objectEnumValues.instances.DbNull
Prisma.JsonNull = objectEnumValues.instances.JsonNull
Prisma.AnyNull = objectEnumValues.instances.AnyNull

Prisma.NullTypes = {
  DbNull: objectEnumValues.classes.DbNull,
  JsonNull: objectEnumValues.classes.JsonNull,
  AnyNull: objectEnumValues.classes.AnyNull
}



/**
 * Enums
 */

exports.Prisma.TransactionIsolationLevel = makeStrictEnum({
  ReadUncommitted: 'ReadUncommitted',
  ReadCommitted: 'ReadCommitted',
  RepeatableRead: 'RepeatableRead',
  Serializable: 'Serializable'
});

exports.Prisma.AdScalarFieldEnum = {
  id: 'id',
  name: 'name',
  path: 'path',
  views: 'views',
  targetViews: 'targetViews',
  image: 'image',
  type: 'type',
  category: 'category',
  creation_date: 'creation_date',
  renewal_date: 'renewal_date',
  isPublished: 'isPublished',
  keywords: 'keywords',
  userid: 'userid'
};

exports.Prisma.RequestScalarFieldEnum = {
  id: 'id',
  ad: 'ad',
  user: 'user',
  type: 'type',
  creation: 'creation',
  param: 'param'
};

exports.Prisma.SessionScalarFieldEnum = {
  id: 'id',
  userid: 'userid',
  ip: 'ip',
  last_used: 'last_used',
  is_reset: 'is_reset'
};

exports.Prisma.UserScalarFieldEnum = {
  id: 'id',
  fullname: 'fullname',
  username: 'username',
  password: 'password',
  email: 'email',
  phone: 'phone',
  points: 'points',
  joinDate: 'joinDate',
  isVerified: 'isVerified',
  isAdmin: 'isAdmin',
  isDeleted: 'isDeleted',
  verification: 'verification'
};

exports.Prisma.ViewsScalarFieldEnum = {
  id: 'id',
  ad: 'ad',
  user: 'user',
  time: 'time',
  points: 'points'
};

exports.Prisma.SortOrder = {
  asc: 'asc',
  desc: 'desc'
};

exports.Prisma.adOrderByRelevanceFieldEnum = {
  id: 'id',
  name: 'name',
  path: 'path',
  image: 'image',
  keywords: 'keywords',
  userid: 'userid'
};

exports.Prisma.NullsOrder = {
  first: 'first',
  last: 'last'
};

exports.Prisma.requestOrderByRelevanceFieldEnum = {
  id: 'id',
  ad: 'ad',
  user: 'user',
  param: 'param'
};

exports.Prisma.sessionOrderByRelevanceFieldEnum = {
  id: 'id',
  userid: 'userid',
  ip: 'ip'
};

exports.Prisma.userOrderByRelevanceFieldEnum = {
  id: 'id',
  fullname: 'fullname',
  username: 'username',
  password: 'password',
  email: 'email',
  phone: 'phone',
  verification: 'verification'
};

exports.Prisma.viewsOrderByRelevanceFieldEnum = {
  ad: 'ad',
  user: 'user'
};
exports.ad_type = exports.$Enums.ad_type = {
  Fixed: 'Fixed',
  Dynamic: 'Dynamic'
};

exports.ad_category = exports.$Enums.ad_category = {
  Electronics: 'Electronics',
  Fashion: 'Fashion',
  Health: 'Health',
  Home: 'Home',
  Groceries: 'Groceries',
  Games: 'Games',
  Books: 'Books',
  Automotive: 'Automotive',
  Pet: 'Pet',
  Food: 'Food',
  Other: 'Other'
};

exports.request_type = exports.$Enums.request_type = {
  Create: 'Create',
  Renew: 'Renew',
  Money: 'Money'
};

exports.Prisma.ModelName = {
  ad: 'ad',
  request: 'request',
  session: 'session',
  user: 'user',
  views: 'views'
};

/**
 * This is a stub Prisma Client that will error at runtime if called.
 */
class PrismaClient {
  constructor() {
    return new Proxy(this, {
      get(target, prop) {
        let message
        const runtime = getRuntime()
        if (runtime.isEdge) {
          message = `PrismaClient is not configured to run in ${runtime.prettyName}. In order to run Prisma Client on edge runtime, either:
- Use Prisma Accelerate: https://pris.ly/d/accelerate
- Use Driver Adapters: https://pris.ly/d/driver-adapters
`;
        } else {
          message = 'PrismaClient is unable to run in this browser environment, or has been bundled for the browser (running in `' + runtime.prettyName + '`).'
        }
        
        message += `
If this is unexpected, please open an issue: https://pris.ly/prisma-prisma-bug-report`

        throw new Error(message)
      }
    })
  }
}

exports.PrismaClient = PrismaClient

Object.assign(exports, Prisma)
