
/**
 * Client
**/

import * as runtime from '@prisma/client/runtime/library.js';
import $Types = runtime.Types // general types
import $Public = runtime.Types.Public
import $Utils = runtime.Types.Utils
import $Extensions = runtime.Types.Extensions
import $Result = runtime.Types.Result

export type PrismaPromise<T> = $Public.PrismaPromise<T>


/**
 * Model ad
 * 
 */
export type ad = $Result.DefaultSelection<Prisma.$adPayload>
/**
 * Model request
 * 
 */
export type request = $Result.DefaultSelection<Prisma.$requestPayload>
/**
 * Model session
 * 
 */
export type session = $Result.DefaultSelection<Prisma.$sessionPayload>
/**
 * Model user
 * 
 */
export type user = $Result.DefaultSelection<Prisma.$userPayload>
/**
 * Model views
 * 
 */
export type views = $Result.DefaultSelection<Prisma.$viewsPayload>

/**
 * Enums
 */
export namespace $Enums {
  export const request_type: {
  Create: 'Create',
  Renew: 'Renew',
  Money: 'Money'
};

export type request_type = (typeof request_type)[keyof typeof request_type]


export const ad_type: {
  Fixed: 'Fixed',
  Dynamic: 'Dynamic'
};

export type ad_type = (typeof ad_type)[keyof typeof ad_type]


export const ad_category: {
  Electronics: 'Electronics',
  Fashion: 'Fashion',
  Health: 'Health',
  Home: 'Home',
  Groceries: 'Groceries',
  Games: 'Games',
  Books: 'Books',
  Automotive: 'Automotive',
  Pet: 'Pet',
  Food: 'Food',
  Other: 'Other'
};

export type ad_category = (typeof ad_category)[keyof typeof ad_category]

}

export type request_type = $Enums.request_type

export const request_type: typeof $Enums.request_type

export type ad_type = $Enums.ad_type

export const ad_type: typeof $Enums.ad_type

export type ad_category = $Enums.ad_category

export const ad_category: typeof $Enums.ad_category

/**
 * ##  Prisma Client ʲˢ
 *
 * Type-safe database client for TypeScript & Node.js
 * @example
 * ```
 * const prisma = new PrismaClient()
 * // Fetch zero or more Ads
 * const ads = await prisma.ad.findMany()
 * ```
 *
 *
 * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
 */
export class PrismaClient<
  ClientOptions extends Prisma.PrismaClientOptions = Prisma.PrismaClientOptions,
  U = 'log' extends keyof ClientOptions ? ClientOptions['log'] extends Array<Prisma.LogLevel | Prisma.LogDefinition> ? Prisma.GetEvents<ClientOptions['log']> : never : never,
  ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs
> {
  [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['other'] }

    /**
   * ##  Prisma Client ʲˢ
   *
   * Type-safe database client for TypeScript & Node.js
   * @example
   * ```
   * const prisma = new PrismaClient()
   * // Fetch zero or more Ads
   * const ads = await prisma.ad.findMany()
   * ```
   *
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
   */

  constructor(optionsArg ?: Prisma.Subset<ClientOptions, Prisma.PrismaClientOptions>);
  $on<V extends U>(eventType: V, callback: (event: V extends 'query' ? Prisma.QueryEvent : Prisma.LogEvent) => void): void;

  /**
   * Connect with the database
   */
  $connect(): $Utils.JsPromise<void>;

  /**
   * Disconnect from the database
   */
  $disconnect(): $Utils.JsPromise<void>;

  /**
   * Add a middleware
   * @deprecated since 4.16.0. For new code, prefer client extensions instead.
   * @see https://pris.ly/d/extensions
   */
  $use(cb: Prisma.Middleware): void

/**
   * Executes a prepared raw query and returns the number of affected rows.
   * @example
   * ```
   * const result = await prisma.$executeRaw`UPDATE User SET cool = ${true} WHERE email = ${'user@email.com'};`
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Executes a raw query and returns the number of affected rows.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$executeRawUnsafe('UPDATE User SET cool = $1 WHERE email = $2 ;', true, 'user@email.com')
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Performs a prepared raw query and returns the `SELECT` data.
   * @example
   * ```
   * const result = await prisma.$queryRaw`SELECT * FROM User WHERE id = ${1} OR email = ${'user@email.com'};`
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<T>;

  /**
   * Performs a raw query and returns the `SELECT` data.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$queryRawUnsafe('SELECT * FROM User WHERE id = $1 OR email = $2;', 1, 'user@email.com')
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<T>;


  /**
   * Allows the running of a sequence of read/write operations that are guaranteed to either succeed or fail as a whole.
   * @example
   * ```
   * const [george, bob, alice] = await prisma.$transaction([
   *   prisma.user.create({ data: { name: 'George' } }),
   *   prisma.user.create({ data: { name: 'Bob' } }),
   *   prisma.user.create({ data: { name: 'Alice' } }),
   * ])
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/concepts/components/prisma-client/transactions).
   */
  $transaction<P extends Prisma.PrismaPromise<any>[]>(arg: [...P], options?: { isolationLevel?: Prisma.TransactionIsolationLevel }): $Utils.JsPromise<runtime.Types.Utils.UnwrapTuple<P>>

  $transaction<R>(fn: (prisma: Omit<PrismaClient, runtime.ITXClientDenyList>) => $Utils.JsPromise<R>, options?: { maxWait?: number, timeout?: number, isolationLevel?: Prisma.TransactionIsolationLevel }): $Utils.JsPromise<R>


  $extends: $Extensions.ExtendsHook<"extends", Prisma.TypeMapCb, ExtArgs, $Utils.Call<Prisma.TypeMapCb, {
    extArgs: ExtArgs
  }>, ClientOptions>

      /**
   * `prisma.ad`: Exposes CRUD operations for the **ad** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Ads
    * const ads = await prisma.ad.findMany()
    * ```
    */
  get ad(): Prisma.adDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.request`: Exposes CRUD operations for the **request** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Requests
    * const requests = await prisma.request.findMany()
    * ```
    */
  get request(): Prisma.requestDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.session`: Exposes CRUD operations for the **session** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Sessions
    * const sessions = await prisma.session.findMany()
    * ```
    */
  get session(): Prisma.sessionDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.user`: Exposes CRUD operations for the **user** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Users
    * const users = await prisma.user.findMany()
    * ```
    */
  get user(): Prisma.userDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.views`: Exposes CRUD operations for the **views** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Views
    * const views = await prisma.views.findMany()
    * ```
    */
  get views(): Prisma.viewsDelegate<ExtArgs, ClientOptions>;
}

export namespace Prisma {
  export import DMMF = runtime.DMMF

  export type PrismaPromise<T> = $Public.PrismaPromise<T>

  /**
   * Validator
   */
  export import validator = runtime.Public.validator

  /**
   * Prisma Errors
   */
  export import PrismaClientKnownRequestError = runtime.PrismaClientKnownRequestError
  export import PrismaClientUnknownRequestError = runtime.PrismaClientUnknownRequestError
  export import PrismaClientRustPanicError = runtime.PrismaClientRustPanicError
  export import PrismaClientInitializationError = runtime.PrismaClientInitializationError
  export import PrismaClientValidationError = runtime.PrismaClientValidationError

  /**
   * Re-export of sql-template-tag
   */
  export import sql = runtime.sqltag
  export import empty = runtime.empty
  export import join = runtime.join
  export import raw = runtime.raw
  export import Sql = runtime.Sql



  /**
   * Decimal.js
   */
  export import Decimal = runtime.Decimal

  export type DecimalJsLike = runtime.DecimalJsLike

  /**
   * Metrics
   */
  export type Metrics = runtime.Metrics
  export type Metric<T> = runtime.Metric<T>
  export type MetricHistogram = runtime.MetricHistogram
  export type MetricHistogramBucket = runtime.MetricHistogramBucket

  /**
  * Extensions
  */
  export import Extension = $Extensions.UserArgs
  export import getExtensionContext = runtime.Extensions.getExtensionContext
  export import Args = $Public.Args
  export import Payload = $Public.Payload
  export import Result = $Public.Result
  export import Exact = $Public.Exact

  /**
   * Prisma Client JS version: 6.3.1
   * Query Engine version: acc0b9dd43eb689cbd20c9470515d719db10d0b0
   */
  export type PrismaVersion = {
    client: string
  }

  export const prismaVersion: PrismaVersion

  /**
   * Utility Types
   */


  export import JsonObject = runtime.JsonObject
  export import JsonArray = runtime.JsonArray
  export import JsonValue = runtime.JsonValue
  export import InputJsonObject = runtime.InputJsonObject
  export import InputJsonArray = runtime.InputJsonArray
  export import InputJsonValue = runtime.InputJsonValue

  /**
   * Types of the values used to represent different kinds of `null` values when working with JSON fields.
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  namespace NullTypes {
    /**
    * Type of `Prisma.DbNull`.
    *
    * You cannot use other instances of this class. Please use the `Prisma.DbNull` value.
    *
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class DbNull {
      private DbNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.JsonNull`.
    *
    * You cannot use other instances of this class. Please use the `Prisma.JsonNull` value.
    *
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class JsonNull {
      private JsonNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.AnyNull`.
    *
    * You cannot use other instances of this class. Please use the `Prisma.AnyNull` value.
    *
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class AnyNull {
      private AnyNull: never
      private constructor()
    }
  }

  /**
   * Helper for filtering JSON entries that have `null` on the database (empty on the db)
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const DbNull: NullTypes.DbNull

  /**
   * Helper for filtering JSON entries that have JSON `null` values (not empty on the db)
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const JsonNull: NullTypes.JsonNull

  /**
   * Helper for filtering JSON entries that are `Prisma.DbNull` or `Prisma.JsonNull`
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const AnyNull: NullTypes.AnyNull

  type SelectAndInclude = {
    select: any
    include: any
  }

  type SelectAndOmit = {
    select: any
    omit: any
  }

  /**
   * Get the type of the value, that the Promise holds.
   */
  export type PromiseType<T extends PromiseLike<any>> = T extends PromiseLike<infer U> ? U : T;

  /**
   * Get the return type of a function which returns a Promise.
   */
  export type PromiseReturnType<T extends (...args: any) => $Utils.JsPromise<any>> = PromiseType<ReturnType<T>>

  /**
   * From T, pick a set of properties whose keys are in the union K
   */
  type Prisma__Pick<T, K extends keyof T> = {
      [P in K]: T[P];
  };


  export type Enumerable<T> = T | Array<T>;

  export type RequiredKeys<T> = {
    [K in keyof T]-?: {} extends Prisma__Pick<T, K> ? never : K
  }[keyof T]

  export type TruthyKeys<T> = keyof {
    [K in keyof T as T[K] extends false | undefined | null ? never : K]: K
  }

  export type TrueKeys<T> = TruthyKeys<Prisma__Pick<T, RequiredKeys<T>>>

  /**
   * Subset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection
   */
  export type Subset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never;
  };

  /**
   * SelectSubset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection.
   * Additionally, it validates, if both select and include are present. If the case, it errors.
   */
  export type SelectSubset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    (T extends SelectAndInclude
      ? 'Please either choose `select` or `include`.'
      : T extends SelectAndOmit
        ? 'Please either choose `select` or `omit`.'
        : {})

  /**
   * Subset + Intersection
   * @desc From `T` pick properties that exist in `U` and intersect `K`
   */
  export type SubsetIntersection<T, U, K> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    K

  type Without<T, U> = { [P in Exclude<keyof T, keyof U>]?: never };

  /**
   * XOR is needed to have a real mutually exclusive union type
   * https://stackoverflow.com/questions/42123407/does-typescript-support-mutually-exclusive-types
   */
  type XOR<T, U> =
    T extends object ?
    U extends object ?
      (Without<T, U> & U) | (Without<U, T> & T)
    : U : T


  /**
   * Is T a Record?
   */
  type IsObject<T extends any> = T extends Array<any>
  ? False
  : T extends Date
  ? False
  : T extends Uint8Array
  ? False
  : T extends BigInt
  ? False
  : T extends object
  ? True
  : False


  /**
   * If it's T[], return T
   */
  export type UnEnumerate<T extends unknown> = T extends Array<infer U> ? U : T

  /**
   * From ts-toolbelt
   */

  type __Either<O extends object, K extends Key> = Omit<O, K> &
    {
      // Merge all but K
      [P in K]: Prisma__Pick<O, P & keyof O> // With K possibilities
    }[K]

  type EitherStrict<O extends object, K extends Key> = Strict<__Either<O, K>>

  type EitherLoose<O extends object, K extends Key> = ComputeRaw<__Either<O, K>>

  type _Either<
    O extends object,
    K extends Key,
    strict extends Boolean
  > = {
    1: EitherStrict<O, K>
    0: EitherLoose<O, K>
  }[strict]

  type Either<
    O extends object,
    K extends Key,
    strict extends Boolean = 1
  > = O extends unknown ? _Either<O, K, strict> : never

  export type Union = any

  type PatchUndefined<O extends object, O1 extends object> = {
    [K in keyof O]: O[K] extends undefined ? At<O1, K> : O[K]
  } & {}

  /** Helper Types for "Merge" **/
  export type IntersectOf<U extends Union> = (
    U extends unknown ? (k: U) => void : never
  ) extends (k: infer I) => void
    ? I
    : never

  export type Overwrite<O extends object, O1 extends object> = {
      [K in keyof O]: K extends keyof O1 ? O1[K] : O[K];
  } & {};

  type _Merge<U extends object> = IntersectOf<Overwrite<U, {
      [K in keyof U]-?: At<U, K>;
  }>>;

  type Key = string | number | symbol;
  type AtBasic<O extends object, K extends Key> = K extends keyof O ? O[K] : never;
  type AtStrict<O extends object, K extends Key> = O[K & keyof O];
  type AtLoose<O extends object, K extends Key> = O extends unknown ? AtStrict<O, K> : never;
  export type At<O extends object, K extends Key, strict extends Boolean = 1> = {
      1: AtStrict<O, K>;
      0: AtLoose<O, K>;
  }[strict];

  export type ComputeRaw<A extends any> = A extends Function ? A : {
    [K in keyof A]: A[K];
  } & {};

  export type OptionalFlat<O> = {
    [K in keyof O]?: O[K];
  } & {};

  type _Record<K extends keyof any, T> = {
    [P in K]: T;
  };

  // cause typescript not to expand types and preserve names
  type NoExpand<T> = T extends unknown ? T : never;

  // this type assumes the passed object is entirely optional
  type AtLeast<O extends object, K extends string> = NoExpand<
    O extends unknown
    ? | (K extends keyof O ? { [P in K]: O[P] } & O : O)
      | {[P in keyof O as P extends K ? K : never]-?: O[P]} & O
    : never>;

  type _Strict<U, _U = U> = U extends unknown ? U & OptionalFlat<_Record<Exclude<Keys<_U>, keyof U>, never>> : never;

  export type Strict<U extends object> = ComputeRaw<_Strict<U>>;
  /** End Helper Types for "Merge" **/

  export type Merge<U extends object> = ComputeRaw<_Merge<Strict<U>>>;

  /**
  A [[Boolean]]
  */
  export type Boolean = True | False

  // /**
  // 1
  // */
  export type True = 1

  /**
  0
  */
  export type False = 0

  export type Not<B extends Boolean> = {
    0: 1
    1: 0
  }[B]

  export type Extends<A1 extends any, A2 extends any> = [A1] extends [never]
    ? 0 // anything `never` is false
    : A1 extends A2
    ? 1
    : 0

  export type Has<U extends Union, U1 extends Union> = Not<
    Extends<Exclude<U1, U>, U1>
  >

  export type Or<B1 extends Boolean, B2 extends Boolean> = {
    0: {
      0: 0
      1: 1
    }
    1: {
      0: 1
      1: 1
    }
  }[B1][B2]

  export type Keys<U extends Union> = U extends unknown ? keyof U : never

  type Cast<A, B> = A extends B ? A : B;

  export const type: unique symbol;



  /**
   * Used by group by
   */

  export type GetScalarType<T, O> = O extends object ? {
    [P in keyof T]: P extends keyof O
      ? O[P]
      : never
  } : never

  type FieldPaths<
    T,
    U = Omit<T, '_avg' | '_sum' | '_count' | '_min' | '_max'>
  > = IsObject<T> extends True ? U : T

  type GetHavingFields<T> = {
    [K in keyof T]: Or<
      Or<Extends<'OR', K>, Extends<'AND', K>>,
      Extends<'NOT', K>
    > extends True
      ? // infer is only needed to not hit TS limit
        // based on the brilliant idea of Pierre-Antoine Mills
        // https://github.com/microsoft/TypeScript/issues/30188#issuecomment-478938437
        T[K] extends infer TK
        ? GetHavingFields<UnEnumerate<TK> extends object ? Merge<UnEnumerate<TK>> : never>
        : never
      : {} extends FieldPaths<T[K]>
      ? never
      : K
  }[keyof T]

  /**
   * Convert tuple to union
   */
  type _TupleToUnion<T> = T extends (infer E)[] ? E : never
  type TupleToUnion<K extends readonly any[]> = _TupleToUnion<K>
  type MaybeTupleToUnion<T> = T extends any[] ? TupleToUnion<T> : T

  /**
   * Like `Pick`, but additionally can also accept an array of keys
   */
  type PickEnumerable<T, K extends Enumerable<keyof T> | keyof T> = Prisma__Pick<T, MaybeTupleToUnion<K>>

  /**
   * Exclude all keys with underscores
   */
  type ExcludeUnderscoreKeys<T extends string> = T extends `_${string}` ? never : T


  export type FieldRef<Model, FieldType> = runtime.FieldRef<Model, FieldType>

  type FieldRefInputType<Model, FieldType> = Model extends never ? never : FieldRef<Model, FieldType>


  export const ModelName: {
    ad: 'ad',
    request: 'request',
    session: 'session',
    user: 'user',
    views: 'views'
  };

  export type ModelName = (typeof ModelName)[keyof typeof ModelName]


  export type Datasources = {
    db?: Datasource
  }

  interface TypeMapCb extends $Utils.Fn<{extArgs: $Extensions.InternalArgs, clientOptions: PrismaClientOptions }, $Utils.Record<string, any>> {
    returns: Prisma.TypeMap<this['params']['extArgs'], this['params']['clientOptions']>
  }

  export type TypeMap<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> = {
    meta: {
      modelProps: "ad" | "request" | "session" | "user" | "views"
      txIsolationLevel: Prisma.TransactionIsolationLevel
    }
    model: {
      ad: {
        payload: Prisma.$adPayload<ExtArgs>
        fields: Prisma.adFieldRefs
        operations: {
          findUnique: {
            args: Prisma.adFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$adPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.adFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$adPayload>
          }
          findFirst: {
            args: Prisma.adFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$adPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.adFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$adPayload>
          }
          findMany: {
            args: Prisma.adFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$adPayload>[]
          }
          create: {
            args: Prisma.adCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$adPayload>
          }
          createMany: {
            args: Prisma.adCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.adDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$adPayload>
          }
          update: {
            args: Prisma.adUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$adPayload>
          }
          deleteMany: {
            args: Prisma.adDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.adUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.adUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$adPayload>
          }
          aggregate: {
            args: Prisma.AdAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateAd>
          }
          groupBy: {
            args: Prisma.adGroupByArgs<ExtArgs>
            result: $Utils.Optional<AdGroupByOutputType>[]
          }
          count: {
            args: Prisma.adCountArgs<ExtArgs>
            result: $Utils.Optional<AdCountAggregateOutputType> | number
          }
        }
      }
      request: {
        payload: Prisma.$requestPayload<ExtArgs>
        fields: Prisma.requestFieldRefs
        operations: {
          findUnique: {
            args: Prisma.requestFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$requestPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.requestFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$requestPayload>
          }
          findFirst: {
            args: Prisma.requestFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$requestPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.requestFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$requestPayload>
          }
          findMany: {
            args: Prisma.requestFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$requestPayload>[]
          }
          create: {
            args: Prisma.requestCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$requestPayload>
          }
          createMany: {
            args: Prisma.requestCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.requestDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$requestPayload>
          }
          update: {
            args: Prisma.requestUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$requestPayload>
          }
          deleteMany: {
            args: Prisma.requestDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.requestUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.requestUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$requestPayload>
          }
          aggregate: {
            args: Prisma.RequestAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateRequest>
          }
          groupBy: {
            args: Prisma.requestGroupByArgs<ExtArgs>
            result: $Utils.Optional<RequestGroupByOutputType>[]
          }
          count: {
            args: Prisma.requestCountArgs<ExtArgs>
            result: $Utils.Optional<RequestCountAggregateOutputType> | number
          }
        }
      }
      session: {
        payload: Prisma.$sessionPayload<ExtArgs>
        fields: Prisma.sessionFieldRefs
        operations: {
          findUnique: {
            args: Prisma.sessionFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$sessionPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.sessionFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$sessionPayload>
          }
          findFirst: {
            args: Prisma.sessionFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$sessionPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.sessionFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$sessionPayload>
          }
          findMany: {
            args: Prisma.sessionFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$sessionPayload>[]
          }
          create: {
            args: Prisma.sessionCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$sessionPayload>
          }
          createMany: {
            args: Prisma.sessionCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.sessionDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$sessionPayload>
          }
          update: {
            args: Prisma.sessionUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$sessionPayload>
          }
          deleteMany: {
            args: Prisma.sessionDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.sessionUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.sessionUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$sessionPayload>
          }
          aggregate: {
            args: Prisma.SessionAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateSession>
          }
          groupBy: {
            args: Prisma.sessionGroupByArgs<ExtArgs>
            result: $Utils.Optional<SessionGroupByOutputType>[]
          }
          count: {
            args: Prisma.sessionCountArgs<ExtArgs>
            result: $Utils.Optional<SessionCountAggregateOutputType> | number
          }
        }
      }
      user: {
        payload: Prisma.$userPayload<ExtArgs>
        fields: Prisma.userFieldRefs
        operations: {
          findUnique: {
            args: Prisma.userFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.userFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userPayload>
          }
          findFirst: {
            args: Prisma.userFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.userFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userPayload>
          }
          findMany: {
            args: Prisma.userFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userPayload>[]
          }
          create: {
            args: Prisma.userCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userPayload>
          }
          createMany: {
            args: Prisma.userCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.userDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userPayload>
          }
          update: {
            args: Prisma.userUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userPayload>
          }
          deleteMany: {
            args: Prisma.userDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.userUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.userUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userPayload>
          }
          aggregate: {
            args: Prisma.UserAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateUser>
          }
          groupBy: {
            args: Prisma.userGroupByArgs<ExtArgs>
            result: $Utils.Optional<UserGroupByOutputType>[]
          }
          count: {
            args: Prisma.userCountArgs<ExtArgs>
            result: $Utils.Optional<UserCountAggregateOutputType> | number
          }
        }
      }
      views: {
        payload: Prisma.$viewsPayload<ExtArgs>
        fields: Prisma.viewsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.viewsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$viewsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.viewsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$viewsPayload>
          }
          findFirst: {
            args: Prisma.viewsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$viewsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.viewsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$viewsPayload>
          }
          findMany: {
            args: Prisma.viewsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$viewsPayload>[]
          }
          create: {
            args: Prisma.viewsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$viewsPayload>
          }
          createMany: {
            args: Prisma.viewsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.viewsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$viewsPayload>
          }
          update: {
            args: Prisma.viewsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$viewsPayload>
          }
          deleteMany: {
            args: Prisma.viewsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.viewsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.viewsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$viewsPayload>
          }
          aggregate: {
            args: Prisma.ViewsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateViews>
          }
          groupBy: {
            args: Prisma.viewsGroupByArgs<ExtArgs>
            result: $Utils.Optional<ViewsGroupByOutputType>[]
          }
          count: {
            args: Prisma.viewsCountArgs<ExtArgs>
            result: $Utils.Optional<ViewsCountAggregateOutputType> | number
          }
        }
      }
    }
  } & {
    other: {
      payload: any
      operations: {
        $executeRaw: {
          args: [query: TemplateStringsArray | Prisma.Sql, ...values: any[]],
          result: any
        }
        $executeRawUnsafe: {
          args: [query: string, ...values: any[]],
          result: any
        }
        $queryRaw: {
          args: [query: TemplateStringsArray | Prisma.Sql, ...values: any[]],
          result: any
        }
        $queryRawUnsafe: {
          args: [query: string, ...values: any[]],
          result: any
        }
      }
    }
  }
  export const defineExtension: $Extensions.ExtendsHook<"define", Prisma.TypeMapCb, $Extensions.DefaultArgs>
  export type DefaultPrismaClient = PrismaClient
  export type ErrorFormat = 'pretty' | 'colorless' | 'minimal'
  export interface PrismaClientOptions {
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasources?: Datasources
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasourceUrl?: string
    /**
     * @default "colorless"
     */
    errorFormat?: ErrorFormat
    /**
     * @example
     * ```
     * // Defaults to stdout
     * log: ['query', 'info', 'warn', 'error']
     * 
     * // Emit as events
     * log: [
     *   { emit: 'stdout', level: 'query' },
     *   { emit: 'stdout', level: 'info' },
     *   { emit: 'stdout', level: 'warn' }
     *   { emit: 'stdout', level: 'error' }
     * ]
     * ```
     * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/logging#the-log-option).
     */
    log?: (LogLevel | LogDefinition)[]
    /**
     * The default values for transactionOptions
     * maxWait ?= 2000
     * timeout ?= 5000
     */
    transactionOptions?: {
      maxWait?: number
      timeout?: number
      isolationLevel?: Prisma.TransactionIsolationLevel
    }
    /**
     * Global configuration for omitting model fields by default.
     * 
     * @example
     * ```
     * const prisma = new PrismaClient({
     *   omit: {
     *     user: {
     *       password: true
     *     }
     *   }
     * })
     * ```
     */
    omit?: Prisma.GlobalOmitConfig
  }
  export type GlobalOmitConfig = {
    ad?: adOmit
    request?: requestOmit
    session?: sessionOmit
    user?: userOmit
    views?: viewsOmit
  }

  /* Types for Logging */
  export type LogLevel = 'info' | 'query' | 'warn' | 'error'
  export type LogDefinition = {
    level: LogLevel
    emit: 'stdout' | 'event'
  }

  export type GetLogType<T extends LogLevel | LogDefinition> = T extends LogDefinition ? T['emit'] extends 'event' ? T['level'] : never : never
  export type GetEvents<T extends any> = T extends Array<LogLevel | LogDefinition> ?
    GetLogType<T[0]> | GetLogType<T[1]> | GetLogType<T[2]> | GetLogType<T[3]>
    : never

  export type QueryEvent = {
    timestamp: Date
    query: string
    params: string
    duration: number
    target: string
  }

  export type LogEvent = {
    timestamp: Date
    message: string
    target: string
  }
  /* End Types for Logging */


  export type PrismaAction =
    | 'findUnique'
    | 'findUniqueOrThrow'
    | 'findMany'
    | 'findFirst'
    | 'findFirstOrThrow'
    | 'create'
    | 'createMany'
    | 'createManyAndReturn'
    | 'update'
    | 'updateMany'
    | 'updateManyAndReturn'
    | 'upsert'
    | 'delete'
    | 'deleteMany'
    | 'executeRaw'
    | 'queryRaw'
    | 'aggregate'
    | 'count'
    | 'runCommandRaw'
    | 'findRaw'
    | 'groupBy'

  /**
   * These options are being passed into the middleware as "params"
   */
  export type MiddlewareParams = {
    model?: ModelName
    action: PrismaAction
    args: any
    dataPath: string[]
    runInTransaction: boolean
  }

  /**
   * The `T` type makes sure, that the `return proceed` is not forgotten in the middleware implementation
   */
  export type Middleware<T = any> = (
    params: MiddlewareParams,
    next: (params: MiddlewareParams) => $Utils.JsPromise<T>,
  ) => $Utils.JsPromise<T>

  // tested in getLogLevel.test.ts
  export function getLogLevel(log: Array<LogLevel | LogDefinition>): LogLevel | undefined;

  /**
   * `PrismaClient` proxy available in interactive transactions.
   */
  export type TransactionClient = Omit<Prisma.DefaultPrismaClient, runtime.ITXClientDenyList>

  export type Datasource = {
    url?: string
  }

  /**
   * Count Types
   */


  /**
   * Count Type AdCountOutputType
   */

  export type AdCountOutputType = {
    request_request_adToad: number
    views_views_adToad: number
  }

  export type AdCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    request_request_adToad?: boolean | AdCountOutputTypeCountRequest_request_adToadArgs
    views_views_adToad?: boolean | AdCountOutputTypeCountViews_views_adToadArgs
  }

  // Custom InputTypes
  /**
   * AdCountOutputType without action
   */
  export type AdCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AdCountOutputType
     */
    select?: AdCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * AdCountOutputType without action
   */
  export type AdCountOutputTypeCountRequest_request_adToadArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: requestWhereInput
  }

  /**
   * AdCountOutputType without action
   */
  export type AdCountOutputTypeCountViews_views_adToadArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: viewsWhereInput
  }


  /**
   * Count Type UserCountOutputType
   */

  export type UserCountOutputType = {
    ad: number
    request_request_userTouser: number
    session: number
    views_views_userTouser: number
  }

  export type UserCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    ad?: boolean | UserCountOutputTypeCountAdArgs
    request_request_userTouser?: boolean | UserCountOutputTypeCountRequest_request_userTouserArgs
    session?: boolean | UserCountOutputTypeCountSessionArgs
    views_views_userTouser?: boolean | UserCountOutputTypeCountViews_views_userTouserArgs
  }

  // Custom InputTypes
  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserCountOutputType
     */
    select?: UserCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountAdArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: adWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountRequest_request_userTouserArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: requestWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountSessionArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: sessionWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountViews_views_userTouserArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: viewsWhereInput
  }


  /**
   * Models
   */

  /**
   * Model ad
   */

  export type AggregateAd = {
    _count: AdCountAggregateOutputType | null
    _avg: AdAvgAggregateOutputType | null
    _sum: AdSumAggregateOutputType | null
    _min: AdMinAggregateOutputType | null
    _max: AdMaxAggregateOutputType | null
  }

  export type AdAvgAggregateOutputType = {
    views: number | null
    targetViews: number | null
  }

  export type AdSumAggregateOutputType = {
    views: number | null
    targetViews: number | null
  }

  export type AdMinAggregateOutputType = {
    id: string | null
    name: string | null
    path: string | null
    views: number | null
    targetViews: number | null
    image: string | null
    type: $Enums.ad_type | null
    category: $Enums.ad_category | null
    creation_date: Date | null
    renewal_date: Date | null
    isPublished: boolean | null
    keywords: string | null
    userid: string | null
  }

  export type AdMaxAggregateOutputType = {
    id: string | null
    name: string | null
    path: string | null
    views: number | null
    targetViews: number | null
    image: string | null
    type: $Enums.ad_type | null
    category: $Enums.ad_category | null
    creation_date: Date | null
    renewal_date: Date | null
    isPublished: boolean | null
    keywords: string | null
    userid: string | null
  }

  export type AdCountAggregateOutputType = {
    id: number
    name: number
    path: number
    views: number
    targetViews: number
    image: number
    type: number
    category: number
    creation_date: number
    renewal_date: number
    isPublished: number
    keywords: number
    userid: number
    _all: number
  }


  export type AdAvgAggregateInputType = {
    views?: true
    targetViews?: true
  }

  export type AdSumAggregateInputType = {
    views?: true
    targetViews?: true
  }

  export type AdMinAggregateInputType = {
    id?: true
    name?: true
    path?: true
    views?: true
    targetViews?: true
    image?: true
    type?: true
    category?: true
    creation_date?: true
    renewal_date?: true
    isPublished?: true
    keywords?: true
    userid?: true
  }

  export type AdMaxAggregateInputType = {
    id?: true
    name?: true
    path?: true
    views?: true
    targetViews?: true
    image?: true
    type?: true
    category?: true
    creation_date?: true
    renewal_date?: true
    isPublished?: true
    keywords?: true
    userid?: true
  }

  export type AdCountAggregateInputType = {
    id?: true
    name?: true
    path?: true
    views?: true
    targetViews?: true
    image?: true
    type?: true
    category?: true
    creation_date?: true
    renewal_date?: true
    isPublished?: true
    keywords?: true
    userid?: true
    _all?: true
  }

  export type AdAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ad to aggregate.
     */
    where?: adWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ads to fetch.
     */
    orderBy?: adOrderByWithRelationInput | adOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: adWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ads from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ads.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned ads
    **/
    _count?: true | AdCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: AdAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: AdSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: AdMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: AdMaxAggregateInputType
  }

  export type GetAdAggregateType<T extends AdAggregateArgs> = {
        [P in keyof T & keyof AggregateAd]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateAd[P]>
      : GetScalarType<T[P], AggregateAd[P]>
  }




  export type adGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: adWhereInput
    orderBy?: adOrderByWithAggregationInput | adOrderByWithAggregationInput[]
    by: AdScalarFieldEnum[] | AdScalarFieldEnum
    having?: adScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: AdCountAggregateInputType | true
    _avg?: AdAvgAggregateInputType
    _sum?: AdSumAggregateInputType
    _min?: AdMinAggregateInputType
    _max?: AdMaxAggregateInputType
  }

  export type AdGroupByOutputType = {
    id: string
    name: string
    path: string
    views: number
    targetViews: number
    image: string
    type: $Enums.ad_type
    category: $Enums.ad_category
    creation_date: Date
    renewal_date: Date
    isPublished: boolean
    keywords: string
    userid: string
    _count: AdCountAggregateOutputType | null
    _avg: AdAvgAggregateOutputType | null
    _sum: AdSumAggregateOutputType | null
    _min: AdMinAggregateOutputType | null
    _max: AdMaxAggregateOutputType | null
  }

  type GetAdGroupByPayload<T extends adGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<AdGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof AdGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], AdGroupByOutputType[P]>
            : GetScalarType<T[P], AdGroupByOutputType[P]>
        }
      >
    >


  export type adSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    path?: boolean
    views?: boolean
    targetViews?: boolean
    image?: boolean
    type?: boolean
    category?: boolean
    creation_date?: boolean
    renewal_date?: boolean
    isPublished?: boolean
    keywords?: boolean
    userid?: boolean
    user?: boolean | userDefaultArgs<ExtArgs>
    request_request_adToad?: boolean | ad$request_request_adToadArgs<ExtArgs>
    views_views_adToad?: boolean | ad$views_views_adToadArgs<ExtArgs>
    _count?: boolean | AdCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["ad"]>



  export type adSelectScalar = {
    id?: boolean
    name?: boolean
    path?: boolean
    views?: boolean
    targetViews?: boolean
    image?: boolean
    type?: boolean
    category?: boolean
    creation_date?: boolean
    renewal_date?: boolean
    isPublished?: boolean
    keywords?: boolean
    userid?: boolean
  }

  export type adOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "name" | "path" | "views" | "targetViews" | "image" | "type" | "category" | "creation_date" | "renewal_date" | "isPublished" | "keywords" | "userid", ExtArgs["result"]["ad"]>
  export type adInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | userDefaultArgs<ExtArgs>
    request_request_adToad?: boolean | ad$request_request_adToadArgs<ExtArgs>
    views_views_adToad?: boolean | ad$views_views_adToadArgs<ExtArgs>
    _count?: boolean | AdCountOutputTypeDefaultArgs<ExtArgs>
  }

  export type $adPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "ad"
    objects: {
      user: Prisma.$userPayload<ExtArgs>
      request_request_adToad: Prisma.$requestPayload<ExtArgs>[]
      views_views_adToad: Prisma.$viewsPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      name: string
      path: string
      views: number
      targetViews: number
      image: string
      type: $Enums.ad_type
      category: $Enums.ad_category
      creation_date: Date
      renewal_date: Date
      isPublished: boolean
      keywords: string
      userid: string
    }, ExtArgs["result"]["ad"]>
    composites: {}
  }

  type adGetPayload<S extends boolean | null | undefined | adDefaultArgs> = $Result.GetResult<Prisma.$adPayload, S>

  type adCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<adFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: AdCountAggregateInputType | true
    }

  export interface adDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['ad'], meta: { name: 'ad' } }
    /**
     * Find zero or one Ad that matches the filter.
     * @param {adFindUniqueArgs} args - Arguments to find a Ad
     * @example
     * // Get one Ad
     * const ad = await prisma.ad.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends adFindUniqueArgs>(args: SelectSubset<T, adFindUniqueArgs<ExtArgs>>): Prisma__adClient<$Result.GetResult<Prisma.$adPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Ad that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {adFindUniqueOrThrowArgs} args - Arguments to find a Ad
     * @example
     * // Get one Ad
     * const ad = await prisma.ad.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends adFindUniqueOrThrowArgs>(args: SelectSubset<T, adFindUniqueOrThrowArgs<ExtArgs>>): Prisma__adClient<$Result.GetResult<Prisma.$adPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Ad that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {adFindFirstArgs} args - Arguments to find a Ad
     * @example
     * // Get one Ad
     * const ad = await prisma.ad.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends adFindFirstArgs>(args?: SelectSubset<T, adFindFirstArgs<ExtArgs>>): Prisma__adClient<$Result.GetResult<Prisma.$adPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Ad that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {adFindFirstOrThrowArgs} args - Arguments to find a Ad
     * @example
     * // Get one Ad
     * const ad = await prisma.ad.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends adFindFirstOrThrowArgs>(args?: SelectSubset<T, adFindFirstOrThrowArgs<ExtArgs>>): Prisma__adClient<$Result.GetResult<Prisma.$adPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Ads that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {adFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Ads
     * const ads = await prisma.ad.findMany()
     * 
     * // Get first 10 Ads
     * const ads = await prisma.ad.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const adWithIdOnly = await prisma.ad.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends adFindManyArgs>(args?: SelectSubset<T, adFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$adPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Ad.
     * @param {adCreateArgs} args - Arguments to create a Ad.
     * @example
     * // Create one Ad
     * const Ad = await prisma.ad.create({
     *   data: {
     *     // ... data to create a Ad
     *   }
     * })
     * 
     */
    create<T extends adCreateArgs>(args: SelectSubset<T, adCreateArgs<ExtArgs>>): Prisma__adClient<$Result.GetResult<Prisma.$adPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Ads.
     * @param {adCreateManyArgs} args - Arguments to create many Ads.
     * @example
     * // Create many Ads
     * const ad = await prisma.ad.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends adCreateManyArgs>(args?: SelectSubset<T, adCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Ad.
     * @param {adDeleteArgs} args - Arguments to delete one Ad.
     * @example
     * // Delete one Ad
     * const Ad = await prisma.ad.delete({
     *   where: {
     *     // ... filter to delete one Ad
     *   }
     * })
     * 
     */
    delete<T extends adDeleteArgs>(args: SelectSubset<T, adDeleteArgs<ExtArgs>>): Prisma__adClient<$Result.GetResult<Prisma.$adPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Ad.
     * @param {adUpdateArgs} args - Arguments to update one Ad.
     * @example
     * // Update one Ad
     * const ad = await prisma.ad.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends adUpdateArgs>(args: SelectSubset<T, adUpdateArgs<ExtArgs>>): Prisma__adClient<$Result.GetResult<Prisma.$adPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Ads.
     * @param {adDeleteManyArgs} args - Arguments to filter Ads to delete.
     * @example
     * // Delete a few Ads
     * const { count } = await prisma.ad.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends adDeleteManyArgs>(args?: SelectSubset<T, adDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Ads.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {adUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Ads
     * const ad = await prisma.ad.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends adUpdateManyArgs>(args: SelectSubset<T, adUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Ad.
     * @param {adUpsertArgs} args - Arguments to update or create a Ad.
     * @example
     * // Update or create a Ad
     * const ad = await prisma.ad.upsert({
     *   create: {
     *     // ... data to create a Ad
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Ad we want to update
     *   }
     * })
     */
    upsert<T extends adUpsertArgs>(args: SelectSubset<T, adUpsertArgs<ExtArgs>>): Prisma__adClient<$Result.GetResult<Prisma.$adPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of Ads.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {adCountArgs} args - Arguments to filter Ads to count.
     * @example
     * // Count the number of Ads
     * const count = await prisma.ad.count({
     *   where: {
     *     // ... the filter for the Ads we want to count
     *   }
     * })
    **/
    count<T extends adCountArgs>(
      args?: Subset<T, adCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], AdCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Ad.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AdAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends AdAggregateArgs>(args: Subset<T, AdAggregateArgs>): Prisma.PrismaPromise<GetAdAggregateType<T>>

    /**
     * Group by Ad.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {adGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends adGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: adGroupByArgs['orderBy'] }
        : { orderBy?: adGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, adGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetAdGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the ad model
   */
  readonly fields: adFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for ad.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__adClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    user<T extends userDefaultArgs<ExtArgs> = {}>(args?: Subset<T, userDefaultArgs<ExtArgs>>): Prisma__userClient<$Result.GetResult<Prisma.$userPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    request_request_adToad<T extends ad$request_request_adToadArgs<ExtArgs> = {}>(args?: Subset<T, ad$request_request_adToadArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$requestPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    views_views_adToad<T extends ad$views_views_adToadArgs<ExtArgs> = {}>(args?: Subset<T, ad$views_views_adToadArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$viewsPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the ad model
   */ 
  interface adFieldRefs {
    readonly id: FieldRef<"ad", 'String'>
    readonly name: FieldRef<"ad", 'String'>
    readonly path: FieldRef<"ad", 'String'>
    readonly views: FieldRef<"ad", 'Int'>
    readonly targetViews: FieldRef<"ad", 'Int'>
    readonly image: FieldRef<"ad", 'String'>
    readonly type: FieldRef<"ad", 'ad_type'>
    readonly category: FieldRef<"ad", 'ad_category'>
    readonly creation_date: FieldRef<"ad", 'DateTime'>
    readonly renewal_date: FieldRef<"ad", 'DateTime'>
    readonly isPublished: FieldRef<"ad", 'Boolean'>
    readonly keywords: FieldRef<"ad", 'String'>
    readonly userid: FieldRef<"ad", 'String'>
  }
    

  // Custom InputTypes
  /**
   * ad findUnique
   */
  export type adFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ad
     */
    select?: adSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ad
     */
    omit?: adOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: adInclude<ExtArgs> | null
    /**
     * Filter, which ad to fetch.
     */
    where: adWhereUniqueInput
  }

  /**
   * ad findUniqueOrThrow
   */
  export type adFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ad
     */
    select?: adSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ad
     */
    omit?: adOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: adInclude<ExtArgs> | null
    /**
     * Filter, which ad to fetch.
     */
    where: adWhereUniqueInput
  }

  /**
   * ad findFirst
   */
  export type adFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ad
     */
    select?: adSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ad
     */
    omit?: adOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: adInclude<ExtArgs> | null
    /**
     * Filter, which ad to fetch.
     */
    where?: adWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ads to fetch.
     */
    orderBy?: adOrderByWithRelationInput | adOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ads.
     */
    cursor?: adWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ads from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ads.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ads.
     */
    distinct?: AdScalarFieldEnum | AdScalarFieldEnum[]
  }

  /**
   * ad findFirstOrThrow
   */
  export type adFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ad
     */
    select?: adSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ad
     */
    omit?: adOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: adInclude<ExtArgs> | null
    /**
     * Filter, which ad to fetch.
     */
    where?: adWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ads to fetch.
     */
    orderBy?: adOrderByWithRelationInput | adOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ads.
     */
    cursor?: adWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ads from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ads.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ads.
     */
    distinct?: AdScalarFieldEnum | AdScalarFieldEnum[]
  }

  /**
   * ad findMany
   */
  export type adFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ad
     */
    select?: adSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ad
     */
    omit?: adOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: adInclude<ExtArgs> | null
    /**
     * Filter, which ads to fetch.
     */
    where?: adWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ads to fetch.
     */
    orderBy?: adOrderByWithRelationInput | adOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing ads.
     */
    cursor?: adWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ads from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ads.
     */
    skip?: number
    distinct?: AdScalarFieldEnum | AdScalarFieldEnum[]
  }

  /**
   * ad create
   */
  export type adCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ad
     */
    select?: adSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ad
     */
    omit?: adOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: adInclude<ExtArgs> | null
    /**
     * The data needed to create a ad.
     */
    data: XOR<adCreateInput, adUncheckedCreateInput>
  }

  /**
   * ad createMany
   */
  export type adCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many ads.
     */
    data: adCreateManyInput | adCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * ad update
   */
  export type adUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ad
     */
    select?: adSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ad
     */
    omit?: adOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: adInclude<ExtArgs> | null
    /**
     * The data needed to update a ad.
     */
    data: XOR<adUpdateInput, adUncheckedUpdateInput>
    /**
     * Choose, which ad to update.
     */
    where: adWhereUniqueInput
  }

  /**
   * ad updateMany
   */
  export type adUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update ads.
     */
    data: XOR<adUpdateManyMutationInput, adUncheckedUpdateManyInput>
    /**
     * Filter which ads to update
     */
    where?: adWhereInput
    /**
     * Limit how many ads to update.
     */
    limit?: number
  }

  /**
   * ad upsert
   */
  export type adUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ad
     */
    select?: adSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ad
     */
    omit?: adOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: adInclude<ExtArgs> | null
    /**
     * The filter to search for the ad to update in case it exists.
     */
    where: adWhereUniqueInput
    /**
     * In case the ad found by the `where` argument doesn't exist, create a new ad with this data.
     */
    create: XOR<adCreateInput, adUncheckedCreateInput>
    /**
     * In case the ad was found with the provided `where` argument, update it with this data.
     */
    update: XOR<adUpdateInput, adUncheckedUpdateInput>
  }

  /**
   * ad delete
   */
  export type adDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ad
     */
    select?: adSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ad
     */
    omit?: adOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: adInclude<ExtArgs> | null
    /**
     * Filter which ad to delete.
     */
    where: adWhereUniqueInput
  }

  /**
   * ad deleteMany
   */
  export type adDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ads to delete
     */
    where?: adWhereInput
    /**
     * Limit how many ads to delete.
     */
    limit?: number
  }

  /**
   * ad.request_request_adToad
   */
  export type ad$request_request_adToadArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the request
     */
    select?: requestSelect<ExtArgs> | null
    /**
     * Omit specific fields from the request
     */
    omit?: requestOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: requestInclude<ExtArgs> | null
    where?: requestWhereInput
    orderBy?: requestOrderByWithRelationInput | requestOrderByWithRelationInput[]
    cursor?: requestWhereUniqueInput
    take?: number
    skip?: number
    distinct?: RequestScalarFieldEnum | RequestScalarFieldEnum[]
  }

  /**
   * ad.views_views_adToad
   */
  export type ad$views_views_adToadArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the views
     */
    select?: viewsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the views
     */
    omit?: viewsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: viewsInclude<ExtArgs> | null
    where?: viewsWhereInput
    orderBy?: viewsOrderByWithRelationInput | viewsOrderByWithRelationInput[]
    cursor?: viewsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ViewsScalarFieldEnum | ViewsScalarFieldEnum[]
  }

  /**
   * ad without action
   */
  export type adDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ad
     */
    select?: adSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ad
     */
    omit?: adOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: adInclude<ExtArgs> | null
  }


  /**
   * Model request
   */

  export type AggregateRequest = {
    _count: RequestCountAggregateOutputType | null
    _min: RequestMinAggregateOutputType | null
    _max: RequestMaxAggregateOutputType | null
  }

  export type RequestMinAggregateOutputType = {
    id: string | null
    ad: string | null
    user: string | null
    type: $Enums.request_type | null
    creation: Date | null
    param: string | null
  }

  export type RequestMaxAggregateOutputType = {
    id: string | null
    ad: string | null
    user: string | null
    type: $Enums.request_type | null
    creation: Date | null
    param: string | null
  }

  export type RequestCountAggregateOutputType = {
    id: number
    ad: number
    user: number
    type: number
    creation: number
    param: number
    _all: number
  }


  export type RequestMinAggregateInputType = {
    id?: true
    ad?: true
    user?: true
    type?: true
    creation?: true
    param?: true
  }

  export type RequestMaxAggregateInputType = {
    id?: true
    ad?: true
    user?: true
    type?: true
    creation?: true
    param?: true
  }

  export type RequestCountAggregateInputType = {
    id?: true
    ad?: true
    user?: true
    type?: true
    creation?: true
    param?: true
    _all?: true
  }

  export type RequestAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which request to aggregate.
     */
    where?: requestWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of requests to fetch.
     */
    orderBy?: requestOrderByWithRelationInput | requestOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: requestWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` requests from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` requests.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned requests
    **/
    _count?: true | RequestCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: RequestMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: RequestMaxAggregateInputType
  }

  export type GetRequestAggregateType<T extends RequestAggregateArgs> = {
        [P in keyof T & keyof AggregateRequest]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateRequest[P]>
      : GetScalarType<T[P], AggregateRequest[P]>
  }




  export type requestGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: requestWhereInput
    orderBy?: requestOrderByWithAggregationInput | requestOrderByWithAggregationInput[]
    by: RequestScalarFieldEnum[] | RequestScalarFieldEnum
    having?: requestScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: RequestCountAggregateInputType | true
    _min?: RequestMinAggregateInputType
    _max?: RequestMaxAggregateInputType
  }

  export type RequestGroupByOutputType = {
    id: string
    ad: string | null
    user: string
    type: $Enums.request_type
    creation: Date
    param: string | null
    _count: RequestCountAggregateOutputType | null
    _min: RequestMinAggregateOutputType | null
    _max: RequestMaxAggregateOutputType | null
  }

  type GetRequestGroupByPayload<T extends requestGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<RequestGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof RequestGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], RequestGroupByOutputType[P]>
            : GetScalarType<T[P], RequestGroupByOutputType[P]>
        }
      >
    >


  export type requestSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    ad?: boolean
    user?: boolean
    type?: boolean
    creation?: boolean
    param?: boolean
    ad_request_adToad?: boolean | request$ad_request_adToadArgs<ExtArgs>
    user_request_userTouser?: boolean | userDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["request"]>



  export type requestSelectScalar = {
    id?: boolean
    ad?: boolean
    user?: boolean
    type?: boolean
    creation?: boolean
    param?: boolean
  }

  export type requestOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "ad" | "user" | "type" | "creation" | "param", ExtArgs["result"]["request"]>
  export type requestInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    ad_request_adToad?: boolean | request$ad_request_adToadArgs<ExtArgs>
    user_request_userTouser?: boolean | userDefaultArgs<ExtArgs>
  }

  export type $requestPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "request"
    objects: {
      ad_request_adToad: Prisma.$adPayload<ExtArgs> | null
      user_request_userTouser: Prisma.$userPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      ad: string | null
      user: string
      type: $Enums.request_type
      creation: Date
      param: string | null
    }, ExtArgs["result"]["request"]>
    composites: {}
  }

  type requestGetPayload<S extends boolean | null | undefined | requestDefaultArgs> = $Result.GetResult<Prisma.$requestPayload, S>

  type requestCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<requestFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: RequestCountAggregateInputType | true
    }

  export interface requestDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['request'], meta: { name: 'request' } }
    /**
     * Find zero or one Request that matches the filter.
     * @param {requestFindUniqueArgs} args - Arguments to find a Request
     * @example
     * // Get one Request
     * const request = await prisma.request.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends requestFindUniqueArgs>(args: SelectSubset<T, requestFindUniqueArgs<ExtArgs>>): Prisma__requestClient<$Result.GetResult<Prisma.$requestPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Request that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {requestFindUniqueOrThrowArgs} args - Arguments to find a Request
     * @example
     * // Get one Request
     * const request = await prisma.request.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends requestFindUniqueOrThrowArgs>(args: SelectSubset<T, requestFindUniqueOrThrowArgs<ExtArgs>>): Prisma__requestClient<$Result.GetResult<Prisma.$requestPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Request that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {requestFindFirstArgs} args - Arguments to find a Request
     * @example
     * // Get one Request
     * const request = await prisma.request.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends requestFindFirstArgs>(args?: SelectSubset<T, requestFindFirstArgs<ExtArgs>>): Prisma__requestClient<$Result.GetResult<Prisma.$requestPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Request that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {requestFindFirstOrThrowArgs} args - Arguments to find a Request
     * @example
     * // Get one Request
     * const request = await prisma.request.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends requestFindFirstOrThrowArgs>(args?: SelectSubset<T, requestFindFirstOrThrowArgs<ExtArgs>>): Prisma__requestClient<$Result.GetResult<Prisma.$requestPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Requests that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {requestFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Requests
     * const requests = await prisma.request.findMany()
     * 
     * // Get first 10 Requests
     * const requests = await prisma.request.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const requestWithIdOnly = await prisma.request.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends requestFindManyArgs>(args?: SelectSubset<T, requestFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$requestPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Request.
     * @param {requestCreateArgs} args - Arguments to create a Request.
     * @example
     * // Create one Request
     * const Request = await prisma.request.create({
     *   data: {
     *     // ... data to create a Request
     *   }
     * })
     * 
     */
    create<T extends requestCreateArgs>(args: SelectSubset<T, requestCreateArgs<ExtArgs>>): Prisma__requestClient<$Result.GetResult<Prisma.$requestPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Requests.
     * @param {requestCreateManyArgs} args - Arguments to create many Requests.
     * @example
     * // Create many Requests
     * const request = await prisma.request.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends requestCreateManyArgs>(args?: SelectSubset<T, requestCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Request.
     * @param {requestDeleteArgs} args - Arguments to delete one Request.
     * @example
     * // Delete one Request
     * const Request = await prisma.request.delete({
     *   where: {
     *     // ... filter to delete one Request
     *   }
     * })
     * 
     */
    delete<T extends requestDeleteArgs>(args: SelectSubset<T, requestDeleteArgs<ExtArgs>>): Prisma__requestClient<$Result.GetResult<Prisma.$requestPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Request.
     * @param {requestUpdateArgs} args - Arguments to update one Request.
     * @example
     * // Update one Request
     * const request = await prisma.request.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends requestUpdateArgs>(args: SelectSubset<T, requestUpdateArgs<ExtArgs>>): Prisma__requestClient<$Result.GetResult<Prisma.$requestPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Requests.
     * @param {requestDeleteManyArgs} args - Arguments to filter Requests to delete.
     * @example
     * // Delete a few Requests
     * const { count } = await prisma.request.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends requestDeleteManyArgs>(args?: SelectSubset<T, requestDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Requests.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {requestUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Requests
     * const request = await prisma.request.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends requestUpdateManyArgs>(args: SelectSubset<T, requestUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Request.
     * @param {requestUpsertArgs} args - Arguments to update or create a Request.
     * @example
     * // Update or create a Request
     * const request = await prisma.request.upsert({
     *   create: {
     *     // ... data to create a Request
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Request we want to update
     *   }
     * })
     */
    upsert<T extends requestUpsertArgs>(args: SelectSubset<T, requestUpsertArgs<ExtArgs>>): Prisma__requestClient<$Result.GetResult<Prisma.$requestPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of Requests.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {requestCountArgs} args - Arguments to filter Requests to count.
     * @example
     * // Count the number of Requests
     * const count = await prisma.request.count({
     *   where: {
     *     // ... the filter for the Requests we want to count
     *   }
     * })
    **/
    count<T extends requestCountArgs>(
      args?: Subset<T, requestCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], RequestCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Request.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RequestAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends RequestAggregateArgs>(args: Subset<T, RequestAggregateArgs>): Prisma.PrismaPromise<GetRequestAggregateType<T>>

    /**
     * Group by Request.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {requestGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends requestGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: requestGroupByArgs['orderBy'] }
        : { orderBy?: requestGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, requestGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetRequestGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the request model
   */
  readonly fields: requestFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for request.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__requestClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    ad_request_adToad<T extends request$ad_request_adToadArgs<ExtArgs> = {}>(args?: Subset<T, request$ad_request_adToadArgs<ExtArgs>>): Prisma__adClient<$Result.GetResult<Prisma.$adPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | null, null, ExtArgs, ClientOptions>
    user_request_userTouser<T extends userDefaultArgs<ExtArgs> = {}>(args?: Subset<T, userDefaultArgs<ExtArgs>>): Prisma__userClient<$Result.GetResult<Prisma.$userPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the request model
   */ 
  interface requestFieldRefs {
    readonly id: FieldRef<"request", 'String'>
    readonly ad: FieldRef<"request", 'String'>
    readonly user: FieldRef<"request", 'String'>
    readonly type: FieldRef<"request", 'request_type'>
    readonly creation: FieldRef<"request", 'DateTime'>
    readonly param: FieldRef<"request", 'String'>
  }
    

  // Custom InputTypes
  /**
   * request findUnique
   */
  export type requestFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the request
     */
    select?: requestSelect<ExtArgs> | null
    /**
     * Omit specific fields from the request
     */
    omit?: requestOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: requestInclude<ExtArgs> | null
    /**
     * Filter, which request to fetch.
     */
    where: requestWhereUniqueInput
  }

  /**
   * request findUniqueOrThrow
   */
  export type requestFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the request
     */
    select?: requestSelect<ExtArgs> | null
    /**
     * Omit specific fields from the request
     */
    omit?: requestOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: requestInclude<ExtArgs> | null
    /**
     * Filter, which request to fetch.
     */
    where: requestWhereUniqueInput
  }

  /**
   * request findFirst
   */
  export type requestFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the request
     */
    select?: requestSelect<ExtArgs> | null
    /**
     * Omit specific fields from the request
     */
    omit?: requestOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: requestInclude<ExtArgs> | null
    /**
     * Filter, which request to fetch.
     */
    where?: requestWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of requests to fetch.
     */
    orderBy?: requestOrderByWithRelationInput | requestOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for requests.
     */
    cursor?: requestWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` requests from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` requests.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of requests.
     */
    distinct?: RequestScalarFieldEnum | RequestScalarFieldEnum[]
  }

  /**
   * request findFirstOrThrow
   */
  export type requestFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the request
     */
    select?: requestSelect<ExtArgs> | null
    /**
     * Omit specific fields from the request
     */
    omit?: requestOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: requestInclude<ExtArgs> | null
    /**
     * Filter, which request to fetch.
     */
    where?: requestWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of requests to fetch.
     */
    orderBy?: requestOrderByWithRelationInput | requestOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for requests.
     */
    cursor?: requestWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` requests from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` requests.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of requests.
     */
    distinct?: RequestScalarFieldEnum | RequestScalarFieldEnum[]
  }

  /**
   * request findMany
   */
  export type requestFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the request
     */
    select?: requestSelect<ExtArgs> | null
    /**
     * Omit specific fields from the request
     */
    omit?: requestOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: requestInclude<ExtArgs> | null
    /**
     * Filter, which requests to fetch.
     */
    where?: requestWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of requests to fetch.
     */
    orderBy?: requestOrderByWithRelationInput | requestOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing requests.
     */
    cursor?: requestWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` requests from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` requests.
     */
    skip?: number
    distinct?: RequestScalarFieldEnum | RequestScalarFieldEnum[]
  }

  /**
   * request create
   */
  export type requestCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the request
     */
    select?: requestSelect<ExtArgs> | null
    /**
     * Omit specific fields from the request
     */
    omit?: requestOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: requestInclude<ExtArgs> | null
    /**
     * The data needed to create a request.
     */
    data: XOR<requestCreateInput, requestUncheckedCreateInput>
  }

  /**
   * request createMany
   */
  export type requestCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many requests.
     */
    data: requestCreateManyInput | requestCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * request update
   */
  export type requestUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the request
     */
    select?: requestSelect<ExtArgs> | null
    /**
     * Omit specific fields from the request
     */
    omit?: requestOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: requestInclude<ExtArgs> | null
    /**
     * The data needed to update a request.
     */
    data: XOR<requestUpdateInput, requestUncheckedUpdateInput>
    /**
     * Choose, which request to update.
     */
    where: requestWhereUniqueInput
  }

  /**
   * request updateMany
   */
  export type requestUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update requests.
     */
    data: XOR<requestUpdateManyMutationInput, requestUncheckedUpdateManyInput>
    /**
     * Filter which requests to update
     */
    where?: requestWhereInput
    /**
     * Limit how many requests to update.
     */
    limit?: number
  }

  /**
   * request upsert
   */
  export type requestUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the request
     */
    select?: requestSelect<ExtArgs> | null
    /**
     * Omit specific fields from the request
     */
    omit?: requestOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: requestInclude<ExtArgs> | null
    /**
     * The filter to search for the request to update in case it exists.
     */
    where: requestWhereUniqueInput
    /**
     * In case the request found by the `where` argument doesn't exist, create a new request with this data.
     */
    create: XOR<requestCreateInput, requestUncheckedCreateInput>
    /**
     * In case the request was found with the provided `where` argument, update it with this data.
     */
    update: XOR<requestUpdateInput, requestUncheckedUpdateInput>
  }

  /**
   * request delete
   */
  export type requestDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the request
     */
    select?: requestSelect<ExtArgs> | null
    /**
     * Omit specific fields from the request
     */
    omit?: requestOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: requestInclude<ExtArgs> | null
    /**
     * Filter which request to delete.
     */
    where: requestWhereUniqueInput
  }

  /**
   * request deleteMany
   */
  export type requestDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which requests to delete
     */
    where?: requestWhereInput
    /**
     * Limit how many requests to delete.
     */
    limit?: number
  }

  /**
   * request.ad_request_adToad
   */
  export type request$ad_request_adToadArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ad
     */
    select?: adSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ad
     */
    omit?: adOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: adInclude<ExtArgs> | null
    where?: adWhereInput
  }

  /**
   * request without action
   */
  export type requestDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the request
     */
    select?: requestSelect<ExtArgs> | null
    /**
     * Omit specific fields from the request
     */
    omit?: requestOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: requestInclude<ExtArgs> | null
  }


  /**
   * Model session
   */

  export type AggregateSession = {
    _count: SessionCountAggregateOutputType | null
    _min: SessionMinAggregateOutputType | null
    _max: SessionMaxAggregateOutputType | null
  }

  export type SessionMinAggregateOutputType = {
    id: string | null
    userid: string | null
    ip: string | null
    last_used: Date | null
    is_reset: boolean | null
  }

  export type SessionMaxAggregateOutputType = {
    id: string | null
    userid: string | null
    ip: string | null
    last_used: Date | null
    is_reset: boolean | null
  }

  export type SessionCountAggregateOutputType = {
    id: number
    userid: number
    ip: number
    last_used: number
    is_reset: number
    _all: number
  }


  export type SessionMinAggregateInputType = {
    id?: true
    userid?: true
    ip?: true
    last_used?: true
    is_reset?: true
  }

  export type SessionMaxAggregateInputType = {
    id?: true
    userid?: true
    ip?: true
    last_used?: true
    is_reset?: true
  }

  export type SessionCountAggregateInputType = {
    id?: true
    userid?: true
    ip?: true
    last_used?: true
    is_reset?: true
    _all?: true
  }

  export type SessionAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which session to aggregate.
     */
    where?: sessionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of sessions to fetch.
     */
    orderBy?: sessionOrderByWithRelationInput | sessionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: sessionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` sessions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` sessions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned sessions
    **/
    _count?: true | SessionCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: SessionMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: SessionMaxAggregateInputType
  }

  export type GetSessionAggregateType<T extends SessionAggregateArgs> = {
        [P in keyof T & keyof AggregateSession]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateSession[P]>
      : GetScalarType<T[P], AggregateSession[P]>
  }




  export type sessionGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: sessionWhereInput
    orderBy?: sessionOrderByWithAggregationInput | sessionOrderByWithAggregationInput[]
    by: SessionScalarFieldEnum[] | SessionScalarFieldEnum
    having?: sessionScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: SessionCountAggregateInputType | true
    _min?: SessionMinAggregateInputType
    _max?: SessionMaxAggregateInputType
  }

  export type SessionGroupByOutputType = {
    id: string
    userid: string
    ip: string
    last_used: Date
    is_reset: boolean
    _count: SessionCountAggregateOutputType | null
    _min: SessionMinAggregateOutputType | null
    _max: SessionMaxAggregateOutputType | null
  }

  type GetSessionGroupByPayload<T extends sessionGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<SessionGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof SessionGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], SessionGroupByOutputType[P]>
            : GetScalarType<T[P], SessionGroupByOutputType[P]>
        }
      >
    >


  export type sessionSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    userid?: boolean
    ip?: boolean
    last_used?: boolean
    is_reset?: boolean
    user?: boolean | userDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["session"]>



  export type sessionSelectScalar = {
    id?: boolean
    userid?: boolean
    ip?: boolean
    last_used?: boolean
    is_reset?: boolean
  }

  export type sessionOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "userid" | "ip" | "last_used" | "is_reset", ExtArgs["result"]["session"]>
  export type sessionInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | userDefaultArgs<ExtArgs>
  }

  export type $sessionPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "session"
    objects: {
      user: Prisma.$userPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      userid: string
      ip: string
      last_used: Date
      is_reset: boolean
    }, ExtArgs["result"]["session"]>
    composites: {}
  }

  type sessionGetPayload<S extends boolean | null | undefined | sessionDefaultArgs> = $Result.GetResult<Prisma.$sessionPayload, S>

  type sessionCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<sessionFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: SessionCountAggregateInputType | true
    }

  export interface sessionDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['session'], meta: { name: 'session' } }
    /**
     * Find zero or one Session that matches the filter.
     * @param {sessionFindUniqueArgs} args - Arguments to find a Session
     * @example
     * // Get one Session
     * const session = await prisma.session.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends sessionFindUniqueArgs>(args: SelectSubset<T, sessionFindUniqueArgs<ExtArgs>>): Prisma__sessionClient<$Result.GetResult<Prisma.$sessionPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Session that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {sessionFindUniqueOrThrowArgs} args - Arguments to find a Session
     * @example
     * // Get one Session
     * const session = await prisma.session.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends sessionFindUniqueOrThrowArgs>(args: SelectSubset<T, sessionFindUniqueOrThrowArgs<ExtArgs>>): Prisma__sessionClient<$Result.GetResult<Prisma.$sessionPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Session that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {sessionFindFirstArgs} args - Arguments to find a Session
     * @example
     * // Get one Session
     * const session = await prisma.session.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends sessionFindFirstArgs>(args?: SelectSubset<T, sessionFindFirstArgs<ExtArgs>>): Prisma__sessionClient<$Result.GetResult<Prisma.$sessionPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Session that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {sessionFindFirstOrThrowArgs} args - Arguments to find a Session
     * @example
     * // Get one Session
     * const session = await prisma.session.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends sessionFindFirstOrThrowArgs>(args?: SelectSubset<T, sessionFindFirstOrThrowArgs<ExtArgs>>): Prisma__sessionClient<$Result.GetResult<Prisma.$sessionPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Sessions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {sessionFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Sessions
     * const sessions = await prisma.session.findMany()
     * 
     * // Get first 10 Sessions
     * const sessions = await prisma.session.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const sessionWithIdOnly = await prisma.session.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends sessionFindManyArgs>(args?: SelectSubset<T, sessionFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$sessionPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Session.
     * @param {sessionCreateArgs} args - Arguments to create a Session.
     * @example
     * // Create one Session
     * const Session = await prisma.session.create({
     *   data: {
     *     // ... data to create a Session
     *   }
     * })
     * 
     */
    create<T extends sessionCreateArgs>(args: SelectSubset<T, sessionCreateArgs<ExtArgs>>): Prisma__sessionClient<$Result.GetResult<Prisma.$sessionPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Sessions.
     * @param {sessionCreateManyArgs} args - Arguments to create many Sessions.
     * @example
     * // Create many Sessions
     * const session = await prisma.session.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends sessionCreateManyArgs>(args?: SelectSubset<T, sessionCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Session.
     * @param {sessionDeleteArgs} args - Arguments to delete one Session.
     * @example
     * // Delete one Session
     * const Session = await prisma.session.delete({
     *   where: {
     *     // ... filter to delete one Session
     *   }
     * })
     * 
     */
    delete<T extends sessionDeleteArgs>(args: SelectSubset<T, sessionDeleteArgs<ExtArgs>>): Prisma__sessionClient<$Result.GetResult<Prisma.$sessionPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Session.
     * @param {sessionUpdateArgs} args - Arguments to update one Session.
     * @example
     * // Update one Session
     * const session = await prisma.session.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends sessionUpdateArgs>(args: SelectSubset<T, sessionUpdateArgs<ExtArgs>>): Prisma__sessionClient<$Result.GetResult<Prisma.$sessionPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Sessions.
     * @param {sessionDeleteManyArgs} args - Arguments to filter Sessions to delete.
     * @example
     * // Delete a few Sessions
     * const { count } = await prisma.session.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends sessionDeleteManyArgs>(args?: SelectSubset<T, sessionDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Sessions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {sessionUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Sessions
     * const session = await prisma.session.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends sessionUpdateManyArgs>(args: SelectSubset<T, sessionUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Session.
     * @param {sessionUpsertArgs} args - Arguments to update or create a Session.
     * @example
     * // Update or create a Session
     * const session = await prisma.session.upsert({
     *   create: {
     *     // ... data to create a Session
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Session we want to update
     *   }
     * })
     */
    upsert<T extends sessionUpsertArgs>(args: SelectSubset<T, sessionUpsertArgs<ExtArgs>>): Prisma__sessionClient<$Result.GetResult<Prisma.$sessionPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of Sessions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {sessionCountArgs} args - Arguments to filter Sessions to count.
     * @example
     * // Count the number of Sessions
     * const count = await prisma.session.count({
     *   where: {
     *     // ... the filter for the Sessions we want to count
     *   }
     * })
    **/
    count<T extends sessionCountArgs>(
      args?: Subset<T, sessionCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], SessionCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Session.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SessionAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends SessionAggregateArgs>(args: Subset<T, SessionAggregateArgs>): Prisma.PrismaPromise<GetSessionAggregateType<T>>

    /**
     * Group by Session.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {sessionGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends sessionGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: sessionGroupByArgs['orderBy'] }
        : { orderBy?: sessionGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, sessionGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetSessionGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the session model
   */
  readonly fields: sessionFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for session.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__sessionClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    user<T extends userDefaultArgs<ExtArgs> = {}>(args?: Subset<T, userDefaultArgs<ExtArgs>>): Prisma__userClient<$Result.GetResult<Prisma.$userPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the session model
   */ 
  interface sessionFieldRefs {
    readonly id: FieldRef<"session", 'String'>
    readonly userid: FieldRef<"session", 'String'>
    readonly ip: FieldRef<"session", 'String'>
    readonly last_used: FieldRef<"session", 'DateTime'>
    readonly is_reset: FieldRef<"session", 'Boolean'>
  }
    

  // Custom InputTypes
  /**
   * session findUnique
   */
  export type sessionFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the session
     */
    select?: sessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the session
     */
    omit?: sessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: sessionInclude<ExtArgs> | null
    /**
     * Filter, which session to fetch.
     */
    where: sessionWhereUniqueInput
  }

  /**
   * session findUniqueOrThrow
   */
  export type sessionFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the session
     */
    select?: sessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the session
     */
    omit?: sessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: sessionInclude<ExtArgs> | null
    /**
     * Filter, which session to fetch.
     */
    where: sessionWhereUniqueInput
  }

  /**
   * session findFirst
   */
  export type sessionFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the session
     */
    select?: sessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the session
     */
    omit?: sessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: sessionInclude<ExtArgs> | null
    /**
     * Filter, which session to fetch.
     */
    where?: sessionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of sessions to fetch.
     */
    orderBy?: sessionOrderByWithRelationInput | sessionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for sessions.
     */
    cursor?: sessionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` sessions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` sessions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of sessions.
     */
    distinct?: SessionScalarFieldEnum | SessionScalarFieldEnum[]
  }

  /**
   * session findFirstOrThrow
   */
  export type sessionFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the session
     */
    select?: sessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the session
     */
    omit?: sessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: sessionInclude<ExtArgs> | null
    /**
     * Filter, which session to fetch.
     */
    where?: sessionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of sessions to fetch.
     */
    orderBy?: sessionOrderByWithRelationInput | sessionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for sessions.
     */
    cursor?: sessionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` sessions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` sessions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of sessions.
     */
    distinct?: SessionScalarFieldEnum | SessionScalarFieldEnum[]
  }

  /**
   * session findMany
   */
  export type sessionFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the session
     */
    select?: sessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the session
     */
    omit?: sessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: sessionInclude<ExtArgs> | null
    /**
     * Filter, which sessions to fetch.
     */
    where?: sessionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of sessions to fetch.
     */
    orderBy?: sessionOrderByWithRelationInput | sessionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing sessions.
     */
    cursor?: sessionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` sessions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` sessions.
     */
    skip?: number
    distinct?: SessionScalarFieldEnum | SessionScalarFieldEnum[]
  }

  /**
   * session create
   */
  export type sessionCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the session
     */
    select?: sessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the session
     */
    omit?: sessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: sessionInclude<ExtArgs> | null
    /**
     * The data needed to create a session.
     */
    data: XOR<sessionCreateInput, sessionUncheckedCreateInput>
  }

  /**
   * session createMany
   */
  export type sessionCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many sessions.
     */
    data: sessionCreateManyInput | sessionCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * session update
   */
  export type sessionUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the session
     */
    select?: sessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the session
     */
    omit?: sessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: sessionInclude<ExtArgs> | null
    /**
     * The data needed to update a session.
     */
    data: XOR<sessionUpdateInput, sessionUncheckedUpdateInput>
    /**
     * Choose, which session to update.
     */
    where: sessionWhereUniqueInput
  }

  /**
   * session updateMany
   */
  export type sessionUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update sessions.
     */
    data: XOR<sessionUpdateManyMutationInput, sessionUncheckedUpdateManyInput>
    /**
     * Filter which sessions to update
     */
    where?: sessionWhereInput
    /**
     * Limit how many sessions to update.
     */
    limit?: number
  }

  /**
   * session upsert
   */
  export type sessionUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the session
     */
    select?: sessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the session
     */
    omit?: sessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: sessionInclude<ExtArgs> | null
    /**
     * The filter to search for the session to update in case it exists.
     */
    where: sessionWhereUniqueInput
    /**
     * In case the session found by the `where` argument doesn't exist, create a new session with this data.
     */
    create: XOR<sessionCreateInput, sessionUncheckedCreateInput>
    /**
     * In case the session was found with the provided `where` argument, update it with this data.
     */
    update: XOR<sessionUpdateInput, sessionUncheckedUpdateInput>
  }

  /**
   * session delete
   */
  export type sessionDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the session
     */
    select?: sessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the session
     */
    omit?: sessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: sessionInclude<ExtArgs> | null
    /**
     * Filter which session to delete.
     */
    where: sessionWhereUniqueInput
  }

  /**
   * session deleteMany
   */
  export type sessionDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which sessions to delete
     */
    where?: sessionWhereInput
    /**
     * Limit how many sessions to delete.
     */
    limit?: number
  }

  /**
   * session without action
   */
  export type sessionDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the session
     */
    select?: sessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the session
     */
    omit?: sessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: sessionInclude<ExtArgs> | null
  }


  /**
   * Model user
   */

  export type AggregateUser = {
    _count: UserCountAggregateOutputType | null
    _avg: UserAvgAggregateOutputType | null
    _sum: UserSumAggregateOutputType | null
    _min: UserMinAggregateOutputType | null
    _max: UserMaxAggregateOutputType | null
  }

  export type UserAvgAggregateOutputType = {
    points: number | null
  }

  export type UserSumAggregateOutputType = {
    points: number | null
  }

  export type UserMinAggregateOutputType = {
    id: string | null
    fullname: string | null
    username: string | null
    password: string | null
    email: string | null
    phone: string | null
    points: number | null
    joinDate: Date | null
    isVerified: boolean | null
    isAdmin: boolean | null
    isDeleted: boolean | null
    verification: string | null
  }

  export type UserMaxAggregateOutputType = {
    id: string | null
    fullname: string | null
    username: string | null
    password: string | null
    email: string | null
    phone: string | null
    points: number | null
    joinDate: Date | null
    isVerified: boolean | null
    isAdmin: boolean | null
    isDeleted: boolean | null
    verification: string | null
  }

  export type UserCountAggregateOutputType = {
    id: number
    fullname: number
    username: number
    password: number
    email: number
    phone: number
    points: number
    joinDate: number
    isVerified: number
    isAdmin: number
    isDeleted: number
    verification: number
    _all: number
  }


  export type UserAvgAggregateInputType = {
    points?: true
  }

  export type UserSumAggregateInputType = {
    points?: true
  }

  export type UserMinAggregateInputType = {
    id?: true
    fullname?: true
    username?: true
    password?: true
    email?: true
    phone?: true
    points?: true
    joinDate?: true
    isVerified?: true
    isAdmin?: true
    isDeleted?: true
    verification?: true
  }

  export type UserMaxAggregateInputType = {
    id?: true
    fullname?: true
    username?: true
    password?: true
    email?: true
    phone?: true
    points?: true
    joinDate?: true
    isVerified?: true
    isAdmin?: true
    isDeleted?: true
    verification?: true
  }

  export type UserCountAggregateInputType = {
    id?: true
    fullname?: true
    username?: true
    password?: true
    email?: true
    phone?: true
    points?: true
    joinDate?: true
    isVerified?: true
    isAdmin?: true
    isDeleted?: true
    verification?: true
    _all?: true
  }

  export type UserAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which user to aggregate.
     */
    where?: userWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of users to fetch.
     */
    orderBy?: userOrderByWithRelationInput | userOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: userWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned users
    **/
    _count?: true | UserCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: UserAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: UserSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: UserMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: UserMaxAggregateInputType
  }

  export type GetUserAggregateType<T extends UserAggregateArgs> = {
        [P in keyof T & keyof AggregateUser]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUser[P]>
      : GetScalarType<T[P], AggregateUser[P]>
  }




  export type userGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: userWhereInput
    orderBy?: userOrderByWithAggregationInput | userOrderByWithAggregationInput[]
    by: UserScalarFieldEnum[] | UserScalarFieldEnum
    having?: userScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: UserCountAggregateInputType | true
    _avg?: UserAvgAggregateInputType
    _sum?: UserSumAggregateInputType
    _min?: UserMinAggregateInputType
    _max?: UserMaxAggregateInputType
  }

  export type UserGroupByOutputType = {
    id: string
    fullname: string
    username: string
    password: string
    email: string
    phone: string | null
    points: number
    joinDate: Date
    isVerified: boolean
    isAdmin: boolean
    isDeleted: boolean
    verification: string
    _count: UserCountAggregateOutputType | null
    _avg: UserAvgAggregateOutputType | null
    _sum: UserSumAggregateOutputType | null
    _min: UserMinAggregateOutputType | null
    _max: UserMaxAggregateOutputType | null
  }

  type GetUserGroupByPayload<T extends userGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<UserGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof UserGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], UserGroupByOutputType[P]>
            : GetScalarType<T[P], UserGroupByOutputType[P]>
        }
      >
    >


  export type userSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    fullname?: boolean
    username?: boolean
    password?: boolean
    email?: boolean
    phone?: boolean
    points?: boolean
    joinDate?: boolean
    isVerified?: boolean
    isAdmin?: boolean
    isDeleted?: boolean
    verification?: boolean
    ad?: boolean | user$adArgs<ExtArgs>
    request_request_userTouser?: boolean | user$request_request_userTouserArgs<ExtArgs>
    session?: boolean | user$sessionArgs<ExtArgs>
    views_views_userTouser?: boolean | user$views_views_userTouserArgs<ExtArgs>
    _count?: boolean | UserCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["user"]>



  export type userSelectScalar = {
    id?: boolean
    fullname?: boolean
    username?: boolean
    password?: boolean
    email?: boolean
    phone?: boolean
    points?: boolean
    joinDate?: boolean
    isVerified?: boolean
    isAdmin?: boolean
    isDeleted?: boolean
    verification?: boolean
  }

  export type userOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "fullname" | "username" | "password" | "email" | "phone" | "points" | "joinDate" | "isVerified" | "isAdmin" | "isDeleted" | "verification", ExtArgs["result"]["user"]>
  export type userInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    ad?: boolean | user$adArgs<ExtArgs>
    request_request_userTouser?: boolean | user$request_request_userTouserArgs<ExtArgs>
    session?: boolean | user$sessionArgs<ExtArgs>
    views_views_userTouser?: boolean | user$views_views_userTouserArgs<ExtArgs>
    _count?: boolean | UserCountOutputTypeDefaultArgs<ExtArgs>
  }

  export type $userPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "user"
    objects: {
      ad: Prisma.$adPayload<ExtArgs>[]
      request_request_userTouser: Prisma.$requestPayload<ExtArgs>[]
      session: Prisma.$sessionPayload<ExtArgs>[]
      views_views_userTouser: Prisma.$viewsPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      fullname: string
      username: string
      password: string
      email: string
      phone: string | null
      points: number
      joinDate: Date
      isVerified: boolean
      isAdmin: boolean
      isDeleted: boolean
      verification: string
    }, ExtArgs["result"]["user"]>
    composites: {}
  }

  type userGetPayload<S extends boolean | null | undefined | userDefaultArgs> = $Result.GetResult<Prisma.$userPayload, S>

  type userCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<userFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: UserCountAggregateInputType | true
    }

  export interface userDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['user'], meta: { name: 'user' } }
    /**
     * Find zero or one User that matches the filter.
     * @param {userFindUniqueArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends userFindUniqueArgs>(args: SelectSubset<T, userFindUniqueArgs<ExtArgs>>): Prisma__userClient<$Result.GetResult<Prisma.$userPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one User that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {userFindUniqueOrThrowArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends userFindUniqueOrThrowArgs>(args: SelectSubset<T, userFindUniqueOrThrowArgs<ExtArgs>>): Prisma__userClient<$Result.GetResult<Prisma.$userPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first User that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {userFindFirstArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends userFindFirstArgs>(args?: SelectSubset<T, userFindFirstArgs<ExtArgs>>): Prisma__userClient<$Result.GetResult<Prisma.$userPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first User that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {userFindFirstOrThrowArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends userFindFirstOrThrowArgs>(args?: SelectSubset<T, userFindFirstOrThrowArgs<ExtArgs>>): Prisma__userClient<$Result.GetResult<Prisma.$userPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Users that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {userFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Users
     * const users = await prisma.user.findMany()
     * 
     * // Get first 10 Users
     * const users = await prisma.user.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const userWithIdOnly = await prisma.user.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends userFindManyArgs>(args?: SelectSubset<T, userFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$userPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a User.
     * @param {userCreateArgs} args - Arguments to create a User.
     * @example
     * // Create one User
     * const User = await prisma.user.create({
     *   data: {
     *     // ... data to create a User
     *   }
     * })
     * 
     */
    create<T extends userCreateArgs>(args: SelectSubset<T, userCreateArgs<ExtArgs>>): Prisma__userClient<$Result.GetResult<Prisma.$userPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Users.
     * @param {userCreateManyArgs} args - Arguments to create many Users.
     * @example
     * // Create many Users
     * const user = await prisma.user.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends userCreateManyArgs>(args?: SelectSubset<T, userCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a User.
     * @param {userDeleteArgs} args - Arguments to delete one User.
     * @example
     * // Delete one User
     * const User = await prisma.user.delete({
     *   where: {
     *     // ... filter to delete one User
     *   }
     * })
     * 
     */
    delete<T extends userDeleteArgs>(args: SelectSubset<T, userDeleteArgs<ExtArgs>>): Prisma__userClient<$Result.GetResult<Prisma.$userPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one User.
     * @param {userUpdateArgs} args - Arguments to update one User.
     * @example
     * // Update one User
     * const user = await prisma.user.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends userUpdateArgs>(args: SelectSubset<T, userUpdateArgs<ExtArgs>>): Prisma__userClient<$Result.GetResult<Prisma.$userPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Users.
     * @param {userDeleteManyArgs} args - Arguments to filter Users to delete.
     * @example
     * // Delete a few Users
     * const { count } = await prisma.user.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends userDeleteManyArgs>(args?: SelectSubset<T, userDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Users.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {userUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Users
     * const user = await prisma.user.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends userUpdateManyArgs>(args: SelectSubset<T, userUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one User.
     * @param {userUpsertArgs} args - Arguments to update or create a User.
     * @example
     * // Update or create a User
     * const user = await prisma.user.upsert({
     *   create: {
     *     // ... data to create a User
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the User we want to update
     *   }
     * })
     */
    upsert<T extends userUpsertArgs>(args: SelectSubset<T, userUpsertArgs<ExtArgs>>): Prisma__userClient<$Result.GetResult<Prisma.$userPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of Users.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {userCountArgs} args - Arguments to filter Users to count.
     * @example
     * // Count the number of Users
     * const count = await prisma.user.count({
     *   where: {
     *     // ... the filter for the Users we want to count
     *   }
     * })
    **/
    count<T extends userCountArgs>(
      args?: Subset<T, userCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], UserCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a User.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends UserAggregateArgs>(args: Subset<T, UserAggregateArgs>): Prisma.PrismaPromise<GetUserAggregateType<T>>

    /**
     * Group by User.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {userGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends userGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: userGroupByArgs['orderBy'] }
        : { orderBy?: userGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, userGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUserGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the user model
   */
  readonly fields: userFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for user.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__userClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    ad<T extends user$adArgs<ExtArgs> = {}>(args?: Subset<T, user$adArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$adPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    request_request_userTouser<T extends user$request_request_userTouserArgs<ExtArgs> = {}>(args?: Subset<T, user$request_request_userTouserArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$requestPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    session<T extends user$sessionArgs<ExtArgs> = {}>(args?: Subset<T, user$sessionArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$sessionPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    views_views_userTouser<T extends user$views_views_userTouserArgs<ExtArgs> = {}>(args?: Subset<T, user$views_views_userTouserArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$viewsPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the user model
   */ 
  interface userFieldRefs {
    readonly id: FieldRef<"user", 'String'>
    readonly fullname: FieldRef<"user", 'String'>
    readonly username: FieldRef<"user", 'String'>
    readonly password: FieldRef<"user", 'String'>
    readonly email: FieldRef<"user", 'String'>
    readonly phone: FieldRef<"user", 'String'>
    readonly points: FieldRef<"user", 'Int'>
    readonly joinDate: FieldRef<"user", 'DateTime'>
    readonly isVerified: FieldRef<"user", 'Boolean'>
    readonly isAdmin: FieldRef<"user", 'Boolean'>
    readonly isDeleted: FieldRef<"user", 'Boolean'>
    readonly verification: FieldRef<"user", 'String'>
  }
    

  // Custom InputTypes
  /**
   * user findUnique
   */
  export type userFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user
     */
    select?: userSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user
     */
    omit?: userOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userInclude<ExtArgs> | null
    /**
     * Filter, which user to fetch.
     */
    where: userWhereUniqueInput
  }

  /**
   * user findUniqueOrThrow
   */
  export type userFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user
     */
    select?: userSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user
     */
    omit?: userOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userInclude<ExtArgs> | null
    /**
     * Filter, which user to fetch.
     */
    where: userWhereUniqueInput
  }

  /**
   * user findFirst
   */
  export type userFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user
     */
    select?: userSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user
     */
    omit?: userOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userInclude<ExtArgs> | null
    /**
     * Filter, which user to fetch.
     */
    where?: userWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of users to fetch.
     */
    orderBy?: userOrderByWithRelationInput | userOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for users.
     */
    cursor?: userWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of users.
     */
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * user findFirstOrThrow
   */
  export type userFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user
     */
    select?: userSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user
     */
    omit?: userOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userInclude<ExtArgs> | null
    /**
     * Filter, which user to fetch.
     */
    where?: userWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of users to fetch.
     */
    orderBy?: userOrderByWithRelationInput | userOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for users.
     */
    cursor?: userWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of users.
     */
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * user findMany
   */
  export type userFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user
     */
    select?: userSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user
     */
    omit?: userOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userInclude<ExtArgs> | null
    /**
     * Filter, which users to fetch.
     */
    where?: userWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of users to fetch.
     */
    orderBy?: userOrderByWithRelationInput | userOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing users.
     */
    cursor?: userWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` users.
     */
    skip?: number
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * user create
   */
  export type userCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user
     */
    select?: userSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user
     */
    omit?: userOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userInclude<ExtArgs> | null
    /**
     * The data needed to create a user.
     */
    data: XOR<userCreateInput, userUncheckedCreateInput>
  }

  /**
   * user createMany
   */
  export type userCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many users.
     */
    data: userCreateManyInput | userCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * user update
   */
  export type userUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user
     */
    select?: userSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user
     */
    omit?: userOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userInclude<ExtArgs> | null
    /**
     * The data needed to update a user.
     */
    data: XOR<userUpdateInput, userUncheckedUpdateInput>
    /**
     * Choose, which user to update.
     */
    where: userWhereUniqueInput
  }

  /**
   * user updateMany
   */
  export type userUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update users.
     */
    data: XOR<userUpdateManyMutationInput, userUncheckedUpdateManyInput>
    /**
     * Filter which users to update
     */
    where?: userWhereInput
    /**
     * Limit how many users to update.
     */
    limit?: number
  }

  /**
   * user upsert
   */
  export type userUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user
     */
    select?: userSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user
     */
    omit?: userOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userInclude<ExtArgs> | null
    /**
     * The filter to search for the user to update in case it exists.
     */
    where: userWhereUniqueInput
    /**
     * In case the user found by the `where` argument doesn't exist, create a new user with this data.
     */
    create: XOR<userCreateInput, userUncheckedCreateInput>
    /**
     * In case the user was found with the provided `where` argument, update it with this data.
     */
    update: XOR<userUpdateInput, userUncheckedUpdateInput>
  }

  /**
   * user delete
   */
  export type userDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user
     */
    select?: userSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user
     */
    omit?: userOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userInclude<ExtArgs> | null
    /**
     * Filter which user to delete.
     */
    where: userWhereUniqueInput
  }

  /**
   * user deleteMany
   */
  export type userDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which users to delete
     */
    where?: userWhereInput
    /**
     * Limit how many users to delete.
     */
    limit?: number
  }

  /**
   * user.ad
   */
  export type user$adArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ad
     */
    select?: adSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ad
     */
    omit?: adOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: adInclude<ExtArgs> | null
    where?: adWhereInput
    orderBy?: adOrderByWithRelationInput | adOrderByWithRelationInput[]
    cursor?: adWhereUniqueInput
    take?: number
    skip?: number
    distinct?: AdScalarFieldEnum | AdScalarFieldEnum[]
  }

  /**
   * user.request_request_userTouser
   */
  export type user$request_request_userTouserArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the request
     */
    select?: requestSelect<ExtArgs> | null
    /**
     * Omit specific fields from the request
     */
    omit?: requestOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: requestInclude<ExtArgs> | null
    where?: requestWhereInput
    orderBy?: requestOrderByWithRelationInput | requestOrderByWithRelationInput[]
    cursor?: requestWhereUniqueInput
    take?: number
    skip?: number
    distinct?: RequestScalarFieldEnum | RequestScalarFieldEnum[]
  }

  /**
   * user.session
   */
  export type user$sessionArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the session
     */
    select?: sessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the session
     */
    omit?: sessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: sessionInclude<ExtArgs> | null
    where?: sessionWhereInput
    orderBy?: sessionOrderByWithRelationInput | sessionOrderByWithRelationInput[]
    cursor?: sessionWhereUniqueInput
    take?: number
    skip?: number
    distinct?: SessionScalarFieldEnum | SessionScalarFieldEnum[]
  }

  /**
   * user.views_views_userTouser
   */
  export type user$views_views_userTouserArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the views
     */
    select?: viewsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the views
     */
    omit?: viewsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: viewsInclude<ExtArgs> | null
    where?: viewsWhereInput
    orderBy?: viewsOrderByWithRelationInput | viewsOrderByWithRelationInput[]
    cursor?: viewsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ViewsScalarFieldEnum | ViewsScalarFieldEnum[]
  }

  /**
   * user without action
   */
  export type userDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user
     */
    select?: userSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user
     */
    omit?: userOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userInclude<ExtArgs> | null
  }


  /**
   * Model views
   */

  export type AggregateViews = {
    _count: ViewsCountAggregateOutputType | null
    _avg: ViewsAvgAggregateOutputType | null
    _sum: ViewsSumAggregateOutputType | null
    _min: ViewsMinAggregateOutputType | null
    _max: ViewsMaxAggregateOutputType | null
  }

  export type ViewsAvgAggregateOutputType = {
    id: number | null
    points: number | null
  }

  export type ViewsSumAggregateOutputType = {
    id: bigint | null
    points: number | null
  }

  export type ViewsMinAggregateOutputType = {
    id: bigint | null
    ad: string | null
    user: string | null
    time: Date | null
    points: number | null
  }

  export type ViewsMaxAggregateOutputType = {
    id: bigint | null
    ad: string | null
    user: string | null
    time: Date | null
    points: number | null
  }

  export type ViewsCountAggregateOutputType = {
    id: number
    ad: number
    user: number
    time: number
    points: number
    _all: number
  }


  export type ViewsAvgAggregateInputType = {
    id?: true
    points?: true
  }

  export type ViewsSumAggregateInputType = {
    id?: true
    points?: true
  }

  export type ViewsMinAggregateInputType = {
    id?: true
    ad?: true
    user?: true
    time?: true
    points?: true
  }

  export type ViewsMaxAggregateInputType = {
    id?: true
    ad?: true
    user?: true
    time?: true
    points?: true
  }

  export type ViewsCountAggregateInputType = {
    id?: true
    ad?: true
    user?: true
    time?: true
    points?: true
    _all?: true
  }

  export type ViewsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which views to aggregate.
     */
    where?: viewsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of views to fetch.
     */
    orderBy?: viewsOrderByWithRelationInput | viewsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: viewsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` views from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` views.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned views
    **/
    _count?: true | ViewsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: ViewsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: ViewsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ViewsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ViewsMaxAggregateInputType
  }

  export type GetViewsAggregateType<T extends ViewsAggregateArgs> = {
        [P in keyof T & keyof AggregateViews]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateViews[P]>
      : GetScalarType<T[P], AggregateViews[P]>
  }




  export type viewsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: viewsWhereInput
    orderBy?: viewsOrderByWithAggregationInput | viewsOrderByWithAggregationInput[]
    by: ViewsScalarFieldEnum[] | ViewsScalarFieldEnum
    having?: viewsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ViewsCountAggregateInputType | true
    _avg?: ViewsAvgAggregateInputType
    _sum?: ViewsSumAggregateInputType
    _min?: ViewsMinAggregateInputType
    _max?: ViewsMaxAggregateInputType
  }

  export type ViewsGroupByOutputType = {
    id: bigint
    ad: string
    user: string
    time: Date
    points: number
    _count: ViewsCountAggregateOutputType | null
    _avg: ViewsAvgAggregateOutputType | null
    _sum: ViewsSumAggregateOutputType | null
    _min: ViewsMinAggregateOutputType | null
    _max: ViewsMaxAggregateOutputType | null
  }

  type GetViewsGroupByPayload<T extends viewsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ViewsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ViewsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ViewsGroupByOutputType[P]>
            : GetScalarType<T[P], ViewsGroupByOutputType[P]>
        }
      >
    >


  export type viewsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    ad?: boolean
    user?: boolean
    time?: boolean
    points?: boolean
    ad_views_adToad?: boolean | adDefaultArgs<ExtArgs>
    user_views_userTouser?: boolean | userDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["views"]>



  export type viewsSelectScalar = {
    id?: boolean
    ad?: boolean
    user?: boolean
    time?: boolean
    points?: boolean
  }

  export type viewsOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "ad" | "user" | "time" | "points", ExtArgs["result"]["views"]>
  export type viewsInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    ad_views_adToad?: boolean | adDefaultArgs<ExtArgs>
    user_views_userTouser?: boolean | userDefaultArgs<ExtArgs>
  }

  export type $viewsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "views"
    objects: {
      ad_views_adToad: Prisma.$adPayload<ExtArgs>
      user_views_userTouser: Prisma.$userPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: bigint
      ad: string
      user: string
      time: Date
      points: number
    }, ExtArgs["result"]["views"]>
    composites: {}
  }

  type viewsGetPayload<S extends boolean | null | undefined | viewsDefaultArgs> = $Result.GetResult<Prisma.$viewsPayload, S>

  type viewsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<viewsFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: ViewsCountAggregateInputType | true
    }

  export interface viewsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['views'], meta: { name: 'views' } }
    /**
     * Find zero or one Views that matches the filter.
     * @param {viewsFindUniqueArgs} args - Arguments to find a Views
     * @example
     * // Get one Views
     * const views = await prisma.views.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends viewsFindUniqueArgs>(args: SelectSubset<T, viewsFindUniqueArgs<ExtArgs>>): Prisma__viewsClient<$Result.GetResult<Prisma.$viewsPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Views that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {viewsFindUniqueOrThrowArgs} args - Arguments to find a Views
     * @example
     * // Get one Views
     * const views = await prisma.views.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends viewsFindUniqueOrThrowArgs>(args: SelectSubset<T, viewsFindUniqueOrThrowArgs<ExtArgs>>): Prisma__viewsClient<$Result.GetResult<Prisma.$viewsPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Views that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {viewsFindFirstArgs} args - Arguments to find a Views
     * @example
     * // Get one Views
     * const views = await prisma.views.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends viewsFindFirstArgs>(args?: SelectSubset<T, viewsFindFirstArgs<ExtArgs>>): Prisma__viewsClient<$Result.GetResult<Prisma.$viewsPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Views that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {viewsFindFirstOrThrowArgs} args - Arguments to find a Views
     * @example
     * // Get one Views
     * const views = await prisma.views.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends viewsFindFirstOrThrowArgs>(args?: SelectSubset<T, viewsFindFirstOrThrowArgs<ExtArgs>>): Prisma__viewsClient<$Result.GetResult<Prisma.$viewsPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Views that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {viewsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Views
     * const views = await prisma.views.findMany()
     * 
     * // Get first 10 Views
     * const views = await prisma.views.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const viewsWithIdOnly = await prisma.views.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends viewsFindManyArgs>(args?: SelectSubset<T, viewsFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$viewsPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Views.
     * @param {viewsCreateArgs} args - Arguments to create a Views.
     * @example
     * // Create one Views
     * const Views = await prisma.views.create({
     *   data: {
     *     // ... data to create a Views
     *   }
     * })
     * 
     */
    create<T extends viewsCreateArgs>(args: SelectSubset<T, viewsCreateArgs<ExtArgs>>): Prisma__viewsClient<$Result.GetResult<Prisma.$viewsPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Views.
     * @param {viewsCreateManyArgs} args - Arguments to create many Views.
     * @example
     * // Create many Views
     * const views = await prisma.views.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends viewsCreateManyArgs>(args?: SelectSubset<T, viewsCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Views.
     * @param {viewsDeleteArgs} args - Arguments to delete one Views.
     * @example
     * // Delete one Views
     * const Views = await prisma.views.delete({
     *   where: {
     *     // ... filter to delete one Views
     *   }
     * })
     * 
     */
    delete<T extends viewsDeleteArgs>(args: SelectSubset<T, viewsDeleteArgs<ExtArgs>>): Prisma__viewsClient<$Result.GetResult<Prisma.$viewsPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Views.
     * @param {viewsUpdateArgs} args - Arguments to update one Views.
     * @example
     * // Update one Views
     * const views = await prisma.views.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends viewsUpdateArgs>(args: SelectSubset<T, viewsUpdateArgs<ExtArgs>>): Prisma__viewsClient<$Result.GetResult<Prisma.$viewsPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Views.
     * @param {viewsDeleteManyArgs} args - Arguments to filter Views to delete.
     * @example
     * // Delete a few Views
     * const { count } = await prisma.views.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends viewsDeleteManyArgs>(args?: SelectSubset<T, viewsDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Views.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {viewsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Views
     * const views = await prisma.views.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends viewsUpdateManyArgs>(args: SelectSubset<T, viewsUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Views.
     * @param {viewsUpsertArgs} args - Arguments to update or create a Views.
     * @example
     * // Update or create a Views
     * const views = await prisma.views.upsert({
     *   create: {
     *     // ... data to create a Views
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Views we want to update
     *   }
     * })
     */
    upsert<T extends viewsUpsertArgs>(args: SelectSubset<T, viewsUpsertArgs<ExtArgs>>): Prisma__viewsClient<$Result.GetResult<Prisma.$viewsPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of Views.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {viewsCountArgs} args - Arguments to filter Views to count.
     * @example
     * // Count the number of Views
     * const count = await prisma.views.count({
     *   where: {
     *     // ... the filter for the Views we want to count
     *   }
     * })
    **/
    count<T extends viewsCountArgs>(
      args?: Subset<T, viewsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ViewsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Views.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ViewsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ViewsAggregateArgs>(args: Subset<T, ViewsAggregateArgs>): Prisma.PrismaPromise<GetViewsAggregateType<T>>

    /**
     * Group by Views.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {viewsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends viewsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: viewsGroupByArgs['orderBy'] }
        : { orderBy?: viewsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, viewsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetViewsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the views model
   */
  readonly fields: viewsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for views.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__viewsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    ad_views_adToad<T extends adDefaultArgs<ExtArgs> = {}>(args?: Subset<T, adDefaultArgs<ExtArgs>>): Prisma__adClient<$Result.GetResult<Prisma.$adPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    user_views_userTouser<T extends userDefaultArgs<ExtArgs> = {}>(args?: Subset<T, userDefaultArgs<ExtArgs>>): Prisma__userClient<$Result.GetResult<Prisma.$userPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the views model
   */ 
  interface viewsFieldRefs {
    readonly id: FieldRef<"views", 'BigInt'>
    readonly ad: FieldRef<"views", 'String'>
    readonly user: FieldRef<"views", 'String'>
    readonly time: FieldRef<"views", 'DateTime'>
    readonly points: FieldRef<"views", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * views findUnique
   */
  export type viewsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the views
     */
    select?: viewsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the views
     */
    omit?: viewsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: viewsInclude<ExtArgs> | null
    /**
     * Filter, which views to fetch.
     */
    where: viewsWhereUniqueInput
  }

  /**
   * views findUniqueOrThrow
   */
  export type viewsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the views
     */
    select?: viewsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the views
     */
    omit?: viewsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: viewsInclude<ExtArgs> | null
    /**
     * Filter, which views to fetch.
     */
    where: viewsWhereUniqueInput
  }

  /**
   * views findFirst
   */
  export type viewsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the views
     */
    select?: viewsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the views
     */
    omit?: viewsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: viewsInclude<ExtArgs> | null
    /**
     * Filter, which views to fetch.
     */
    where?: viewsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of views to fetch.
     */
    orderBy?: viewsOrderByWithRelationInput | viewsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for views.
     */
    cursor?: viewsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` views from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` views.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of views.
     */
    distinct?: ViewsScalarFieldEnum | ViewsScalarFieldEnum[]
  }

  /**
   * views findFirstOrThrow
   */
  export type viewsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the views
     */
    select?: viewsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the views
     */
    omit?: viewsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: viewsInclude<ExtArgs> | null
    /**
     * Filter, which views to fetch.
     */
    where?: viewsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of views to fetch.
     */
    orderBy?: viewsOrderByWithRelationInput | viewsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for views.
     */
    cursor?: viewsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` views from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` views.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of views.
     */
    distinct?: ViewsScalarFieldEnum | ViewsScalarFieldEnum[]
  }

  /**
   * views findMany
   */
  export type viewsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the views
     */
    select?: viewsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the views
     */
    omit?: viewsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: viewsInclude<ExtArgs> | null
    /**
     * Filter, which views to fetch.
     */
    where?: viewsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of views to fetch.
     */
    orderBy?: viewsOrderByWithRelationInput | viewsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing views.
     */
    cursor?: viewsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` views from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` views.
     */
    skip?: number
    distinct?: ViewsScalarFieldEnum | ViewsScalarFieldEnum[]
  }

  /**
   * views create
   */
  export type viewsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the views
     */
    select?: viewsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the views
     */
    omit?: viewsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: viewsInclude<ExtArgs> | null
    /**
     * The data needed to create a views.
     */
    data: XOR<viewsCreateInput, viewsUncheckedCreateInput>
  }

  /**
   * views createMany
   */
  export type viewsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many views.
     */
    data: viewsCreateManyInput | viewsCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * views update
   */
  export type viewsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the views
     */
    select?: viewsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the views
     */
    omit?: viewsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: viewsInclude<ExtArgs> | null
    /**
     * The data needed to update a views.
     */
    data: XOR<viewsUpdateInput, viewsUncheckedUpdateInput>
    /**
     * Choose, which views to update.
     */
    where: viewsWhereUniqueInput
  }

  /**
   * views updateMany
   */
  export type viewsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update views.
     */
    data: XOR<viewsUpdateManyMutationInput, viewsUncheckedUpdateManyInput>
    /**
     * Filter which views to update
     */
    where?: viewsWhereInput
    /**
     * Limit how many views to update.
     */
    limit?: number
  }

  /**
   * views upsert
   */
  export type viewsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the views
     */
    select?: viewsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the views
     */
    omit?: viewsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: viewsInclude<ExtArgs> | null
    /**
     * The filter to search for the views to update in case it exists.
     */
    where: viewsWhereUniqueInput
    /**
     * In case the views found by the `where` argument doesn't exist, create a new views with this data.
     */
    create: XOR<viewsCreateInput, viewsUncheckedCreateInput>
    /**
     * In case the views was found with the provided `where` argument, update it with this data.
     */
    update: XOR<viewsUpdateInput, viewsUncheckedUpdateInput>
  }

  /**
   * views delete
   */
  export type viewsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the views
     */
    select?: viewsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the views
     */
    omit?: viewsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: viewsInclude<ExtArgs> | null
    /**
     * Filter which views to delete.
     */
    where: viewsWhereUniqueInput
  }

  /**
   * views deleteMany
   */
  export type viewsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which views to delete
     */
    where?: viewsWhereInput
    /**
     * Limit how many views to delete.
     */
    limit?: number
  }

  /**
   * views without action
   */
  export type viewsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the views
     */
    select?: viewsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the views
     */
    omit?: viewsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: viewsInclude<ExtArgs> | null
  }


  /**
   * Enums
   */

  export const TransactionIsolationLevel: {
    ReadUncommitted: 'ReadUncommitted',
    ReadCommitted: 'ReadCommitted',
    RepeatableRead: 'RepeatableRead',
    Serializable: 'Serializable'
  };

  export type TransactionIsolationLevel = (typeof TransactionIsolationLevel)[keyof typeof TransactionIsolationLevel]


  export const AdScalarFieldEnum: {
    id: 'id',
    name: 'name',
    path: 'path',
    views: 'views',
    targetViews: 'targetViews',
    image: 'image',
    type: 'type',
    category: 'category',
    creation_date: 'creation_date',
    renewal_date: 'renewal_date',
    isPublished: 'isPublished',
    keywords: 'keywords',
    userid: 'userid'
  };

  export type AdScalarFieldEnum = (typeof AdScalarFieldEnum)[keyof typeof AdScalarFieldEnum]


  export const RequestScalarFieldEnum: {
    id: 'id',
    ad: 'ad',
    user: 'user',
    type: 'type',
    creation: 'creation',
    param: 'param'
  };

  export type RequestScalarFieldEnum = (typeof RequestScalarFieldEnum)[keyof typeof RequestScalarFieldEnum]


  export const SessionScalarFieldEnum: {
    id: 'id',
    userid: 'userid',
    ip: 'ip',
    last_used: 'last_used',
    is_reset: 'is_reset'
  };

  export type SessionScalarFieldEnum = (typeof SessionScalarFieldEnum)[keyof typeof SessionScalarFieldEnum]


  export const UserScalarFieldEnum: {
    id: 'id',
    fullname: 'fullname',
    username: 'username',
    password: 'password',
    email: 'email',
    phone: 'phone',
    points: 'points',
    joinDate: 'joinDate',
    isVerified: 'isVerified',
    isAdmin: 'isAdmin',
    isDeleted: 'isDeleted',
    verification: 'verification'
  };

  export type UserScalarFieldEnum = (typeof UserScalarFieldEnum)[keyof typeof UserScalarFieldEnum]


  export const ViewsScalarFieldEnum: {
    id: 'id',
    ad: 'ad',
    user: 'user',
    time: 'time',
    points: 'points'
  };

  export type ViewsScalarFieldEnum = (typeof ViewsScalarFieldEnum)[keyof typeof ViewsScalarFieldEnum]


  export const SortOrder: {
    asc: 'asc',
    desc: 'desc'
  };

  export type SortOrder = (typeof SortOrder)[keyof typeof SortOrder]


  export const adOrderByRelevanceFieldEnum: {
    id: 'id',
    name: 'name',
    path: 'path',
    image: 'image',
    keywords: 'keywords',
    userid: 'userid'
  };

  export type adOrderByRelevanceFieldEnum = (typeof adOrderByRelevanceFieldEnum)[keyof typeof adOrderByRelevanceFieldEnum]


  export const NullsOrder: {
    first: 'first',
    last: 'last'
  };

  export type NullsOrder = (typeof NullsOrder)[keyof typeof NullsOrder]


  export const requestOrderByRelevanceFieldEnum: {
    id: 'id',
    ad: 'ad',
    user: 'user',
    param: 'param'
  };

  export type requestOrderByRelevanceFieldEnum = (typeof requestOrderByRelevanceFieldEnum)[keyof typeof requestOrderByRelevanceFieldEnum]


  export const sessionOrderByRelevanceFieldEnum: {
    id: 'id',
    userid: 'userid',
    ip: 'ip'
  };

  export type sessionOrderByRelevanceFieldEnum = (typeof sessionOrderByRelevanceFieldEnum)[keyof typeof sessionOrderByRelevanceFieldEnum]


  export const userOrderByRelevanceFieldEnum: {
    id: 'id',
    fullname: 'fullname',
    username: 'username',
    password: 'password',
    email: 'email',
    phone: 'phone',
    verification: 'verification'
  };

  export type userOrderByRelevanceFieldEnum = (typeof userOrderByRelevanceFieldEnum)[keyof typeof userOrderByRelevanceFieldEnum]


  export const viewsOrderByRelevanceFieldEnum: {
    ad: 'ad',
    user: 'user'
  };

  export type viewsOrderByRelevanceFieldEnum = (typeof viewsOrderByRelevanceFieldEnum)[keyof typeof viewsOrderByRelevanceFieldEnum]


  /**
   * Field references 
   */


  /**
   * Reference to a field of type 'String'
   */
  export type StringFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'String'>
    


  /**
   * Reference to a field of type 'Int'
   */
  export type IntFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Int'>
    


  /**
   * Reference to a field of type 'ad_type'
   */
  export type Enumad_typeFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'ad_type'>
    


  /**
   * Reference to a field of type 'ad_category'
   */
  export type Enumad_categoryFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'ad_category'>
    


  /**
   * Reference to a field of type 'DateTime'
   */
  export type DateTimeFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'DateTime'>
    


  /**
   * Reference to a field of type 'Boolean'
   */
  export type BooleanFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Boolean'>
    


  /**
   * Reference to a field of type 'request_type'
   */
  export type Enumrequest_typeFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'request_type'>
    


  /**
   * Reference to a field of type 'BigInt'
   */
  export type BigIntFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'BigInt'>
    


  /**
   * Reference to a field of type 'Float'
   */
  export type FloatFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Float'>
    
  /**
   * Deep Input Types
   */


  export type adWhereInput = {
    AND?: adWhereInput | adWhereInput[]
    OR?: adWhereInput[]
    NOT?: adWhereInput | adWhereInput[]
    id?: StringFilter<"ad"> | string
    name?: StringFilter<"ad"> | string
    path?: StringFilter<"ad"> | string
    views?: IntFilter<"ad"> | number
    targetViews?: IntFilter<"ad"> | number
    image?: StringFilter<"ad"> | string
    type?: Enumad_typeFilter<"ad"> | $Enums.ad_type
    category?: Enumad_categoryFilter<"ad"> | $Enums.ad_category
    creation_date?: DateTimeFilter<"ad"> | Date | string
    renewal_date?: DateTimeFilter<"ad"> | Date | string
    isPublished?: BoolFilter<"ad"> | boolean
    keywords?: StringFilter<"ad"> | string
    userid?: StringFilter<"ad"> | string
    user?: XOR<UserScalarRelationFilter, userWhereInput>
    request_request_adToad?: RequestListRelationFilter
    views_views_adToad?: ViewsListRelationFilter
  }

  export type adOrderByWithRelationInput = {
    id?: SortOrder
    name?: SortOrder
    path?: SortOrder
    views?: SortOrder
    targetViews?: SortOrder
    image?: SortOrder
    type?: SortOrder
    category?: SortOrder
    creation_date?: SortOrder
    renewal_date?: SortOrder
    isPublished?: SortOrder
    keywords?: SortOrder
    userid?: SortOrder
    user?: userOrderByWithRelationInput
    request_request_adToad?: requestOrderByRelationAggregateInput
    views_views_adToad?: viewsOrderByRelationAggregateInput
    _relevance?: adOrderByRelevanceInput
  }

  export type adWhereUniqueInput = Prisma.AtLeast<{
    id?: string
    AND?: adWhereInput | adWhereInput[]
    OR?: adWhereInput[]
    NOT?: adWhereInput | adWhereInput[]
    name?: StringFilter<"ad"> | string
    path?: StringFilter<"ad"> | string
    views?: IntFilter<"ad"> | number
    targetViews?: IntFilter<"ad"> | number
    image?: StringFilter<"ad"> | string
    type?: Enumad_typeFilter<"ad"> | $Enums.ad_type
    category?: Enumad_categoryFilter<"ad"> | $Enums.ad_category
    creation_date?: DateTimeFilter<"ad"> | Date | string
    renewal_date?: DateTimeFilter<"ad"> | Date | string
    isPublished?: BoolFilter<"ad"> | boolean
    keywords?: StringFilter<"ad"> | string
    userid?: StringFilter<"ad"> | string
    user?: XOR<UserScalarRelationFilter, userWhereInput>
    request_request_adToad?: RequestListRelationFilter
    views_views_adToad?: ViewsListRelationFilter
  }, "id" | "id">

  export type adOrderByWithAggregationInput = {
    id?: SortOrder
    name?: SortOrder
    path?: SortOrder
    views?: SortOrder
    targetViews?: SortOrder
    image?: SortOrder
    type?: SortOrder
    category?: SortOrder
    creation_date?: SortOrder
    renewal_date?: SortOrder
    isPublished?: SortOrder
    keywords?: SortOrder
    userid?: SortOrder
    _count?: adCountOrderByAggregateInput
    _avg?: adAvgOrderByAggregateInput
    _max?: adMaxOrderByAggregateInput
    _min?: adMinOrderByAggregateInput
    _sum?: adSumOrderByAggregateInput
  }

  export type adScalarWhereWithAggregatesInput = {
    AND?: adScalarWhereWithAggregatesInput | adScalarWhereWithAggregatesInput[]
    OR?: adScalarWhereWithAggregatesInput[]
    NOT?: adScalarWhereWithAggregatesInput | adScalarWhereWithAggregatesInput[]
    id?: StringWithAggregatesFilter<"ad"> | string
    name?: StringWithAggregatesFilter<"ad"> | string
    path?: StringWithAggregatesFilter<"ad"> | string
    views?: IntWithAggregatesFilter<"ad"> | number
    targetViews?: IntWithAggregatesFilter<"ad"> | number
    image?: StringWithAggregatesFilter<"ad"> | string
    type?: Enumad_typeWithAggregatesFilter<"ad"> | $Enums.ad_type
    category?: Enumad_categoryWithAggregatesFilter<"ad"> | $Enums.ad_category
    creation_date?: DateTimeWithAggregatesFilter<"ad"> | Date | string
    renewal_date?: DateTimeWithAggregatesFilter<"ad"> | Date | string
    isPublished?: BoolWithAggregatesFilter<"ad"> | boolean
    keywords?: StringWithAggregatesFilter<"ad"> | string
    userid?: StringWithAggregatesFilter<"ad"> | string
  }

  export type requestWhereInput = {
    AND?: requestWhereInput | requestWhereInput[]
    OR?: requestWhereInput[]
    NOT?: requestWhereInput | requestWhereInput[]
    id?: StringFilter<"request"> | string
    ad?: StringNullableFilter<"request"> | string | null
    user?: StringFilter<"request"> | string
    type?: Enumrequest_typeFilter<"request"> | $Enums.request_type
    creation?: DateTimeFilter<"request"> | Date | string
    param?: StringNullableFilter<"request"> | string | null
    ad_request_adToad?: XOR<AdNullableScalarRelationFilter, adWhereInput> | null
    user_request_userTouser?: XOR<UserScalarRelationFilter, userWhereInput>
  }

  export type requestOrderByWithRelationInput = {
    id?: SortOrder
    ad?: SortOrderInput | SortOrder
    user?: SortOrder
    type?: SortOrder
    creation?: SortOrder
    param?: SortOrderInput | SortOrder
    ad_request_adToad?: adOrderByWithRelationInput
    user_request_userTouser?: userOrderByWithRelationInput
    _relevance?: requestOrderByRelevanceInput
  }

  export type requestWhereUniqueInput = Prisma.AtLeast<{
    id?: string
    AND?: requestWhereInput | requestWhereInput[]
    OR?: requestWhereInput[]
    NOT?: requestWhereInput | requestWhereInput[]
    ad?: StringNullableFilter<"request"> | string | null
    user?: StringFilter<"request"> | string
    type?: Enumrequest_typeFilter<"request"> | $Enums.request_type
    creation?: DateTimeFilter<"request"> | Date | string
    param?: StringNullableFilter<"request"> | string | null
    ad_request_adToad?: XOR<AdNullableScalarRelationFilter, adWhereInput> | null
    user_request_userTouser?: XOR<UserScalarRelationFilter, userWhereInput>
  }, "id">

  export type requestOrderByWithAggregationInput = {
    id?: SortOrder
    ad?: SortOrderInput | SortOrder
    user?: SortOrder
    type?: SortOrder
    creation?: SortOrder
    param?: SortOrderInput | SortOrder
    _count?: requestCountOrderByAggregateInput
    _max?: requestMaxOrderByAggregateInput
    _min?: requestMinOrderByAggregateInput
  }

  export type requestScalarWhereWithAggregatesInput = {
    AND?: requestScalarWhereWithAggregatesInput | requestScalarWhereWithAggregatesInput[]
    OR?: requestScalarWhereWithAggregatesInput[]
    NOT?: requestScalarWhereWithAggregatesInput | requestScalarWhereWithAggregatesInput[]
    id?: StringWithAggregatesFilter<"request"> | string
    ad?: StringNullableWithAggregatesFilter<"request"> | string | null
    user?: StringWithAggregatesFilter<"request"> | string
    type?: Enumrequest_typeWithAggregatesFilter<"request"> | $Enums.request_type
    creation?: DateTimeWithAggregatesFilter<"request"> | Date | string
    param?: StringNullableWithAggregatesFilter<"request"> | string | null
  }

  export type sessionWhereInput = {
    AND?: sessionWhereInput | sessionWhereInput[]
    OR?: sessionWhereInput[]
    NOT?: sessionWhereInput | sessionWhereInput[]
    id?: StringFilter<"session"> | string
    userid?: StringFilter<"session"> | string
    ip?: StringFilter<"session"> | string
    last_used?: DateTimeFilter<"session"> | Date | string
    is_reset?: BoolFilter<"session"> | boolean
    user?: XOR<UserScalarRelationFilter, userWhereInput>
  }

  export type sessionOrderByWithRelationInput = {
    id?: SortOrder
    userid?: SortOrder
    ip?: SortOrder
    last_used?: SortOrder
    is_reset?: SortOrder
    user?: userOrderByWithRelationInput
    _relevance?: sessionOrderByRelevanceInput
  }

  export type sessionWhereUniqueInput = Prisma.AtLeast<{
    id?: string
    AND?: sessionWhereInput | sessionWhereInput[]
    OR?: sessionWhereInput[]
    NOT?: sessionWhereInput | sessionWhereInput[]
    userid?: StringFilter<"session"> | string
    ip?: StringFilter<"session"> | string
    last_used?: DateTimeFilter<"session"> | Date | string
    is_reset?: BoolFilter<"session"> | boolean
    user?: XOR<UserScalarRelationFilter, userWhereInput>
  }, "id" | "id">

  export type sessionOrderByWithAggregationInput = {
    id?: SortOrder
    userid?: SortOrder
    ip?: SortOrder
    last_used?: SortOrder
    is_reset?: SortOrder
    _count?: sessionCountOrderByAggregateInput
    _max?: sessionMaxOrderByAggregateInput
    _min?: sessionMinOrderByAggregateInput
  }

  export type sessionScalarWhereWithAggregatesInput = {
    AND?: sessionScalarWhereWithAggregatesInput | sessionScalarWhereWithAggregatesInput[]
    OR?: sessionScalarWhereWithAggregatesInput[]
    NOT?: sessionScalarWhereWithAggregatesInput | sessionScalarWhereWithAggregatesInput[]
    id?: StringWithAggregatesFilter<"session"> | string
    userid?: StringWithAggregatesFilter<"session"> | string
    ip?: StringWithAggregatesFilter<"session"> | string
    last_used?: DateTimeWithAggregatesFilter<"session"> | Date | string
    is_reset?: BoolWithAggregatesFilter<"session"> | boolean
  }

  export type userWhereInput = {
    AND?: userWhereInput | userWhereInput[]
    OR?: userWhereInput[]
    NOT?: userWhereInput | userWhereInput[]
    id?: StringFilter<"user"> | string
    fullname?: StringFilter<"user"> | string
    username?: StringFilter<"user"> | string
    password?: StringFilter<"user"> | string
    email?: StringFilter<"user"> | string
    phone?: StringNullableFilter<"user"> | string | null
    points?: IntFilter<"user"> | number
    joinDate?: DateTimeFilter<"user"> | Date | string
    isVerified?: BoolFilter<"user"> | boolean
    isAdmin?: BoolFilter<"user"> | boolean
    isDeleted?: BoolFilter<"user"> | boolean
    verification?: StringFilter<"user"> | string
    ad?: AdListRelationFilter
    request_request_userTouser?: RequestListRelationFilter
    session?: SessionListRelationFilter
    views_views_userTouser?: ViewsListRelationFilter
  }

  export type userOrderByWithRelationInput = {
    id?: SortOrder
    fullname?: SortOrder
    username?: SortOrder
    password?: SortOrder
    email?: SortOrder
    phone?: SortOrderInput | SortOrder
    points?: SortOrder
    joinDate?: SortOrder
    isVerified?: SortOrder
    isAdmin?: SortOrder
    isDeleted?: SortOrder
    verification?: SortOrder
    ad?: adOrderByRelationAggregateInput
    request_request_userTouser?: requestOrderByRelationAggregateInput
    session?: sessionOrderByRelationAggregateInput
    views_views_userTouser?: viewsOrderByRelationAggregateInput
    _relevance?: userOrderByRelevanceInput
  }

  export type userWhereUniqueInput = Prisma.AtLeast<{
    id?: string
    AND?: userWhereInput | userWhereInput[]
    OR?: userWhereInput[]
    NOT?: userWhereInput | userWhereInput[]
    fullname?: StringFilter<"user"> | string
    username?: StringFilter<"user"> | string
    password?: StringFilter<"user"> | string
    email?: StringFilter<"user"> | string
    phone?: StringNullableFilter<"user"> | string | null
    points?: IntFilter<"user"> | number
    joinDate?: DateTimeFilter<"user"> | Date | string
    isVerified?: BoolFilter<"user"> | boolean
    isAdmin?: BoolFilter<"user"> | boolean
    isDeleted?: BoolFilter<"user"> | boolean
    verification?: StringFilter<"user"> | string
    ad?: AdListRelationFilter
    request_request_userTouser?: RequestListRelationFilter
    session?: SessionListRelationFilter
    views_views_userTouser?: ViewsListRelationFilter
  }, "id" | "id">

  export type userOrderByWithAggregationInput = {
    id?: SortOrder
    fullname?: SortOrder
    username?: SortOrder
    password?: SortOrder
    email?: SortOrder
    phone?: SortOrderInput | SortOrder
    points?: SortOrder
    joinDate?: SortOrder
    isVerified?: SortOrder
    isAdmin?: SortOrder
    isDeleted?: SortOrder
    verification?: SortOrder
    _count?: userCountOrderByAggregateInput
    _avg?: userAvgOrderByAggregateInput
    _max?: userMaxOrderByAggregateInput
    _min?: userMinOrderByAggregateInput
    _sum?: userSumOrderByAggregateInput
  }

  export type userScalarWhereWithAggregatesInput = {
    AND?: userScalarWhereWithAggregatesInput | userScalarWhereWithAggregatesInput[]
    OR?: userScalarWhereWithAggregatesInput[]
    NOT?: userScalarWhereWithAggregatesInput | userScalarWhereWithAggregatesInput[]
    id?: StringWithAggregatesFilter<"user"> | string
    fullname?: StringWithAggregatesFilter<"user"> | string
    username?: StringWithAggregatesFilter<"user"> | string
    password?: StringWithAggregatesFilter<"user"> | string
    email?: StringWithAggregatesFilter<"user"> | string
    phone?: StringNullableWithAggregatesFilter<"user"> | string | null
    points?: IntWithAggregatesFilter<"user"> | number
    joinDate?: DateTimeWithAggregatesFilter<"user"> | Date | string
    isVerified?: BoolWithAggregatesFilter<"user"> | boolean
    isAdmin?: BoolWithAggregatesFilter<"user"> | boolean
    isDeleted?: BoolWithAggregatesFilter<"user"> | boolean
    verification?: StringWithAggregatesFilter<"user"> | string
  }

  export type viewsWhereInput = {
    AND?: viewsWhereInput | viewsWhereInput[]
    OR?: viewsWhereInput[]
    NOT?: viewsWhereInput | viewsWhereInput[]
    id?: BigIntFilter<"views"> | bigint | number
    ad?: StringFilter<"views"> | string
    user?: StringFilter<"views"> | string
    time?: DateTimeFilter<"views"> | Date | string
    points?: IntFilter<"views"> | number
    ad_views_adToad?: XOR<AdScalarRelationFilter, adWhereInput>
    user_views_userTouser?: XOR<UserScalarRelationFilter, userWhereInput>
  }

  export type viewsOrderByWithRelationInput = {
    id?: SortOrder
    ad?: SortOrder
    user?: SortOrder
    time?: SortOrder
    points?: SortOrder
    ad_views_adToad?: adOrderByWithRelationInput
    user_views_userTouser?: userOrderByWithRelationInput
    _relevance?: viewsOrderByRelevanceInput
  }

  export type viewsWhereUniqueInput = Prisma.AtLeast<{
    id_ad_user?: viewsIdAdUserCompoundUniqueInput
    AND?: viewsWhereInput | viewsWhereInput[]
    OR?: viewsWhereInput[]
    NOT?: viewsWhereInput | viewsWhereInput[]
    id?: BigIntFilter<"views"> | bigint | number
    ad?: StringFilter<"views"> | string
    user?: StringFilter<"views"> | string
    time?: DateTimeFilter<"views"> | Date | string
    points?: IntFilter<"views"> | number
    ad_views_adToad?: XOR<AdScalarRelationFilter, adWhereInput>
    user_views_userTouser?: XOR<UserScalarRelationFilter, userWhereInput>
  }, "id_ad_user">

  export type viewsOrderByWithAggregationInput = {
    id?: SortOrder
    ad?: SortOrder
    user?: SortOrder
    time?: SortOrder
    points?: SortOrder
    _count?: viewsCountOrderByAggregateInput
    _avg?: viewsAvgOrderByAggregateInput
    _max?: viewsMaxOrderByAggregateInput
    _min?: viewsMinOrderByAggregateInput
    _sum?: viewsSumOrderByAggregateInput
  }

  export type viewsScalarWhereWithAggregatesInput = {
    AND?: viewsScalarWhereWithAggregatesInput | viewsScalarWhereWithAggregatesInput[]
    OR?: viewsScalarWhereWithAggregatesInput[]
    NOT?: viewsScalarWhereWithAggregatesInput | viewsScalarWhereWithAggregatesInput[]
    id?: BigIntWithAggregatesFilter<"views"> | bigint | number
    ad?: StringWithAggregatesFilter<"views"> | string
    user?: StringWithAggregatesFilter<"views"> | string
    time?: DateTimeWithAggregatesFilter<"views"> | Date | string
    points?: IntWithAggregatesFilter<"views"> | number
  }

  export type adCreateInput = {
    id?: string
    name: string
    path: string
    views?: number
    targetViews: number
    image: string
    type: $Enums.ad_type
    category: $Enums.ad_category
    creation_date: Date | string
    renewal_date: Date | string
    isPublished?: boolean
    keywords: string
    user: userCreateNestedOneWithoutAdInput
    request_request_adToad?: requestCreateNestedManyWithoutAd_request_adToadInput
    views_views_adToad?: viewsCreateNestedManyWithoutAd_views_adToadInput
  }

  export type adUncheckedCreateInput = {
    id?: string
    name: string
    path: string
    views?: number
    targetViews: number
    image: string
    type: $Enums.ad_type
    category: $Enums.ad_category
    creation_date: Date | string
    renewal_date: Date | string
    isPublished?: boolean
    keywords: string
    userid: string
    request_request_adToad?: requestUncheckedCreateNestedManyWithoutAd_request_adToadInput
    views_views_adToad?: viewsUncheckedCreateNestedManyWithoutAd_views_adToadInput
  }

  export type adUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    path?: StringFieldUpdateOperationsInput | string
    views?: IntFieldUpdateOperationsInput | number
    targetViews?: IntFieldUpdateOperationsInput | number
    image?: StringFieldUpdateOperationsInput | string
    type?: Enumad_typeFieldUpdateOperationsInput | $Enums.ad_type
    category?: Enumad_categoryFieldUpdateOperationsInput | $Enums.ad_category
    creation_date?: DateTimeFieldUpdateOperationsInput | Date | string
    renewal_date?: DateTimeFieldUpdateOperationsInput | Date | string
    isPublished?: BoolFieldUpdateOperationsInput | boolean
    keywords?: StringFieldUpdateOperationsInput | string
    user?: userUpdateOneRequiredWithoutAdNestedInput
    request_request_adToad?: requestUpdateManyWithoutAd_request_adToadNestedInput
    views_views_adToad?: viewsUpdateManyWithoutAd_views_adToadNestedInput
  }

  export type adUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    path?: StringFieldUpdateOperationsInput | string
    views?: IntFieldUpdateOperationsInput | number
    targetViews?: IntFieldUpdateOperationsInput | number
    image?: StringFieldUpdateOperationsInput | string
    type?: Enumad_typeFieldUpdateOperationsInput | $Enums.ad_type
    category?: Enumad_categoryFieldUpdateOperationsInput | $Enums.ad_category
    creation_date?: DateTimeFieldUpdateOperationsInput | Date | string
    renewal_date?: DateTimeFieldUpdateOperationsInput | Date | string
    isPublished?: BoolFieldUpdateOperationsInput | boolean
    keywords?: StringFieldUpdateOperationsInput | string
    userid?: StringFieldUpdateOperationsInput | string
    request_request_adToad?: requestUncheckedUpdateManyWithoutAd_request_adToadNestedInput
    views_views_adToad?: viewsUncheckedUpdateManyWithoutAd_views_adToadNestedInput
  }

  export type adCreateManyInput = {
    id?: string
    name: string
    path: string
    views?: number
    targetViews: number
    image: string
    type: $Enums.ad_type
    category: $Enums.ad_category
    creation_date: Date | string
    renewal_date: Date | string
    isPublished?: boolean
    keywords: string
    userid: string
  }

  export type adUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    path?: StringFieldUpdateOperationsInput | string
    views?: IntFieldUpdateOperationsInput | number
    targetViews?: IntFieldUpdateOperationsInput | number
    image?: StringFieldUpdateOperationsInput | string
    type?: Enumad_typeFieldUpdateOperationsInput | $Enums.ad_type
    category?: Enumad_categoryFieldUpdateOperationsInput | $Enums.ad_category
    creation_date?: DateTimeFieldUpdateOperationsInput | Date | string
    renewal_date?: DateTimeFieldUpdateOperationsInput | Date | string
    isPublished?: BoolFieldUpdateOperationsInput | boolean
    keywords?: StringFieldUpdateOperationsInput | string
  }

  export type adUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    path?: StringFieldUpdateOperationsInput | string
    views?: IntFieldUpdateOperationsInput | number
    targetViews?: IntFieldUpdateOperationsInput | number
    image?: StringFieldUpdateOperationsInput | string
    type?: Enumad_typeFieldUpdateOperationsInput | $Enums.ad_type
    category?: Enumad_categoryFieldUpdateOperationsInput | $Enums.ad_category
    creation_date?: DateTimeFieldUpdateOperationsInput | Date | string
    renewal_date?: DateTimeFieldUpdateOperationsInput | Date | string
    isPublished?: BoolFieldUpdateOperationsInput | boolean
    keywords?: StringFieldUpdateOperationsInput | string
    userid?: StringFieldUpdateOperationsInput | string
  }

  export type requestCreateInput = {
    id?: string
    type: $Enums.request_type
    creation: Date | string
    param?: string | null
    ad_request_adToad?: adCreateNestedOneWithoutRequest_request_adToadInput
    user_request_userTouser: userCreateNestedOneWithoutRequest_request_userTouserInput
  }

  export type requestUncheckedCreateInput = {
    id?: string
    ad?: string | null
    user: string
    type: $Enums.request_type
    creation: Date | string
    param?: string | null
  }

  export type requestUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    type?: Enumrequest_typeFieldUpdateOperationsInput | $Enums.request_type
    creation?: DateTimeFieldUpdateOperationsInput | Date | string
    param?: NullableStringFieldUpdateOperationsInput | string | null
    ad_request_adToad?: adUpdateOneWithoutRequest_request_adToadNestedInput
    user_request_userTouser?: userUpdateOneRequiredWithoutRequest_request_userTouserNestedInput
  }

  export type requestUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    ad?: NullableStringFieldUpdateOperationsInput | string | null
    user?: StringFieldUpdateOperationsInput | string
    type?: Enumrequest_typeFieldUpdateOperationsInput | $Enums.request_type
    creation?: DateTimeFieldUpdateOperationsInput | Date | string
    param?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type requestCreateManyInput = {
    id?: string
    ad?: string | null
    user: string
    type: $Enums.request_type
    creation: Date | string
    param?: string | null
  }

  export type requestUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    type?: Enumrequest_typeFieldUpdateOperationsInput | $Enums.request_type
    creation?: DateTimeFieldUpdateOperationsInput | Date | string
    param?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type requestUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    ad?: NullableStringFieldUpdateOperationsInput | string | null
    user?: StringFieldUpdateOperationsInput | string
    type?: Enumrequest_typeFieldUpdateOperationsInput | $Enums.request_type
    creation?: DateTimeFieldUpdateOperationsInput | Date | string
    param?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type sessionCreateInput = {
    id?: string
    ip: string
    last_used: Date | string
    is_reset?: boolean
    user: userCreateNestedOneWithoutSessionInput
  }

  export type sessionUncheckedCreateInput = {
    id?: string
    userid: string
    ip: string
    last_used: Date | string
    is_reset?: boolean
  }

  export type sessionUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    ip?: StringFieldUpdateOperationsInput | string
    last_used?: DateTimeFieldUpdateOperationsInput | Date | string
    is_reset?: BoolFieldUpdateOperationsInput | boolean
    user?: userUpdateOneRequiredWithoutSessionNestedInput
  }

  export type sessionUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    userid?: StringFieldUpdateOperationsInput | string
    ip?: StringFieldUpdateOperationsInput | string
    last_used?: DateTimeFieldUpdateOperationsInput | Date | string
    is_reset?: BoolFieldUpdateOperationsInput | boolean
  }

  export type sessionCreateManyInput = {
    id?: string
    userid: string
    ip: string
    last_used: Date | string
    is_reset?: boolean
  }

  export type sessionUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    ip?: StringFieldUpdateOperationsInput | string
    last_used?: DateTimeFieldUpdateOperationsInput | Date | string
    is_reset?: BoolFieldUpdateOperationsInput | boolean
  }

  export type sessionUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    userid?: StringFieldUpdateOperationsInput | string
    ip?: StringFieldUpdateOperationsInput | string
    last_used?: DateTimeFieldUpdateOperationsInput | Date | string
    is_reset?: BoolFieldUpdateOperationsInput | boolean
  }

  export type userCreateInput = {
    id?: string
    fullname: string
    username: string
    password: string
    email: string
    phone?: string | null
    points?: number
    joinDate: Date | string
    isVerified?: boolean
    isAdmin?: boolean
    isDeleted?: boolean
    verification: string
    ad?: adCreateNestedManyWithoutUserInput
    request_request_userTouser?: requestCreateNestedManyWithoutUser_request_userTouserInput
    session?: sessionCreateNestedManyWithoutUserInput
    views_views_userTouser?: viewsCreateNestedManyWithoutUser_views_userTouserInput
  }

  export type userUncheckedCreateInput = {
    id?: string
    fullname: string
    username: string
    password: string
    email: string
    phone?: string | null
    points?: number
    joinDate: Date | string
    isVerified?: boolean
    isAdmin?: boolean
    isDeleted?: boolean
    verification: string
    ad?: adUncheckedCreateNestedManyWithoutUserInput
    request_request_userTouser?: requestUncheckedCreateNestedManyWithoutUser_request_userTouserInput
    session?: sessionUncheckedCreateNestedManyWithoutUserInput
    views_views_userTouser?: viewsUncheckedCreateNestedManyWithoutUser_views_userTouserInput
  }

  export type userUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    fullname?: StringFieldUpdateOperationsInput | string
    username?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    points?: IntFieldUpdateOperationsInput | number
    joinDate?: DateTimeFieldUpdateOperationsInput | Date | string
    isVerified?: BoolFieldUpdateOperationsInput | boolean
    isAdmin?: BoolFieldUpdateOperationsInput | boolean
    isDeleted?: BoolFieldUpdateOperationsInput | boolean
    verification?: StringFieldUpdateOperationsInput | string
    ad?: adUpdateManyWithoutUserNestedInput
    request_request_userTouser?: requestUpdateManyWithoutUser_request_userTouserNestedInput
    session?: sessionUpdateManyWithoutUserNestedInput
    views_views_userTouser?: viewsUpdateManyWithoutUser_views_userTouserNestedInput
  }

  export type userUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    fullname?: StringFieldUpdateOperationsInput | string
    username?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    points?: IntFieldUpdateOperationsInput | number
    joinDate?: DateTimeFieldUpdateOperationsInput | Date | string
    isVerified?: BoolFieldUpdateOperationsInput | boolean
    isAdmin?: BoolFieldUpdateOperationsInput | boolean
    isDeleted?: BoolFieldUpdateOperationsInput | boolean
    verification?: StringFieldUpdateOperationsInput | string
    ad?: adUncheckedUpdateManyWithoutUserNestedInput
    request_request_userTouser?: requestUncheckedUpdateManyWithoutUser_request_userTouserNestedInput
    session?: sessionUncheckedUpdateManyWithoutUserNestedInput
    views_views_userTouser?: viewsUncheckedUpdateManyWithoutUser_views_userTouserNestedInput
  }

  export type userCreateManyInput = {
    id?: string
    fullname: string
    username: string
    password: string
    email: string
    phone?: string | null
    points?: number
    joinDate: Date | string
    isVerified?: boolean
    isAdmin?: boolean
    isDeleted?: boolean
    verification: string
  }

  export type userUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    fullname?: StringFieldUpdateOperationsInput | string
    username?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    points?: IntFieldUpdateOperationsInput | number
    joinDate?: DateTimeFieldUpdateOperationsInput | Date | string
    isVerified?: BoolFieldUpdateOperationsInput | boolean
    isAdmin?: BoolFieldUpdateOperationsInput | boolean
    isDeleted?: BoolFieldUpdateOperationsInput | boolean
    verification?: StringFieldUpdateOperationsInput | string
  }

  export type userUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    fullname?: StringFieldUpdateOperationsInput | string
    username?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    points?: IntFieldUpdateOperationsInput | number
    joinDate?: DateTimeFieldUpdateOperationsInput | Date | string
    isVerified?: BoolFieldUpdateOperationsInput | boolean
    isAdmin?: BoolFieldUpdateOperationsInput | boolean
    isDeleted?: BoolFieldUpdateOperationsInput | boolean
    verification?: StringFieldUpdateOperationsInput | string
  }

  export type viewsCreateInput = {
    id?: bigint | number
    time: Date | string
    points: number
    ad_views_adToad: adCreateNestedOneWithoutViews_views_adToadInput
    user_views_userTouser: userCreateNestedOneWithoutViews_views_userTouserInput
  }

  export type viewsUncheckedCreateInput = {
    id?: bigint | number
    ad: string
    user: string
    time: Date | string
    points: number
  }

  export type viewsUpdateInput = {
    id?: BigIntFieldUpdateOperationsInput | bigint | number
    time?: DateTimeFieldUpdateOperationsInput | Date | string
    points?: IntFieldUpdateOperationsInput | number
    ad_views_adToad?: adUpdateOneRequiredWithoutViews_views_adToadNestedInput
    user_views_userTouser?: userUpdateOneRequiredWithoutViews_views_userTouserNestedInput
  }

  export type viewsUncheckedUpdateInput = {
    id?: BigIntFieldUpdateOperationsInput | bigint | number
    ad?: StringFieldUpdateOperationsInput | string
    user?: StringFieldUpdateOperationsInput | string
    time?: DateTimeFieldUpdateOperationsInput | Date | string
    points?: IntFieldUpdateOperationsInput | number
  }

  export type viewsCreateManyInput = {
    id?: bigint | number
    ad: string
    user: string
    time: Date | string
    points: number
  }

  export type viewsUpdateManyMutationInput = {
    id?: BigIntFieldUpdateOperationsInput | bigint | number
    time?: DateTimeFieldUpdateOperationsInput | Date | string
    points?: IntFieldUpdateOperationsInput | number
  }

  export type viewsUncheckedUpdateManyInput = {
    id?: BigIntFieldUpdateOperationsInput | bigint | number
    ad?: StringFieldUpdateOperationsInput | string
    user?: StringFieldUpdateOperationsInput | string
    time?: DateTimeFieldUpdateOperationsInput | Date | string
    points?: IntFieldUpdateOperationsInput | number
  }

  export type StringFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[]
    notIn?: string[]
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    search?: string
    not?: NestedStringFilter<$PrismaModel> | string
  }

  export type IntFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[]
    notIn?: number[]
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntFilter<$PrismaModel> | number
  }

  export type Enumad_typeFilter<$PrismaModel = never> = {
    equals?: $Enums.ad_type | Enumad_typeFieldRefInput<$PrismaModel>
    in?: $Enums.ad_type[]
    notIn?: $Enums.ad_type[]
    not?: NestedEnumad_typeFilter<$PrismaModel> | $Enums.ad_type
  }

  export type Enumad_categoryFilter<$PrismaModel = never> = {
    equals?: $Enums.ad_category | Enumad_categoryFieldRefInput<$PrismaModel>
    in?: $Enums.ad_category[]
    notIn?: $Enums.ad_category[]
    not?: NestedEnumad_categoryFilter<$PrismaModel> | $Enums.ad_category
  }

  export type DateTimeFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    in?: Date[] | string[]
    notIn?: Date[] | string[]
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeFilter<$PrismaModel> | Date | string
  }

  export type BoolFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel>
    not?: NestedBoolFilter<$PrismaModel> | boolean
  }

  export type UserScalarRelationFilter = {
    is?: userWhereInput
    isNot?: userWhereInput
  }

  export type RequestListRelationFilter = {
    every?: requestWhereInput
    some?: requestWhereInput
    none?: requestWhereInput
  }

  export type ViewsListRelationFilter = {
    every?: viewsWhereInput
    some?: viewsWhereInput
    none?: viewsWhereInput
  }

  export type requestOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type viewsOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type adOrderByRelevanceInput = {
    fields: adOrderByRelevanceFieldEnum | adOrderByRelevanceFieldEnum[]
    sort: SortOrder
    search: string
  }

  export type adCountOrderByAggregateInput = {
    id?: SortOrder
    name?: SortOrder
    path?: SortOrder
    views?: SortOrder
    targetViews?: SortOrder
    image?: SortOrder
    type?: SortOrder
    category?: SortOrder
    creation_date?: SortOrder
    renewal_date?: SortOrder
    isPublished?: SortOrder
    keywords?: SortOrder
    userid?: SortOrder
  }

  export type adAvgOrderByAggregateInput = {
    views?: SortOrder
    targetViews?: SortOrder
  }

  export type adMaxOrderByAggregateInput = {
    id?: SortOrder
    name?: SortOrder
    path?: SortOrder
    views?: SortOrder
    targetViews?: SortOrder
    image?: SortOrder
    type?: SortOrder
    category?: SortOrder
    creation_date?: SortOrder
    renewal_date?: SortOrder
    isPublished?: SortOrder
    keywords?: SortOrder
    userid?: SortOrder
  }

  export type adMinOrderByAggregateInput = {
    id?: SortOrder
    name?: SortOrder
    path?: SortOrder
    views?: SortOrder
    targetViews?: SortOrder
    image?: SortOrder
    type?: SortOrder
    category?: SortOrder
    creation_date?: SortOrder
    renewal_date?: SortOrder
    isPublished?: SortOrder
    keywords?: SortOrder
    userid?: SortOrder
  }

  export type adSumOrderByAggregateInput = {
    views?: SortOrder
    targetViews?: SortOrder
  }

  export type StringWithAggregatesFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[]
    notIn?: string[]
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    search?: string
    not?: NestedStringWithAggregatesFilter<$PrismaModel> | string
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedStringFilter<$PrismaModel>
    _max?: NestedStringFilter<$PrismaModel>
  }

  export type IntWithAggregatesFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[]
    notIn?: number[]
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntWithAggregatesFilter<$PrismaModel> | number
    _count?: NestedIntFilter<$PrismaModel>
    _avg?: NestedFloatFilter<$PrismaModel>
    _sum?: NestedIntFilter<$PrismaModel>
    _min?: NestedIntFilter<$PrismaModel>
    _max?: NestedIntFilter<$PrismaModel>
  }

  export type Enumad_typeWithAggregatesFilter<$PrismaModel = never> = {
    equals?: $Enums.ad_type | Enumad_typeFieldRefInput<$PrismaModel>
    in?: $Enums.ad_type[]
    notIn?: $Enums.ad_type[]
    not?: NestedEnumad_typeWithAggregatesFilter<$PrismaModel> | $Enums.ad_type
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedEnumad_typeFilter<$PrismaModel>
    _max?: NestedEnumad_typeFilter<$PrismaModel>
  }

  export type Enumad_categoryWithAggregatesFilter<$PrismaModel = never> = {
    equals?: $Enums.ad_category | Enumad_categoryFieldRefInput<$PrismaModel>
    in?: $Enums.ad_category[]
    notIn?: $Enums.ad_category[]
    not?: NestedEnumad_categoryWithAggregatesFilter<$PrismaModel> | $Enums.ad_category
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedEnumad_categoryFilter<$PrismaModel>
    _max?: NestedEnumad_categoryFilter<$PrismaModel>
  }

  export type DateTimeWithAggregatesFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    in?: Date[] | string[]
    notIn?: Date[] | string[]
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeWithAggregatesFilter<$PrismaModel> | Date | string
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedDateTimeFilter<$PrismaModel>
    _max?: NestedDateTimeFilter<$PrismaModel>
  }

  export type BoolWithAggregatesFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel>
    not?: NestedBoolWithAggregatesFilter<$PrismaModel> | boolean
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedBoolFilter<$PrismaModel>
    _max?: NestedBoolFilter<$PrismaModel>
  }

  export type StringNullableFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel> | null
    in?: string[] | null
    notIn?: string[] | null
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    search?: string
    not?: NestedStringNullableFilter<$PrismaModel> | string | null
  }

  export type Enumrequest_typeFilter<$PrismaModel = never> = {
    equals?: $Enums.request_type | Enumrequest_typeFieldRefInput<$PrismaModel>
    in?: $Enums.request_type[]
    notIn?: $Enums.request_type[]
    not?: NestedEnumrequest_typeFilter<$PrismaModel> | $Enums.request_type
  }

  export type AdNullableScalarRelationFilter = {
    is?: adWhereInput | null
    isNot?: adWhereInput | null
  }

  export type SortOrderInput = {
    sort: SortOrder
    nulls?: NullsOrder
  }

  export type requestOrderByRelevanceInput = {
    fields: requestOrderByRelevanceFieldEnum | requestOrderByRelevanceFieldEnum[]
    sort: SortOrder
    search: string
  }

  export type requestCountOrderByAggregateInput = {
    id?: SortOrder
    ad?: SortOrder
    user?: SortOrder
    type?: SortOrder
    creation?: SortOrder
    param?: SortOrder
  }

  export type requestMaxOrderByAggregateInput = {
    id?: SortOrder
    ad?: SortOrder
    user?: SortOrder
    type?: SortOrder
    creation?: SortOrder
    param?: SortOrder
  }

  export type requestMinOrderByAggregateInput = {
    id?: SortOrder
    ad?: SortOrder
    user?: SortOrder
    type?: SortOrder
    creation?: SortOrder
    param?: SortOrder
  }

  export type StringNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel> | null
    in?: string[] | null
    notIn?: string[] | null
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    search?: string
    not?: NestedStringNullableWithAggregatesFilter<$PrismaModel> | string | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedStringNullableFilter<$PrismaModel>
    _max?: NestedStringNullableFilter<$PrismaModel>
  }

  export type Enumrequest_typeWithAggregatesFilter<$PrismaModel = never> = {
    equals?: $Enums.request_type | Enumrequest_typeFieldRefInput<$PrismaModel>
    in?: $Enums.request_type[]
    notIn?: $Enums.request_type[]
    not?: NestedEnumrequest_typeWithAggregatesFilter<$PrismaModel> | $Enums.request_type
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedEnumrequest_typeFilter<$PrismaModel>
    _max?: NestedEnumrequest_typeFilter<$PrismaModel>
  }

  export type sessionOrderByRelevanceInput = {
    fields: sessionOrderByRelevanceFieldEnum | sessionOrderByRelevanceFieldEnum[]
    sort: SortOrder
    search: string
  }

  export type sessionCountOrderByAggregateInput = {
    id?: SortOrder
    userid?: SortOrder
    ip?: SortOrder
    last_used?: SortOrder
    is_reset?: SortOrder
  }

  export type sessionMaxOrderByAggregateInput = {
    id?: SortOrder
    userid?: SortOrder
    ip?: SortOrder
    last_used?: SortOrder
    is_reset?: SortOrder
  }

  export type sessionMinOrderByAggregateInput = {
    id?: SortOrder
    userid?: SortOrder
    ip?: SortOrder
    last_used?: SortOrder
    is_reset?: SortOrder
  }

  export type AdListRelationFilter = {
    every?: adWhereInput
    some?: adWhereInput
    none?: adWhereInput
  }

  export type SessionListRelationFilter = {
    every?: sessionWhereInput
    some?: sessionWhereInput
    none?: sessionWhereInput
  }

  export type adOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type sessionOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type userOrderByRelevanceInput = {
    fields: userOrderByRelevanceFieldEnum | userOrderByRelevanceFieldEnum[]
    sort: SortOrder
    search: string
  }

  export type userCountOrderByAggregateInput = {
    id?: SortOrder
    fullname?: SortOrder
    username?: SortOrder
    password?: SortOrder
    email?: SortOrder
    phone?: SortOrder
    points?: SortOrder
    joinDate?: SortOrder
    isVerified?: SortOrder
    isAdmin?: SortOrder
    isDeleted?: SortOrder
    verification?: SortOrder
  }

  export type userAvgOrderByAggregateInput = {
    points?: SortOrder
  }

  export type userMaxOrderByAggregateInput = {
    id?: SortOrder
    fullname?: SortOrder
    username?: SortOrder
    password?: SortOrder
    email?: SortOrder
    phone?: SortOrder
    points?: SortOrder
    joinDate?: SortOrder
    isVerified?: SortOrder
    isAdmin?: SortOrder
    isDeleted?: SortOrder
    verification?: SortOrder
  }

  export type userMinOrderByAggregateInput = {
    id?: SortOrder
    fullname?: SortOrder
    username?: SortOrder
    password?: SortOrder
    email?: SortOrder
    phone?: SortOrder
    points?: SortOrder
    joinDate?: SortOrder
    isVerified?: SortOrder
    isAdmin?: SortOrder
    isDeleted?: SortOrder
    verification?: SortOrder
  }

  export type userSumOrderByAggregateInput = {
    points?: SortOrder
  }

  export type BigIntFilter<$PrismaModel = never> = {
    equals?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    in?: bigint[] | number[]
    notIn?: bigint[] | number[]
    lt?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    lte?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    gt?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    gte?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    not?: NestedBigIntFilter<$PrismaModel> | bigint | number
  }

  export type AdScalarRelationFilter = {
    is?: adWhereInput
    isNot?: adWhereInput
  }

  export type viewsOrderByRelevanceInput = {
    fields: viewsOrderByRelevanceFieldEnum | viewsOrderByRelevanceFieldEnum[]
    sort: SortOrder
    search: string
  }

  export type viewsIdAdUserCompoundUniqueInput = {
    id: bigint | number
    ad: string
    user: string
  }

  export type viewsCountOrderByAggregateInput = {
    id?: SortOrder
    ad?: SortOrder
    user?: SortOrder
    time?: SortOrder
    points?: SortOrder
  }

  export type viewsAvgOrderByAggregateInput = {
    id?: SortOrder
    points?: SortOrder
  }

  export type viewsMaxOrderByAggregateInput = {
    id?: SortOrder
    ad?: SortOrder
    user?: SortOrder
    time?: SortOrder
    points?: SortOrder
  }

  export type viewsMinOrderByAggregateInput = {
    id?: SortOrder
    ad?: SortOrder
    user?: SortOrder
    time?: SortOrder
    points?: SortOrder
  }

  export type viewsSumOrderByAggregateInput = {
    id?: SortOrder
    points?: SortOrder
  }

  export type BigIntWithAggregatesFilter<$PrismaModel = never> = {
    equals?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    in?: bigint[] | number[]
    notIn?: bigint[] | number[]
    lt?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    lte?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    gt?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    gte?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    not?: NestedBigIntWithAggregatesFilter<$PrismaModel> | bigint | number
    _count?: NestedIntFilter<$PrismaModel>
    _avg?: NestedFloatFilter<$PrismaModel>
    _sum?: NestedBigIntFilter<$PrismaModel>
    _min?: NestedBigIntFilter<$PrismaModel>
    _max?: NestedBigIntFilter<$PrismaModel>
  }

  export type userCreateNestedOneWithoutAdInput = {
    create?: XOR<userCreateWithoutAdInput, userUncheckedCreateWithoutAdInput>
    connectOrCreate?: userCreateOrConnectWithoutAdInput
    connect?: userWhereUniqueInput
  }

  export type requestCreateNestedManyWithoutAd_request_adToadInput = {
    create?: XOR<requestCreateWithoutAd_request_adToadInput, requestUncheckedCreateWithoutAd_request_adToadInput> | requestCreateWithoutAd_request_adToadInput[] | requestUncheckedCreateWithoutAd_request_adToadInput[]
    connectOrCreate?: requestCreateOrConnectWithoutAd_request_adToadInput | requestCreateOrConnectWithoutAd_request_adToadInput[]
    createMany?: requestCreateManyAd_request_adToadInputEnvelope
    connect?: requestWhereUniqueInput | requestWhereUniqueInput[]
  }

  export type viewsCreateNestedManyWithoutAd_views_adToadInput = {
    create?: XOR<viewsCreateWithoutAd_views_adToadInput, viewsUncheckedCreateWithoutAd_views_adToadInput> | viewsCreateWithoutAd_views_adToadInput[] | viewsUncheckedCreateWithoutAd_views_adToadInput[]
    connectOrCreate?: viewsCreateOrConnectWithoutAd_views_adToadInput | viewsCreateOrConnectWithoutAd_views_adToadInput[]
    createMany?: viewsCreateManyAd_views_adToadInputEnvelope
    connect?: viewsWhereUniqueInput | viewsWhereUniqueInput[]
  }

  export type requestUncheckedCreateNestedManyWithoutAd_request_adToadInput = {
    create?: XOR<requestCreateWithoutAd_request_adToadInput, requestUncheckedCreateWithoutAd_request_adToadInput> | requestCreateWithoutAd_request_adToadInput[] | requestUncheckedCreateWithoutAd_request_adToadInput[]
    connectOrCreate?: requestCreateOrConnectWithoutAd_request_adToadInput | requestCreateOrConnectWithoutAd_request_adToadInput[]
    createMany?: requestCreateManyAd_request_adToadInputEnvelope
    connect?: requestWhereUniqueInput | requestWhereUniqueInput[]
  }

  export type viewsUncheckedCreateNestedManyWithoutAd_views_adToadInput = {
    create?: XOR<viewsCreateWithoutAd_views_adToadInput, viewsUncheckedCreateWithoutAd_views_adToadInput> | viewsCreateWithoutAd_views_adToadInput[] | viewsUncheckedCreateWithoutAd_views_adToadInput[]
    connectOrCreate?: viewsCreateOrConnectWithoutAd_views_adToadInput | viewsCreateOrConnectWithoutAd_views_adToadInput[]
    createMany?: viewsCreateManyAd_views_adToadInputEnvelope
    connect?: viewsWhereUniqueInput | viewsWhereUniqueInput[]
  }

  export type StringFieldUpdateOperationsInput = {
    set?: string
  }

  export type IntFieldUpdateOperationsInput = {
    set?: number
    increment?: number
    decrement?: number
    multiply?: number
    divide?: number
  }

  export type Enumad_typeFieldUpdateOperationsInput = {
    set?: $Enums.ad_type
  }

  export type Enumad_categoryFieldUpdateOperationsInput = {
    set?: $Enums.ad_category
  }

  export type DateTimeFieldUpdateOperationsInput = {
    set?: Date | string
  }

  export type BoolFieldUpdateOperationsInput = {
    set?: boolean
  }

  export type userUpdateOneRequiredWithoutAdNestedInput = {
    create?: XOR<userCreateWithoutAdInput, userUncheckedCreateWithoutAdInput>
    connectOrCreate?: userCreateOrConnectWithoutAdInput
    upsert?: userUpsertWithoutAdInput
    connect?: userWhereUniqueInput
    update?: XOR<XOR<userUpdateToOneWithWhereWithoutAdInput, userUpdateWithoutAdInput>, userUncheckedUpdateWithoutAdInput>
  }

  export type requestUpdateManyWithoutAd_request_adToadNestedInput = {
    create?: XOR<requestCreateWithoutAd_request_adToadInput, requestUncheckedCreateWithoutAd_request_adToadInput> | requestCreateWithoutAd_request_adToadInput[] | requestUncheckedCreateWithoutAd_request_adToadInput[]
    connectOrCreate?: requestCreateOrConnectWithoutAd_request_adToadInput | requestCreateOrConnectWithoutAd_request_adToadInput[]
    upsert?: requestUpsertWithWhereUniqueWithoutAd_request_adToadInput | requestUpsertWithWhereUniqueWithoutAd_request_adToadInput[]
    createMany?: requestCreateManyAd_request_adToadInputEnvelope
    set?: requestWhereUniqueInput | requestWhereUniqueInput[]
    disconnect?: requestWhereUniqueInput | requestWhereUniqueInput[]
    delete?: requestWhereUniqueInput | requestWhereUniqueInput[]
    connect?: requestWhereUniqueInput | requestWhereUniqueInput[]
    update?: requestUpdateWithWhereUniqueWithoutAd_request_adToadInput | requestUpdateWithWhereUniqueWithoutAd_request_adToadInput[]
    updateMany?: requestUpdateManyWithWhereWithoutAd_request_adToadInput | requestUpdateManyWithWhereWithoutAd_request_adToadInput[]
    deleteMany?: requestScalarWhereInput | requestScalarWhereInput[]
  }

  export type viewsUpdateManyWithoutAd_views_adToadNestedInput = {
    create?: XOR<viewsCreateWithoutAd_views_adToadInput, viewsUncheckedCreateWithoutAd_views_adToadInput> | viewsCreateWithoutAd_views_adToadInput[] | viewsUncheckedCreateWithoutAd_views_adToadInput[]
    connectOrCreate?: viewsCreateOrConnectWithoutAd_views_adToadInput | viewsCreateOrConnectWithoutAd_views_adToadInput[]
    upsert?: viewsUpsertWithWhereUniqueWithoutAd_views_adToadInput | viewsUpsertWithWhereUniqueWithoutAd_views_adToadInput[]
    createMany?: viewsCreateManyAd_views_adToadInputEnvelope
    set?: viewsWhereUniqueInput | viewsWhereUniqueInput[]
    disconnect?: viewsWhereUniqueInput | viewsWhereUniqueInput[]
    delete?: viewsWhereUniqueInput | viewsWhereUniqueInput[]
    connect?: viewsWhereUniqueInput | viewsWhereUniqueInput[]
    update?: viewsUpdateWithWhereUniqueWithoutAd_views_adToadInput | viewsUpdateWithWhereUniqueWithoutAd_views_adToadInput[]
    updateMany?: viewsUpdateManyWithWhereWithoutAd_views_adToadInput | viewsUpdateManyWithWhereWithoutAd_views_adToadInput[]
    deleteMany?: viewsScalarWhereInput | viewsScalarWhereInput[]
  }

  export type requestUncheckedUpdateManyWithoutAd_request_adToadNestedInput = {
    create?: XOR<requestCreateWithoutAd_request_adToadInput, requestUncheckedCreateWithoutAd_request_adToadInput> | requestCreateWithoutAd_request_adToadInput[] | requestUncheckedCreateWithoutAd_request_adToadInput[]
    connectOrCreate?: requestCreateOrConnectWithoutAd_request_adToadInput | requestCreateOrConnectWithoutAd_request_adToadInput[]
    upsert?: requestUpsertWithWhereUniqueWithoutAd_request_adToadInput | requestUpsertWithWhereUniqueWithoutAd_request_adToadInput[]
    createMany?: requestCreateManyAd_request_adToadInputEnvelope
    set?: requestWhereUniqueInput | requestWhereUniqueInput[]
    disconnect?: requestWhereUniqueInput | requestWhereUniqueInput[]
    delete?: requestWhereUniqueInput | requestWhereUniqueInput[]
    connect?: requestWhereUniqueInput | requestWhereUniqueInput[]
    update?: requestUpdateWithWhereUniqueWithoutAd_request_adToadInput | requestUpdateWithWhereUniqueWithoutAd_request_adToadInput[]
    updateMany?: requestUpdateManyWithWhereWithoutAd_request_adToadInput | requestUpdateManyWithWhereWithoutAd_request_adToadInput[]
    deleteMany?: requestScalarWhereInput | requestScalarWhereInput[]
  }

  export type viewsUncheckedUpdateManyWithoutAd_views_adToadNestedInput = {
    create?: XOR<viewsCreateWithoutAd_views_adToadInput, viewsUncheckedCreateWithoutAd_views_adToadInput> | viewsCreateWithoutAd_views_adToadInput[] | viewsUncheckedCreateWithoutAd_views_adToadInput[]
    connectOrCreate?: viewsCreateOrConnectWithoutAd_views_adToadInput | viewsCreateOrConnectWithoutAd_views_adToadInput[]
    upsert?: viewsUpsertWithWhereUniqueWithoutAd_views_adToadInput | viewsUpsertWithWhereUniqueWithoutAd_views_adToadInput[]
    createMany?: viewsCreateManyAd_views_adToadInputEnvelope
    set?: viewsWhereUniqueInput | viewsWhereUniqueInput[]
    disconnect?: viewsWhereUniqueInput | viewsWhereUniqueInput[]
    delete?: viewsWhereUniqueInput | viewsWhereUniqueInput[]
    connect?: viewsWhereUniqueInput | viewsWhereUniqueInput[]
    update?: viewsUpdateWithWhereUniqueWithoutAd_views_adToadInput | viewsUpdateWithWhereUniqueWithoutAd_views_adToadInput[]
    updateMany?: viewsUpdateManyWithWhereWithoutAd_views_adToadInput | viewsUpdateManyWithWhereWithoutAd_views_adToadInput[]
    deleteMany?: viewsScalarWhereInput | viewsScalarWhereInput[]
  }

  export type adCreateNestedOneWithoutRequest_request_adToadInput = {
    create?: XOR<adCreateWithoutRequest_request_adToadInput, adUncheckedCreateWithoutRequest_request_adToadInput>
    connectOrCreate?: adCreateOrConnectWithoutRequest_request_adToadInput
    connect?: adWhereUniqueInput
  }

  export type userCreateNestedOneWithoutRequest_request_userTouserInput = {
    create?: XOR<userCreateWithoutRequest_request_userTouserInput, userUncheckedCreateWithoutRequest_request_userTouserInput>
    connectOrCreate?: userCreateOrConnectWithoutRequest_request_userTouserInput
    connect?: userWhereUniqueInput
  }

  export type Enumrequest_typeFieldUpdateOperationsInput = {
    set?: $Enums.request_type
  }

  export type NullableStringFieldUpdateOperationsInput = {
    set?: string | null
  }

  export type adUpdateOneWithoutRequest_request_adToadNestedInput = {
    create?: XOR<adCreateWithoutRequest_request_adToadInput, adUncheckedCreateWithoutRequest_request_adToadInput>
    connectOrCreate?: adCreateOrConnectWithoutRequest_request_adToadInput
    upsert?: adUpsertWithoutRequest_request_adToadInput
    disconnect?: adWhereInput | boolean
    delete?: adWhereInput | boolean
    connect?: adWhereUniqueInput
    update?: XOR<XOR<adUpdateToOneWithWhereWithoutRequest_request_adToadInput, adUpdateWithoutRequest_request_adToadInput>, adUncheckedUpdateWithoutRequest_request_adToadInput>
  }

  export type userUpdateOneRequiredWithoutRequest_request_userTouserNestedInput = {
    create?: XOR<userCreateWithoutRequest_request_userTouserInput, userUncheckedCreateWithoutRequest_request_userTouserInput>
    connectOrCreate?: userCreateOrConnectWithoutRequest_request_userTouserInput
    upsert?: userUpsertWithoutRequest_request_userTouserInput
    connect?: userWhereUniqueInput
    update?: XOR<XOR<userUpdateToOneWithWhereWithoutRequest_request_userTouserInput, userUpdateWithoutRequest_request_userTouserInput>, userUncheckedUpdateWithoutRequest_request_userTouserInput>
  }

  export type userCreateNestedOneWithoutSessionInput = {
    create?: XOR<userCreateWithoutSessionInput, userUncheckedCreateWithoutSessionInput>
    connectOrCreate?: userCreateOrConnectWithoutSessionInput
    connect?: userWhereUniqueInput
  }

  export type userUpdateOneRequiredWithoutSessionNestedInput = {
    create?: XOR<userCreateWithoutSessionInput, userUncheckedCreateWithoutSessionInput>
    connectOrCreate?: userCreateOrConnectWithoutSessionInput
    upsert?: userUpsertWithoutSessionInput
    connect?: userWhereUniqueInput
    update?: XOR<XOR<userUpdateToOneWithWhereWithoutSessionInput, userUpdateWithoutSessionInput>, userUncheckedUpdateWithoutSessionInput>
  }

  export type adCreateNestedManyWithoutUserInput = {
    create?: XOR<adCreateWithoutUserInput, adUncheckedCreateWithoutUserInput> | adCreateWithoutUserInput[] | adUncheckedCreateWithoutUserInput[]
    connectOrCreate?: adCreateOrConnectWithoutUserInput | adCreateOrConnectWithoutUserInput[]
    createMany?: adCreateManyUserInputEnvelope
    connect?: adWhereUniqueInput | adWhereUniqueInput[]
  }

  export type requestCreateNestedManyWithoutUser_request_userTouserInput = {
    create?: XOR<requestCreateWithoutUser_request_userTouserInput, requestUncheckedCreateWithoutUser_request_userTouserInput> | requestCreateWithoutUser_request_userTouserInput[] | requestUncheckedCreateWithoutUser_request_userTouserInput[]
    connectOrCreate?: requestCreateOrConnectWithoutUser_request_userTouserInput | requestCreateOrConnectWithoutUser_request_userTouserInput[]
    createMany?: requestCreateManyUser_request_userTouserInputEnvelope
    connect?: requestWhereUniqueInput | requestWhereUniqueInput[]
  }

  export type sessionCreateNestedManyWithoutUserInput = {
    create?: XOR<sessionCreateWithoutUserInput, sessionUncheckedCreateWithoutUserInput> | sessionCreateWithoutUserInput[] | sessionUncheckedCreateWithoutUserInput[]
    connectOrCreate?: sessionCreateOrConnectWithoutUserInput | sessionCreateOrConnectWithoutUserInput[]
    createMany?: sessionCreateManyUserInputEnvelope
    connect?: sessionWhereUniqueInput | sessionWhereUniqueInput[]
  }

  export type viewsCreateNestedManyWithoutUser_views_userTouserInput = {
    create?: XOR<viewsCreateWithoutUser_views_userTouserInput, viewsUncheckedCreateWithoutUser_views_userTouserInput> | viewsCreateWithoutUser_views_userTouserInput[] | viewsUncheckedCreateWithoutUser_views_userTouserInput[]
    connectOrCreate?: viewsCreateOrConnectWithoutUser_views_userTouserInput | viewsCreateOrConnectWithoutUser_views_userTouserInput[]
    createMany?: viewsCreateManyUser_views_userTouserInputEnvelope
    connect?: viewsWhereUniqueInput | viewsWhereUniqueInput[]
  }

  export type adUncheckedCreateNestedManyWithoutUserInput = {
    create?: XOR<adCreateWithoutUserInput, adUncheckedCreateWithoutUserInput> | adCreateWithoutUserInput[] | adUncheckedCreateWithoutUserInput[]
    connectOrCreate?: adCreateOrConnectWithoutUserInput | adCreateOrConnectWithoutUserInput[]
    createMany?: adCreateManyUserInputEnvelope
    connect?: adWhereUniqueInput | adWhereUniqueInput[]
  }

  export type requestUncheckedCreateNestedManyWithoutUser_request_userTouserInput = {
    create?: XOR<requestCreateWithoutUser_request_userTouserInput, requestUncheckedCreateWithoutUser_request_userTouserInput> | requestCreateWithoutUser_request_userTouserInput[] | requestUncheckedCreateWithoutUser_request_userTouserInput[]
    connectOrCreate?: requestCreateOrConnectWithoutUser_request_userTouserInput | requestCreateOrConnectWithoutUser_request_userTouserInput[]
    createMany?: requestCreateManyUser_request_userTouserInputEnvelope
    connect?: requestWhereUniqueInput | requestWhereUniqueInput[]
  }

  export type sessionUncheckedCreateNestedManyWithoutUserInput = {
    create?: XOR<sessionCreateWithoutUserInput, sessionUncheckedCreateWithoutUserInput> | sessionCreateWithoutUserInput[] | sessionUncheckedCreateWithoutUserInput[]
    connectOrCreate?: sessionCreateOrConnectWithoutUserInput | sessionCreateOrConnectWithoutUserInput[]
    createMany?: sessionCreateManyUserInputEnvelope
    connect?: sessionWhereUniqueInput | sessionWhereUniqueInput[]
  }

  export type viewsUncheckedCreateNestedManyWithoutUser_views_userTouserInput = {
    create?: XOR<viewsCreateWithoutUser_views_userTouserInput, viewsUncheckedCreateWithoutUser_views_userTouserInput> | viewsCreateWithoutUser_views_userTouserInput[] | viewsUncheckedCreateWithoutUser_views_userTouserInput[]
    connectOrCreate?: viewsCreateOrConnectWithoutUser_views_userTouserInput | viewsCreateOrConnectWithoutUser_views_userTouserInput[]
    createMany?: viewsCreateManyUser_views_userTouserInputEnvelope
    connect?: viewsWhereUniqueInput | viewsWhereUniqueInput[]
  }

  export type adUpdateManyWithoutUserNestedInput = {
    create?: XOR<adCreateWithoutUserInput, adUncheckedCreateWithoutUserInput> | adCreateWithoutUserInput[] | adUncheckedCreateWithoutUserInput[]
    connectOrCreate?: adCreateOrConnectWithoutUserInput | adCreateOrConnectWithoutUserInput[]
    upsert?: adUpsertWithWhereUniqueWithoutUserInput | adUpsertWithWhereUniqueWithoutUserInput[]
    createMany?: adCreateManyUserInputEnvelope
    set?: adWhereUniqueInput | adWhereUniqueInput[]
    disconnect?: adWhereUniqueInput | adWhereUniqueInput[]
    delete?: adWhereUniqueInput | adWhereUniqueInput[]
    connect?: adWhereUniqueInput | adWhereUniqueInput[]
    update?: adUpdateWithWhereUniqueWithoutUserInput | adUpdateWithWhereUniqueWithoutUserInput[]
    updateMany?: adUpdateManyWithWhereWithoutUserInput | adUpdateManyWithWhereWithoutUserInput[]
    deleteMany?: adScalarWhereInput | adScalarWhereInput[]
  }

  export type requestUpdateManyWithoutUser_request_userTouserNestedInput = {
    create?: XOR<requestCreateWithoutUser_request_userTouserInput, requestUncheckedCreateWithoutUser_request_userTouserInput> | requestCreateWithoutUser_request_userTouserInput[] | requestUncheckedCreateWithoutUser_request_userTouserInput[]
    connectOrCreate?: requestCreateOrConnectWithoutUser_request_userTouserInput | requestCreateOrConnectWithoutUser_request_userTouserInput[]
    upsert?: requestUpsertWithWhereUniqueWithoutUser_request_userTouserInput | requestUpsertWithWhereUniqueWithoutUser_request_userTouserInput[]
    createMany?: requestCreateManyUser_request_userTouserInputEnvelope
    set?: requestWhereUniqueInput | requestWhereUniqueInput[]
    disconnect?: requestWhereUniqueInput | requestWhereUniqueInput[]
    delete?: requestWhereUniqueInput | requestWhereUniqueInput[]
    connect?: requestWhereUniqueInput | requestWhereUniqueInput[]
    update?: requestUpdateWithWhereUniqueWithoutUser_request_userTouserInput | requestUpdateWithWhereUniqueWithoutUser_request_userTouserInput[]
    updateMany?: requestUpdateManyWithWhereWithoutUser_request_userTouserInput | requestUpdateManyWithWhereWithoutUser_request_userTouserInput[]
    deleteMany?: requestScalarWhereInput | requestScalarWhereInput[]
  }

  export type sessionUpdateManyWithoutUserNestedInput = {
    create?: XOR<sessionCreateWithoutUserInput, sessionUncheckedCreateWithoutUserInput> | sessionCreateWithoutUserInput[] | sessionUncheckedCreateWithoutUserInput[]
    connectOrCreate?: sessionCreateOrConnectWithoutUserInput | sessionCreateOrConnectWithoutUserInput[]
    upsert?: sessionUpsertWithWhereUniqueWithoutUserInput | sessionUpsertWithWhereUniqueWithoutUserInput[]
    createMany?: sessionCreateManyUserInputEnvelope
    set?: sessionWhereUniqueInput | sessionWhereUniqueInput[]
    disconnect?: sessionWhereUniqueInput | sessionWhereUniqueInput[]
    delete?: sessionWhereUniqueInput | sessionWhereUniqueInput[]
    connect?: sessionWhereUniqueInput | sessionWhereUniqueInput[]
    update?: sessionUpdateWithWhereUniqueWithoutUserInput | sessionUpdateWithWhereUniqueWithoutUserInput[]
    updateMany?: sessionUpdateManyWithWhereWithoutUserInput | sessionUpdateManyWithWhereWithoutUserInput[]
    deleteMany?: sessionScalarWhereInput | sessionScalarWhereInput[]
  }

  export type viewsUpdateManyWithoutUser_views_userTouserNestedInput = {
    create?: XOR<viewsCreateWithoutUser_views_userTouserInput, viewsUncheckedCreateWithoutUser_views_userTouserInput> | viewsCreateWithoutUser_views_userTouserInput[] | viewsUncheckedCreateWithoutUser_views_userTouserInput[]
    connectOrCreate?: viewsCreateOrConnectWithoutUser_views_userTouserInput | viewsCreateOrConnectWithoutUser_views_userTouserInput[]
    upsert?: viewsUpsertWithWhereUniqueWithoutUser_views_userTouserInput | viewsUpsertWithWhereUniqueWithoutUser_views_userTouserInput[]
    createMany?: viewsCreateManyUser_views_userTouserInputEnvelope
    set?: viewsWhereUniqueInput | viewsWhereUniqueInput[]
    disconnect?: viewsWhereUniqueInput | viewsWhereUniqueInput[]
    delete?: viewsWhereUniqueInput | viewsWhereUniqueInput[]
    connect?: viewsWhereUniqueInput | viewsWhereUniqueInput[]
    update?: viewsUpdateWithWhereUniqueWithoutUser_views_userTouserInput | viewsUpdateWithWhereUniqueWithoutUser_views_userTouserInput[]
    updateMany?: viewsUpdateManyWithWhereWithoutUser_views_userTouserInput | viewsUpdateManyWithWhereWithoutUser_views_userTouserInput[]
    deleteMany?: viewsScalarWhereInput | viewsScalarWhereInput[]
  }

  export type adUncheckedUpdateManyWithoutUserNestedInput = {
    create?: XOR<adCreateWithoutUserInput, adUncheckedCreateWithoutUserInput> | adCreateWithoutUserInput[] | adUncheckedCreateWithoutUserInput[]
    connectOrCreate?: adCreateOrConnectWithoutUserInput | adCreateOrConnectWithoutUserInput[]
    upsert?: adUpsertWithWhereUniqueWithoutUserInput | adUpsertWithWhereUniqueWithoutUserInput[]
    createMany?: adCreateManyUserInputEnvelope
    set?: adWhereUniqueInput | adWhereUniqueInput[]
    disconnect?: adWhereUniqueInput | adWhereUniqueInput[]
    delete?: adWhereUniqueInput | adWhereUniqueInput[]
    connect?: adWhereUniqueInput | adWhereUniqueInput[]
    update?: adUpdateWithWhereUniqueWithoutUserInput | adUpdateWithWhereUniqueWithoutUserInput[]
    updateMany?: adUpdateManyWithWhereWithoutUserInput | adUpdateManyWithWhereWithoutUserInput[]
    deleteMany?: adScalarWhereInput | adScalarWhereInput[]
  }

  export type requestUncheckedUpdateManyWithoutUser_request_userTouserNestedInput = {
    create?: XOR<requestCreateWithoutUser_request_userTouserInput, requestUncheckedCreateWithoutUser_request_userTouserInput> | requestCreateWithoutUser_request_userTouserInput[] | requestUncheckedCreateWithoutUser_request_userTouserInput[]
    connectOrCreate?: requestCreateOrConnectWithoutUser_request_userTouserInput | requestCreateOrConnectWithoutUser_request_userTouserInput[]
    upsert?: requestUpsertWithWhereUniqueWithoutUser_request_userTouserInput | requestUpsertWithWhereUniqueWithoutUser_request_userTouserInput[]
    createMany?: requestCreateManyUser_request_userTouserInputEnvelope
    set?: requestWhereUniqueInput | requestWhereUniqueInput[]
    disconnect?: requestWhereUniqueInput | requestWhereUniqueInput[]
    delete?: requestWhereUniqueInput | requestWhereUniqueInput[]
    connect?: requestWhereUniqueInput | requestWhereUniqueInput[]
    update?: requestUpdateWithWhereUniqueWithoutUser_request_userTouserInput | requestUpdateWithWhereUniqueWithoutUser_request_userTouserInput[]
    updateMany?: requestUpdateManyWithWhereWithoutUser_request_userTouserInput | requestUpdateManyWithWhereWithoutUser_request_userTouserInput[]
    deleteMany?: requestScalarWhereInput | requestScalarWhereInput[]
  }

  export type sessionUncheckedUpdateManyWithoutUserNestedInput = {
    create?: XOR<sessionCreateWithoutUserInput, sessionUncheckedCreateWithoutUserInput> | sessionCreateWithoutUserInput[] | sessionUncheckedCreateWithoutUserInput[]
    connectOrCreate?: sessionCreateOrConnectWithoutUserInput | sessionCreateOrConnectWithoutUserInput[]
    upsert?: sessionUpsertWithWhereUniqueWithoutUserInput | sessionUpsertWithWhereUniqueWithoutUserInput[]
    createMany?: sessionCreateManyUserInputEnvelope
    set?: sessionWhereUniqueInput | sessionWhereUniqueInput[]
    disconnect?: sessionWhereUniqueInput | sessionWhereUniqueInput[]
    delete?: sessionWhereUniqueInput | sessionWhereUniqueInput[]
    connect?: sessionWhereUniqueInput | sessionWhereUniqueInput[]
    update?: sessionUpdateWithWhereUniqueWithoutUserInput | sessionUpdateWithWhereUniqueWithoutUserInput[]
    updateMany?: sessionUpdateManyWithWhereWithoutUserInput | sessionUpdateManyWithWhereWithoutUserInput[]
    deleteMany?: sessionScalarWhereInput | sessionScalarWhereInput[]
  }

  export type viewsUncheckedUpdateManyWithoutUser_views_userTouserNestedInput = {
    create?: XOR<viewsCreateWithoutUser_views_userTouserInput, viewsUncheckedCreateWithoutUser_views_userTouserInput> | viewsCreateWithoutUser_views_userTouserInput[] | viewsUncheckedCreateWithoutUser_views_userTouserInput[]
    connectOrCreate?: viewsCreateOrConnectWithoutUser_views_userTouserInput | viewsCreateOrConnectWithoutUser_views_userTouserInput[]
    upsert?: viewsUpsertWithWhereUniqueWithoutUser_views_userTouserInput | viewsUpsertWithWhereUniqueWithoutUser_views_userTouserInput[]
    createMany?: viewsCreateManyUser_views_userTouserInputEnvelope
    set?: viewsWhereUniqueInput | viewsWhereUniqueInput[]
    disconnect?: viewsWhereUniqueInput | viewsWhereUniqueInput[]
    delete?: viewsWhereUniqueInput | viewsWhereUniqueInput[]
    connect?: viewsWhereUniqueInput | viewsWhereUniqueInput[]
    update?: viewsUpdateWithWhereUniqueWithoutUser_views_userTouserInput | viewsUpdateWithWhereUniqueWithoutUser_views_userTouserInput[]
    updateMany?: viewsUpdateManyWithWhereWithoutUser_views_userTouserInput | viewsUpdateManyWithWhereWithoutUser_views_userTouserInput[]
    deleteMany?: viewsScalarWhereInput | viewsScalarWhereInput[]
  }

  export type adCreateNestedOneWithoutViews_views_adToadInput = {
    create?: XOR<adCreateWithoutViews_views_adToadInput, adUncheckedCreateWithoutViews_views_adToadInput>
    connectOrCreate?: adCreateOrConnectWithoutViews_views_adToadInput
    connect?: adWhereUniqueInput
  }

  export type userCreateNestedOneWithoutViews_views_userTouserInput = {
    create?: XOR<userCreateWithoutViews_views_userTouserInput, userUncheckedCreateWithoutViews_views_userTouserInput>
    connectOrCreate?: userCreateOrConnectWithoutViews_views_userTouserInput
    connect?: userWhereUniqueInput
  }

  export type BigIntFieldUpdateOperationsInput = {
    set?: bigint | number
    increment?: bigint | number
    decrement?: bigint | number
    multiply?: bigint | number
    divide?: bigint | number
  }

  export type adUpdateOneRequiredWithoutViews_views_adToadNestedInput = {
    create?: XOR<adCreateWithoutViews_views_adToadInput, adUncheckedCreateWithoutViews_views_adToadInput>
    connectOrCreate?: adCreateOrConnectWithoutViews_views_adToadInput
    upsert?: adUpsertWithoutViews_views_adToadInput
    connect?: adWhereUniqueInput
    update?: XOR<XOR<adUpdateToOneWithWhereWithoutViews_views_adToadInput, adUpdateWithoutViews_views_adToadInput>, adUncheckedUpdateWithoutViews_views_adToadInput>
  }

  export type userUpdateOneRequiredWithoutViews_views_userTouserNestedInput = {
    create?: XOR<userCreateWithoutViews_views_userTouserInput, userUncheckedCreateWithoutViews_views_userTouserInput>
    connectOrCreate?: userCreateOrConnectWithoutViews_views_userTouserInput
    upsert?: userUpsertWithoutViews_views_userTouserInput
    connect?: userWhereUniqueInput
    update?: XOR<XOR<userUpdateToOneWithWhereWithoutViews_views_userTouserInput, userUpdateWithoutViews_views_userTouserInput>, userUncheckedUpdateWithoutViews_views_userTouserInput>
  }

  export type NestedStringFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[]
    notIn?: string[]
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    search?: string
    not?: NestedStringFilter<$PrismaModel> | string
  }

  export type NestedIntFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[]
    notIn?: number[]
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntFilter<$PrismaModel> | number
  }

  export type NestedEnumad_typeFilter<$PrismaModel = never> = {
    equals?: $Enums.ad_type | Enumad_typeFieldRefInput<$PrismaModel>
    in?: $Enums.ad_type[]
    notIn?: $Enums.ad_type[]
    not?: NestedEnumad_typeFilter<$PrismaModel> | $Enums.ad_type
  }

  export type NestedEnumad_categoryFilter<$PrismaModel = never> = {
    equals?: $Enums.ad_category | Enumad_categoryFieldRefInput<$PrismaModel>
    in?: $Enums.ad_category[]
    notIn?: $Enums.ad_category[]
    not?: NestedEnumad_categoryFilter<$PrismaModel> | $Enums.ad_category
  }

  export type NestedDateTimeFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    in?: Date[] | string[]
    notIn?: Date[] | string[]
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeFilter<$PrismaModel> | Date | string
  }

  export type NestedBoolFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel>
    not?: NestedBoolFilter<$PrismaModel> | boolean
  }

  export type NestedStringWithAggregatesFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[]
    notIn?: string[]
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    search?: string
    not?: NestedStringWithAggregatesFilter<$PrismaModel> | string
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedStringFilter<$PrismaModel>
    _max?: NestedStringFilter<$PrismaModel>
  }

  export type NestedIntWithAggregatesFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[]
    notIn?: number[]
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntWithAggregatesFilter<$PrismaModel> | number
    _count?: NestedIntFilter<$PrismaModel>
    _avg?: NestedFloatFilter<$PrismaModel>
    _sum?: NestedIntFilter<$PrismaModel>
    _min?: NestedIntFilter<$PrismaModel>
    _max?: NestedIntFilter<$PrismaModel>
  }

  export type NestedFloatFilter<$PrismaModel = never> = {
    equals?: number | FloatFieldRefInput<$PrismaModel>
    in?: number[]
    notIn?: number[]
    lt?: number | FloatFieldRefInput<$PrismaModel>
    lte?: number | FloatFieldRefInput<$PrismaModel>
    gt?: number | FloatFieldRefInput<$PrismaModel>
    gte?: number | FloatFieldRefInput<$PrismaModel>
    not?: NestedFloatFilter<$PrismaModel> | number
  }

  export type NestedEnumad_typeWithAggregatesFilter<$PrismaModel = never> = {
    equals?: $Enums.ad_type | Enumad_typeFieldRefInput<$PrismaModel>
    in?: $Enums.ad_type[]
    notIn?: $Enums.ad_type[]
    not?: NestedEnumad_typeWithAggregatesFilter<$PrismaModel> | $Enums.ad_type
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedEnumad_typeFilter<$PrismaModel>
    _max?: NestedEnumad_typeFilter<$PrismaModel>
  }

  export type NestedEnumad_categoryWithAggregatesFilter<$PrismaModel = never> = {
    equals?: $Enums.ad_category | Enumad_categoryFieldRefInput<$PrismaModel>
    in?: $Enums.ad_category[]
    notIn?: $Enums.ad_category[]
    not?: NestedEnumad_categoryWithAggregatesFilter<$PrismaModel> | $Enums.ad_category
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedEnumad_categoryFilter<$PrismaModel>
    _max?: NestedEnumad_categoryFilter<$PrismaModel>
  }

  export type NestedDateTimeWithAggregatesFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    in?: Date[] | string[]
    notIn?: Date[] | string[]
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeWithAggregatesFilter<$PrismaModel> | Date | string
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedDateTimeFilter<$PrismaModel>
    _max?: NestedDateTimeFilter<$PrismaModel>
  }

  export type NestedBoolWithAggregatesFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel>
    not?: NestedBoolWithAggregatesFilter<$PrismaModel> | boolean
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedBoolFilter<$PrismaModel>
    _max?: NestedBoolFilter<$PrismaModel>
  }

  export type NestedStringNullableFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel> | null
    in?: string[] | null
    notIn?: string[] | null
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    search?: string
    not?: NestedStringNullableFilter<$PrismaModel> | string | null
  }

  export type NestedEnumrequest_typeFilter<$PrismaModel = never> = {
    equals?: $Enums.request_type | Enumrequest_typeFieldRefInput<$PrismaModel>
    in?: $Enums.request_type[]
    notIn?: $Enums.request_type[]
    not?: NestedEnumrequest_typeFilter<$PrismaModel> | $Enums.request_type
  }

  export type NestedStringNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel> | null
    in?: string[] | null
    notIn?: string[] | null
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    search?: string
    not?: NestedStringNullableWithAggregatesFilter<$PrismaModel> | string | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedStringNullableFilter<$PrismaModel>
    _max?: NestedStringNullableFilter<$PrismaModel>
  }

  export type NestedIntNullableFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel> | null
    in?: number[] | null
    notIn?: number[] | null
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntNullableFilter<$PrismaModel> | number | null
  }

  export type NestedEnumrequest_typeWithAggregatesFilter<$PrismaModel = never> = {
    equals?: $Enums.request_type | Enumrequest_typeFieldRefInput<$PrismaModel>
    in?: $Enums.request_type[]
    notIn?: $Enums.request_type[]
    not?: NestedEnumrequest_typeWithAggregatesFilter<$PrismaModel> | $Enums.request_type
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedEnumrequest_typeFilter<$PrismaModel>
    _max?: NestedEnumrequest_typeFilter<$PrismaModel>
  }

  export type NestedBigIntFilter<$PrismaModel = never> = {
    equals?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    in?: bigint[] | number[]
    notIn?: bigint[] | number[]
    lt?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    lte?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    gt?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    gte?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    not?: NestedBigIntFilter<$PrismaModel> | bigint | number
  }

  export type NestedBigIntWithAggregatesFilter<$PrismaModel = never> = {
    equals?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    in?: bigint[] | number[]
    notIn?: bigint[] | number[]
    lt?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    lte?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    gt?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    gte?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    not?: NestedBigIntWithAggregatesFilter<$PrismaModel> | bigint | number
    _count?: NestedIntFilter<$PrismaModel>
    _avg?: NestedFloatFilter<$PrismaModel>
    _sum?: NestedBigIntFilter<$PrismaModel>
    _min?: NestedBigIntFilter<$PrismaModel>
    _max?: NestedBigIntFilter<$PrismaModel>
  }

  export type userCreateWithoutAdInput = {
    id?: string
    fullname: string
    username: string
    password: string
    email: string
    phone?: string | null
    points?: number
    joinDate: Date | string
    isVerified?: boolean
    isAdmin?: boolean
    isDeleted?: boolean
    verification: string
    request_request_userTouser?: requestCreateNestedManyWithoutUser_request_userTouserInput
    session?: sessionCreateNestedManyWithoutUserInput
    views_views_userTouser?: viewsCreateNestedManyWithoutUser_views_userTouserInput
  }

  export type userUncheckedCreateWithoutAdInput = {
    id?: string
    fullname: string
    username: string
    password: string
    email: string
    phone?: string | null
    points?: number
    joinDate: Date | string
    isVerified?: boolean
    isAdmin?: boolean
    isDeleted?: boolean
    verification: string
    request_request_userTouser?: requestUncheckedCreateNestedManyWithoutUser_request_userTouserInput
    session?: sessionUncheckedCreateNestedManyWithoutUserInput
    views_views_userTouser?: viewsUncheckedCreateNestedManyWithoutUser_views_userTouserInput
  }

  export type userCreateOrConnectWithoutAdInput = {
    where: userWhereUniqueInput
    create: XOR<userCreateWithoutAdInput, userUncheckedCreateWithoutAdInput>
  }

  export type requestCreateWithoutAd_request_adToadInput = {
    id?: string
    type: $Enums.request_type
    creation: Date | string
    param?: string | null
    user_request_userTouser: userCreateNestedOneWithoutRequest_request_userTouserInput
  }

  export type requestUncheckedCreateWithoutAd_request_adToadInput = {
    id?: string
    user: string
    type: $Enums.request_type
    creation: Date | string
    param?: string | null
  }

  export type requestCreateOrConnectWithoutAd_request_adToadInput = {
    where: requestWhereUniqueInput
    create: XOR<requestCreateWithoutAd_request_adToadInput, requestUncheckedCreateWithoutAd_request_adToadInput>
  }

  export type requestCreateManyAd_request_adToadInputEnvelope = {
    data: requestCreateManyAd_request_adToadInput | requestCreateManyAd_request_adToadInput[]
    skipDuplicates?: boolean
  }

  export type viewsCreateWithoutAd_views_adToadInput = {
    id?: bigint | number
    time: Date | string
    points: number
    user_views_userTouser: userCreateNestedOneWithoutViews_views_userTouserInput
  }

  export type viewsUncheckedCreateWithoutAd_views_adToadInput = {
    id?: bigint | number
    user: string
    time: Date | string
    points: number
  }

  export type viewsCreateOrConnectWithoutAd_views_adToadInput = {
    where: viewsWhereUniqueInput
    create: XOR<viewsCreateWithoutAd_views_adToadInput, viewsUncheckedCreateWithoutAd_views_adToadInput>
  }

  export type viewsCreateManyAd_views_adToadInputEnvelope = {
    data: viewsCreateManyAd_views_adToadInput | viewsCreateManyAd_views_adToadInput[]
    skipDuplicates?: boolean
  }

  export type userUpsertWithoutAdInput = {
    update: XOR<userUpdateWithoutAdInput, userUncheckedUpdateWithoutAdInput>
    create: XOR<userCreateWithoutAdInput, userUncheckedCreateWithoutAdInput>
    where?: userWhereInput
  }

  export type userUpdateToOneWithWhereWithoutAdInput = {
    where?: userWhereInput
    data: XOR<userUpdateWithoutAdInput, userUncheckedUpdateWithoutAdInput>
  }

  export type userUpdateWithoutAdInput = {
    id?: StringFieldUpdateOperationsInput | string
    fullname?: StringFieldUpdateOperationsInput | string
    username?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    points?: IntFieldUpdateOperationsInput | number
    joinDate?: DateTimeFieldUpdateOperationsInput | Date | string
    isVerified?: BoolFieldUpdateOperationsInput | boolean
    isAdmin?: BoolFieldUpdateOperationsInput | boolean
    isDeleted?: BoolFieldUpdateOperationsInput | boolean
    verification?: StringFieldUpdateOperationsInput | string
    request_request_userTouser?: requestUpdateManyWithoutUser_request_userTouserNestedInput
    session?: sessionUpdateManyWithoutUserNestedInput
    views_views_userTouser?: viewsUpdateManyWithoutUser_views_userTouserNestedInput
  }

  export type userUncheckedUpdateWithoutAdInput = {
    id?: StringFieldUpdateOperationsInput | string
    fullname?: StringFieldUpdateOperationsInput | string
    username?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    points?: IntFieldUpdateOperationsInput | number
    joinDate?: DateTimeFieldUpdateOperationsInput | Date | string
    isVerified?: BoolFieldUpdateOperationsInput | boolean
    isAdmin?: BoolFieldUpdateOperationsInput | boolean
    isDeleted?: BoolFieldUpdateOperationsInput | boolean
    verification?: StringFieldUpdateOperationsInput | string
    request_request_userTouser?: requestUncheckedUpdateManyWithoutUser_request_userTouserNestedInput
    session?: sessionUncheckedUpdateManyWithoutUserNestedInput
    views_views_userTouser?: viewsUncheckedUpdateManyWithoutUser_views_userTouserNestedInput
  }

  export type requestUpsertWithWhereUniqueWithoutAd_request_adToadInput = {
    where: requestWhereUniqueInput
    update: XOR<requestUpdateWithoutAd_request_adToadInput, requestUncheckedUpdateWithoutAd_request_adToadInput>
    create: XOR<requestCreateWithoutAd_request_adToadInput, requestUncheckedCreateWithoutAd_request_adToadInput>
  }

  export type requestUpdateWithWhereUniqueWithoutAd_request_adToadInput = {
    where: requestWhereUniqueInput
    data: XOR<requestUpdateWithoutAd_request_adToadInput, requestUncheckedUpdateWithoutAd_request_adToadInput>
  }

  export type requestUpdateManyWithWhereWithoutAd_request_adToadInput = {
    where: requestScalarWhereInput
    data: XOR<requestUpdateManyMutationInput, requestUncheckedUpdateManyWithoutAd_request_adToadInput>
  }

  export type requestScalarWhereInput = {
    AND?: requestScalarWhereInput | requestScalarWhereInput[]
    OR?: requestScalarWhereInput[]
    NOT?: requestScalarWhereInput | requestScalarWhereInput[]
    id?: StringFilter<"request"> | string
    ad?: StringNullableFilter<"request"> | string | null
    user?: StringFilter<"request"> | string
    type?: Enumrequest_typeFilter<"request"> | $Enums.request_type
    creation?: DateTimeFilter<"request"> | Date | string
    param?: StringNullableFilter<"request"> | string | null
  }

  export type viewsUpsertWithWhereUniqueWithoutAd_views_adToadInput = {
    where: viewsWhereUniqueInput
    update: XOR<viewsUpdateWithoutAd_views_adToadInput, viewsUncheckedUpdateWithoutAd_views_adToadInput>
    create: XOR<viewsCreateWithoutAd_views_adToadInput, viewsUncheckedCreateWithoutAd_views_adToadInput>
  }

  export type viewsUpdateWithWhereUniqueWithoutAd_views_adToadInput = {
    where: viewsWhereUniqueInput
    data: XOR<viewsUpdateWithoutAd_views_adToadInput, viewsUncheckedUpdateWithoutAd_views_adToadInput>
  }

  export type viewsUpdateManyWithWhereWithoutAd_views_adToadInput = {
    where: viewsScalarWhereInput
    data: XOR<viewsUpdateManyMutationInput, viewsUncheckedUpdateManyWithoutAd_views_adToadInput>
  }

  export type viewsScalarWhereInput = {
    AND?: viewsScalarWhereInput | viewsScalarWhereInput[]
    OR?: viewsScalarWhereInput[]
    NOT?: viewsScalarWhereInput | viewsScalarWhereInput[]
    id?: BigIntFilter<"views"> | bigint | number
    ad?: StringFilter<"views"> | string
    user?: StringFilter<"views"> | string
    time?: DateTimeFilter<"views"> | Date | string
    points?: IntFilter<"views"> | number
  }

  export type adCreateWithoutRequest_request_adToadInput = {
    id?: string
    name: string
    path: string
    views?: number
    targetViews: number
    image: string
    type: $Enums.ad_type
    category: $Enums.ad_category
    creation_date: Date | string
    renewal_date: Date | string
    isPublished?: boolean
    keywords: string
    user: userCreateNestedOneWithoutAdInput
    views_views_adToad?: viewsCreateNestedManyWithoutAd_views_adToadInput
  }

  export type adUncheckedCreateWithoutRequest_request_adToadInput = {
    id?: string
    name: string
    path: string
    views?: number
    targetViews: number
    image: string
    type: $Enums.ad_type
    category: $Enums.ad_category
    creation_date: Date | string
    renewal_date: Date | string
    isPublished?: boolean
    keywords: string
    userid: string
    views_views_adToad?: viewsUncheckedCreateNestedManyWithoutAd_views_adToadInput
  }

  export type adCreateOrConnectWithoutRequest_request_adToadInput = {
    where: adWhereUniqueInput
    create: XOR<adCreateWithoutRequest_request_adToadInput, adUncheckedCreateWithoutRequest_request_adToadInput>
  }

  export type userCreateWithoutRequest_request_userTouserInput = {
    id?: string
    fullname: string
    username: string
    password: string
    email: string
    phone?: string | null
    points?: number
    joinDate: Date | string
    isVerified?: boolean
    isAdmin?: boolean
    isDeleted?: boolean
    verification: string
    ad?: adCreateNestedManyWithoutUserInput
    session?: sessionCreateNestedManyWithoutUserInput
    views_views_userTouser?: viewsCreateNestedManyWithoutUser_views_userTouserInput
  }

  export type userUncheckedCreateWithoutRequest_request_userTouserInput = {
    id?: string
    fullname: string
    username: string
    password: string
    email: string
    phone?: string | null
    points?: number
    joinDate: Date | string
    isVerified?: boolean
    isAdmin?: boolean
    isDeleted?: boolean
    verification: string
    ad?: adUncheckedCreateNestedManyWithoutUserInput
    session?: sessionUncheckedCreateNestedManyWithoutUserInput
    views_views_userTouser?: viewsUncheckedCreateNestedManyWithoutUser_views_userTouserInput
  }

  export type userCreateOrConnectWithoutRequest_request_userTouserInput = {
    where: userWhereUniqueInput
    create: XOR<userCreateWithoutRequest_request_userTouserInput, userUncheckedCreateWithoutRequest_request_userTouserInput>
  }

  export type adUpsertWithoutRequest_request_adToadInput = {
    update: XOR<adUpdateWithoutRequest_request_adToadInput, adUncheckedUpdateWithoutRequest_request_adToadInput>
    create: XOR<adCreateWithoutRequest_request_adToadInput, adUncheckedCreateWithoutRequest_request_adToadInput>
    where?: adWhereInput
  }

  export type adUpdateToOneWithWhereWithoutRequest_request_adToadInput = {
    where?: adWhereInput
    data: XOR<adUpdateWithoutRequest_request_adToadInput, adUncheckedUpdateWithoutRequest_request_adToadInput>
  }

  export type adUpdateWithoutRequest_request_adToadInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    path?: StringFieldUpdateOperationsInput | string
    views?: IntFieldUpdateOperationsInput | number
    targetViews?: IntFieldUpdateOperationsInput | number
    image?: StringFieldUpdateOperationsInput | string
    type?: Enumad_typeFieldUpdateOperationsInput | $Enums.ad_type
    category?: Enumad_categoryFieldUpdateOperationsInput | $Enums.ad_category
    creation_date?: DateTimeFieldUpdateOperationsInput | Date | string
    renewal_date?: DateTimeFieldUpdateOperationsInput | Date | string
    isPublished?: BoolFieldUpdateOperationsInput | boolean
    keywords?: StringFieldUpdateOperationsInput | string
    user?: userUpdateOneRequiredWithoutAdNestedInput
    views_views_adToad?: viewsUpdateManyWithoutAd_views_adToadNestedInput
  }

  export type adUncheckedUpdateWithoutRequest_request_adToadInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    path?: StringFieldUpdateOperationsInput | string
    views?: IntFieldUpdateOperationsInput | number
    targetViews?: IntFieldUpdateOperationsInput | number
    image?: StringFieldUpdateOperationsInput | string
    type?: Enumad_typeFieldUpdateOperationsInput | $Enums.ad_type
    category?: Enumad_categoryFieldUpdateOperationsInput | $Enums.ad_category
    creation_date?: DateTimeFieldUpdateOperationsInput | Date | string
    renewal_date?: DateTimeFieldUpdateOperationsInput | Date | string
    isPublished?: BoolFieldUpdateOperationsInput | boolean
    keywords?: StringFieldUpdateOperationsInput | string
    userid?: StringFieldUpdateOperationsInput | string
    views_views_adToad?: viewsUncheckedUpdateManyWithoutAd_views_adToadNestedInput
  }

  export type userUpsertWithoutRequest_request_userTouserInput = {
    update: XOR<userUpdateWithoutRequest_request_userTouserInput, userUncheckedUpdateWithoutRequest_request_userTouserInput>
    create: XOR<userCreateWithoutRequest_request_userTouserInput, userUncheckedCreateWithoutRequest_request_userTouserInput>
    where?: userWhereInput
  }

  export type userUpdateToOneWithWhereWithoutRequest_request_userTouserInput = {
    where?: userWhereInput
    data: XOR<userUpdateWithoutRequest_request_userTouserInput, userUncheckedUpdateWithoutRequest_request_userTouserInput>
  }

  export type userUpdateWithoutRequest_request_userTouserInput = {
    id?: StringFieldUpdateOperationsInput | string
    fullname?: StringFieldUpdateOperationsInput | string
    username?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    points?: IntFieldUpdateOperationsInput | number
    joinDate?: DateTimeFieldUpdateOperationsInput | Date | string
    isVerified?: BoolFieldUpdateOperationsInput | boolean
    isAdmin?: BoolFieldUpdateOperationsInput | boolean
    isDeleted?: BoolFieldUpdateOperationsInput | boolean
    verification?: StringFieldUpdateOperationsInput | string
    ad?: adUpdateManyWithoutUserNestedInput
    session?: sessionUpdateManyWithoutUserNestedInput
    views_views_userTouser?: viewsUpdateManyWithoutUser_views_userTouserNestedInput
  }

  export type userUncheckedUpdateWithoutRequest_request_userTouserInput = {
    id?: StringFieldUpdateOperationsInput | string
    fullname?: StringFieldUpdateOperationsInput | string
    username?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    points?: IntFieldUpdateOperationsInput | number
    joinDate?: DateTimeFieldUpdateOperationsInput | Date | string
    isVerified?: BoolFieldUpdateOperationsInput | boolean
    isAdmin?: BoolFieldUpdateOperationsInput | boolean
    isDeleted?: BoolFieldUpdateOperationsInput | boolean
    verification?: StringFieldUpdateOperationsInput | string
    ad?: adUncheckedUpdateManyWithoutUserNestedInput
    session?: sessionUncheckedUpdateManyWithoutUserNestedInput
    views_views_userTouser?: viewsUncheckedUpdateManyWithoutUser_views_userTouserNestedInput
  }

  export type userCreateWithoutSessionInput = {
    id?: string
    fullname: string
    username: string
    password: string
    email: string
    phone?: string | null
    points?: number
    joinDate: Date | string
    isVerified?: boolean
    isAdmin?: boolean
    isDeleted?: boolean
    verification: string
    ad?: adCreateNestedManyWithoutUserInput
    request_request_userTouser?: requestCreateNestedManyWithoutUser_request_userTouserInput
    views_views_userTouser?: viewsCreateNestedManyWithoutUser_views_userTouserInput
  }

  export type userUncheckedCreateWithoutSessionInput = {
    id?: string
    fullname: string
    username: string
    password: string
    email: string
    phone?: string | null
    points?: number
    joinDate: Date | string
    isVerified?: boolean
    isAdmin?: boolean
    isDeleted?: boolean
    verification: string
    ad?: adUncheckedCreateNestedManyWithoutUserInput
    request_request_userTouser?: requestUncheckedCreateNestedManyWithoutUser_request_userTouserInput
    views_views_userTouser?: viewsUncheckedCreateNestedManyWithoutUser_views_userTouserInput
  }

  export type userCreateOrConnectWithoutSessionInput = {
    where: userWhereUniqueInput
    create: XOR<userCreateWithoutSessionInput, userUncheckedCreateWithoutSessionInput>
  }

  export type userUpsertWithoutSessionInput = {
    update: XOR<userUpdateWithoutSessionInput, userUncheckedUpdateWithoutSessionInput>
    create: XOR<userCreateWithoutSessionInput, userUncheckedCreateWithoutSessionInput>
    where?: userWhereInput
  }

  export type userUpdateToOneWithWhereWithoutSessionInput = {
    where?: userWhereInput
    data: XOR<userUpdateWithoutSessionInput, userUncheckedUpdateWithoutSessionInput>
  }

  export type userUpdateWithoutSessionInput = {
    id?: StringFieldUpdateOperationsInput | string
    fullname?: StringFieldUpdateOperationsInput | string
    username?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    points?: IntFieldUpdateOperationsInput | number
    joinDate?: DateTimeFieldUpdateOperationsInput | Date | string
    isVerified?: BoolFieldUpdateOperationsInput | boolean
    isAdmin?: BoolFieldUpdateOperationsInput | boolean
    isDeleted?: BoolFieldUpdateOperationsInput | boolean
    verification?: StringFieldUpdateOperationsInput | string
    ad?: adUpdateManyWithoutUserNestedInput
    request_request_userTouser?: requestUpdateManyWithoutUser_request_userTouserNestedInput
    views_views_userTouser?: viewsUpdateManyWithoutUser_views_userTouserNestedInput
  }

  export type userUncheckedUpdateWithoutSessionInput = {
    id?: StringFieldUpdateOperationsInput | string
    fullname?: StringFieldUpdateOperationsInput | string
    username?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    points?: IntFieldUpdateOperationsInput | number
    joinDate?: DateTimeFieldUpdateOperationsInput | Date | string
    isVerified?: BoolFieldUpdateOperationsInput | boolean
    isAdmin?: BoolFieldUpdateOperationsInput | boolean
    isDeleted?: BoolFieldUpdateOperationsInput | boolean
    verification?: StringFieldUpdateOperationsInput | string
    ad?: adUncheckedUpdateManyWithoutUserNestedInput
    request_request_userTouser?: requestUncheckedUpdateManyWithoutUser_request_userTouserNestedInput
    views_views_userTouser?: viewsUncheckedUpdateManyWithoutUser_views_userTouserNestedInput
  }

  export type adCreateWithoutUserInput = {
    id?: string
    name: string
    path: string
    views?: number
    targetViews: number
    image: string
    type: $Enums.ad_type
    category: $Enums.ad_category
    creation_date: Date | string
    renewal_date: Date | string
    isPublished?: boolean
    keywords: string
    request_request_adToad?: requestCreateNestedManyWithoutAd_request_adToadInput
    views_views_adToad?: viewsCreateNestedManyWithoutAd_views_adToadInput
  }

  export type adUncheckedCreateWithoutUserInput = {
    id?: string
    name: string
    path: string
    views?: number
    targetViews: number
    image: string
    type: $Enums.ad_type
    category: $Enums.ad_category
    creation_date: Date | string
    renewal_date: Date | string
    isPublished?: boolean
    keywords: string
    request_request_adToad?: requestUncheckedCreateNestedManyWithoutAd_request_adToadInput
    views_views_adToad?: viewsUncheckedCreateNestedManyWithoutAd_views_adToadInput
  }

  export type adCreateOrConnectWithoutUserInput = {
    where: adWhereUniqueInput
    create: XOR<adCreateWithoutUserInput, adUncheckedCreateWithoutUserInput>
  }

  export type adCreateManyUserInputEnvelope = {
    data: adCreateManyUserInput | adCreateManyUserInput[]
    skipDuplicates?: boolean
  }

  export type requestCreateWithoutUser_request_userTouserInput = {
    id?: string
    type: $Enums.request_type
    creation: Date | string
    param?: string | null
    ad_request_adToad?: adCreateNestedOneWithoutRequest_request_adToadInput
  }

  export type requestUncheckedCreateWithoutUser_request_userTouserInput = {
    id?: string
    ad?: string | null
    type: $Enums.request_type
    creation: Date | string
    param?: string | null
  }

  export type requestCreateOrConnectWithoutUser_request_userTouserInput = {
    where: requestWhereUniqueInput
    create: XOR<requestCreateWithoutUser_request_userTouserInput, requestUncheckedCreateWithoutUser_request_userTouserInput>
  }

  export type requestCreateManyUser_request_userTouserInputEnvelope = {
    data: requestCreateManyUser_request_userTouserInput | requestCreateManyUser_request_userTouserInput[]
    skipDuplicates?: boolean
  }

  export type sessionCreateWithoutUserInput = {
    id?: string
    ip: string
    last_used: Date | string
    is_reset?: boolean
  }

  export type sessionUncheckedCreateWithoutUserInput = {
    id?: string
    ip: string
    last_used: Date | string
    is_reset?: boolean
  }

  export type sessionCreateOrConnectWithoutUserInput = {
    where: sessionWhereUniqueInput
    create: XOR<sessionCreateWithoutUserInput, sessionUncheckedCreateWithoutUserInput>
  }

  export type sessionCreateManyUserInputEnvelope = {
    data: sessionCreateManyUserInput | sessionCreateManyUserInput[]
    skipDuplicates?: boolean
  }

  export type viewsCreateWithoutUser_views_userTouserInput = {
    id?: bigint | number
    time: Date | string
    points: number
    ad_views_adToad: adCreateNestedOneWithoutViews_views_adToadInput
  }

  export type viewsUncheckedCreateWithoutUser_views_userTouserInput = {
    id?: bigint | number
    ad: string
    time: Date | string
    points: number
  }

  export type viewsCreateOrConnectWithoutUser_views_userTouserInput = {
    where: viewsWhereUniqueInput
    create: XOR<viewsCreateWithoutUser_views_userTouserInput, viewsUncheckedCreateWithoutUser_views_userTouserInput>
  }

  export type viewsCreateManyUser_views_userTouserInputEnvelope = {
    data: viewsCreateManyUser_views_userTouserInput | viewsCreateManyUser_views_userTouserInput[]
    skipDuplicates?: boolean
  }

  export type adUpsertWithWhereUniqueWithoutUserInput = {
    where: adWhereUniqueInput
    update: XOR<adUpdateWithoutUserInput, adUncheckedUpdateWithoutUserInput>
    create: XOR<adCreateWithoutUserInput, adUncheckedCreateWithoutUserInput>
  }

  export type adUpdateWithWhereUniqueWithoutUserInput = {
    where: adWhereUniqueInput
    data: XOR<adUpdateWithoutUserInput, adUncheckedUpdateWithoutUserInput>
  }

  export type adUpdateManyWithWhereWithoutUserInput = {
    where: adScalarWhereInput
    data: XOR<adUpdateManyMutationInput, adUncheckedUpdateManyWithoutUserInput>
  }

  export type adScalarWhereInput = {
    AND?: adScalarWhereInput | adScalarWhereInput[]
    OR?: adScalarWhereInput[]
    NOT?: adScalarWhereInput | adScalarWhereInput[]
    id?: StringFilter<"ad"> | string
    name?: StringFilter<"ad"> | string
    path?: StringFilter<"ad"> | string
    views?: IntFilter<"ad"> | number
    targetViews?: IntFilter<"ad"> | number
    image?: StringFilter<"ad"> | string
    type?: Enumad_typeFilter<"ad"> | $Enums.ad_type
    category?: Enumad_categoryFilter<"ad"> | $Enums.ad_category
    creation_date?: DateTimeFilter<"ad"> | Date | string
    renewal_date?: DateTimeFilter<"ad"> | Date | string
    isPublished?: BoolFilter<"ad"> | boolean
    keywords?: StringFilter<"ad"> | string
    userid?: StringFilter<"ad"> | string
  }

  export type requestUpsertWithWhereUniqueWithoutUser_request_userTouserInput = {
    where: requestWhereUniqueInput
    update: XOR<requestUpdateWithoutUser_request_userTouserInput, requestUncheckedUpdateWithoutUser_request_userTouserInput>
    create: XOR<requestCreateWithoutUser_request_userTouserInput, requestUncheckedCreateWithoutUser_request_userTouserInput>
  }

  export type requestUpdateWithWhereUniqueWithoutUser_request_userTouserInput = {
    where: requestWhereUniqueInput
    data: XOR<requestUpdateWithoutUser_request_userTouserInput, requestUncheckedUpdateWithoutUser_request_userTouserInput>
  }

  export type requestUpdateManyWithWhereWithoutUser_request_userTouserInput = {
    where: requestScalarWhereInput
    data: XOR<requestUpdateManyMutationInput, requestUncheckedUpdateManyWithoutUser_request_userTouserInput>
  }

  export type sessionUpsertWithWhereUniqueWithoutUserInput = {
    where: sessionWhereUniqueInput
    update: XOR<sessionUpdateWithoutUserInput, sessionUncheckedUpdateWithoutUserInput>
    create: XOR<sessionCreateWithoutUserInput, sessionUncheckedCreateWithoutUserInput>
  }

  export type sessionUpdateWithWhereUniqueWithoutUserInput = {
    where: sessionWhereUniqueInput
    data: XOR<sessionUpdateWithoutUserInput, sessionUncheckedUpdateWithoutUserInput>
  }

  export type sessionUpdateManyWithWhereWithoutUserInput = {
    where: sessionScalarWhereInput
    data: XOR<sessionUpdateManyMutationInput, sessionUncheckedUpdateManyWithoutUserInput>
  }

  export type sessionScalarWhereInput = {
    AND?: sessionScalarWhereInput | sessionScalarWhereInput[]
    OR?: sessionScalarWhereInput[]
    NOT?: sessionScalarWhereInput | sessionScalarWhereInput[]
    id?: StringFilter<"session"> | string
    userid?: StringFilter<"session"> | string
    ip?: StringFilter<"session"> | string
    last_used?: DateTimeFilter<"session"> | Date | string
    is_reset?: BoolFilter<"session"> | boolean
  }

  export type viewsUpsertWithWhereUniqueWithoutUser_views_userTouserInput = {
    where: viewsWhereUniqueInput
    update: XOR<viewsUpdateWithoutUser_views_userTouserInput, viewsUncheckedUpdateWithoutUser_views_userTouserInput>
    create: XOR<viewsCreateWithoutUser_views_userTouserInput, viewsUncheckedCreateWithoutUser_views_userTouserInput>
  }

  export type viewsUpdateWithWhereUniqueWithoutUser_views_userTouserInput = {
    where: viewsWhereUniqueInput
    data: XOR<viewsUpdateWithoutUser_views_userTouserInput, viewsUncheckedUpdateWithoutUser_views_userTouserInput>
  }

  export type viewsUpdateManyWithWhereWithoutUser_views_userTouserInput = {
    where: viewsScalarWhereInput
    data: XOR<viewsUpdateManyMutationInput, viewsUncheckedUpdateManyWithoutUser_views_userTouserInput>
  }

  export type adCreateWithoutViews_views_adToadInput = {
    id?: string
    name: string
    path: string
    views?: number
    targetViews: number
    image: string
    type: $Enums.ad_type
    category: $Enums.ad_category
    creation_date: Date | string
    renewal_date: Date | string
    isPublished?: boolean
    keywords: string
    user: userCreateNestedOneWithoutAdInput
    request_request_adToad?: requestCreateNestedManyWithoutAd_request_adToadInput
  }

  export type adUncheckedCreateWithoutViews_views_adToadInput = {
    id?: string
    name: string
    path: string
    views?: number
    targetViews: number
    image: string
    type: $Enums.ad_type
    category: $Enums.ad_category
    creation_date: Date | string
    renewal_date: Date | string
    isPublished?: boolean
    keywords: string
    userid: string
    request_request_adToad?: requestUncheckedCreateNestedManyWithoutAd_request_adToadInput
  }

  export type adCreateOrConnectWithoutViews_views_adToadInput = {
    where: adWhereUniqueInput
    create: XOR<adCreateWithoutViews_views_adToadInput, adUncheckedCreateWithoutViews_views_adToadInput>
  }

  export type userCreateWithoutViews_views_userTouserInput = {
    id?: string
    fullname: string
    username: string
    password: string
    email: string
    phone?: string | null
    points?: number
    joinDate: Date | string
    isVerified?: boolean
    isAdmin?: boolean
    isDeleted?: boolean
    verification: string
    ad?: adCreateNestedManyWithoutUserInput
    request_request_userTouser?: requestCreateNestedManyWithoutUser_request_userTouserInput
    session?: sessionCreateNestedManyWithoutUserInput
  }

  export type userUncheckedCreateWithoutViews_views_userTouserInput = {
    id?: string
    fullname: string
    username: string
    password: string
    email: string
    phone?: string | null
    points?: number
    joinDate: Date | string
    isVerified?: boolean
    isAdmin?: boolean
    isDeleted?: boolean
    verification: string
    ad?: adUncheckedCreateNestedManyWithoutUserInput
    request_request_userTouser?: requestUncheckedCreateNestedManyWithoutUser_request_userTouserInput
    session?: sessionUncheckedCreateNestedManyWithoutUserInput
  }

  export type userCreateOrConnectWithoutViews_views_userTouserInput = {
    where: userWhereUniqueInput
    create: XOR<userCreateWithoutViews_views_userTouserInput, userUncheckedCreateWithoutViews_views_userTouserInput>
  }

  export type adUpsertWithoutViews_views_adToadInput = {
    update: XOR<adUpdateWithoutViews_views_adToadInput, adUncheckedUpdateWithoutViews_views_adToadInput>
    create: XOR<adCreateWithoutViews_views_adToadInput, adUncheckedCreateWithoutViews_views_adToadInput>
    where?: adWhereInput
  }

  export type adUpdateToOneWithWhereWithoutViews_views_adToadInput = {
    where?: adWhereInput
    data: XOR<adUpdateWithoutViews_views_adToadInput, adUncheckedUpdateWithoutViews_views_adToadInput>
  }

  export type adUpdateWithoutViews_views_adToadInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    path?: StringFieldUpdateOperationsInput | string
    views?: IntFieldUpdateOperationsInput | number
    targetViews?: IntFieldUpdateOperationsInput | number
    image?: StringFieldUpdateOperationsInput | string
    type?: Enumad_typeFieldUpdateOperationsInput | $Enums.ad_type
    category?: Enumad_categoryFieldUpdateOperationsInput | $Enums.ad_category
    creation_date?: DateTimeFieldUpdateOperationsInput | Date | string
    renewal_date?: DateTimeFieldUpdateOperationsInput | Date | string
    isPublished?: BoolFieldUpdateOperationsInput | boolean
    keywords?: StringFieldUpdateOperationsInput | string
    user?: userUpdateOneRequiredWithoutAdNestedInput
    request_request_adToad?: requestUpdateManyWithoutAd_request_adToadNestedInput
  }

  export type adUncheckedUpdateWithoutViews_views_adToadInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    path?: StringFieldUpdateOperationsInput | string
    views?: IntFieldUpdateOperationsInput | number
    targetViews?: IntFieldUpdateOperationsInput | number
    image?: StringFieldUpdateOperationsInput | string
    type?: Enumad_typeFieldUpdateOperationsInput | $Enums.ad_type
    category?: Enumad_categoryFieldUpdateOperationsInput | $Enums.ad_category
    creation_date?: DateTimeFieldUpdateOperationsInput | Date | string
    renewal_date?: DateTimeFieldUpdateOperationsInput | Date | string
    isPublished?: BoolFieldUpdateOperationsInput | boolean
    keywords?: StringFieldUpdateOperationsInput | string
    userid?: StringFieldUpdateOperationsInput | string
    request_request_adToad?: requestUncheckedUpdateManyWithoutAd_request_adToadNestedInput
  }

  export type userUpsertWithoutViews_views_userTouserInput = {
    update: XOR<userUpdateWithoutViews_views_userTouserInput, userUncheckedUpdateWithoutViews_views_userTouserInput>
    create: XOR<userCreateWithoutViews_views_userTouserInput, userUncheckedCreateWithoutViews_views_userTouserInput>
    where?: userWhereInput
  }

  export type userUpdateToOneWithWhereWithoutViews_views_userTouserInput = {
    where?: userWhereInput
    data: XOR<userUpdateWithoutViews_views_userTouserInput, userUncheckedUpdateWithoutViews_views_userTouserInput>
  }

  export type userUpdateWithoutViews_views_userTouserInput = {
    id?: StringFieldUpdateOperationsInput | string
    fullname?: StringFieldUpdateOperationsInput | string
    username?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    points?: IntFieldUpdateOperationsInput | number
    joinDate?: DateTimeFieldUpdateOperationsInput | Date | string
    isVerified?: BoolFieldUpdateOperationsInput | boolean
    isAdmin?: BoolFieldUpdateOperationsInput | boolean
    isDeleted?: BoolFieldUpdateOperationsInput | boolean
    verification?: StringFieldUpdateOperationsInput | string
    ad?: adUpdateManyWithoutUserNestedInput
    request_request_userTouser?: requestUpdateManyWithoutUser_request_userTouserNestedInput
    session?: sessionUpdateManyWithoutUserNestedInput
  }

  export type userUncheckedUpdateWithoutViews_views_userTouserInput = {
    id?: StringFieldUpdateOperationsInput | string
    fullname?: StringFieldUpdateOperationsInput | string
    username?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    points?: IntFieldUpdateOperationsInput | number
    joinDate?: DateTimeFieldUpdateOperationsInput | Date | string
    isVerified?: BoolFieldUpdateOperationsInput | boolean
    isAdmin?: BoolFieldUpdateOperationsInput | boolean
    isDeleted?: BoolFieldUpdateOperationsInput | boolean
    verification?: StringFieldUpdateOperationsInput | string
    ad?: adUncheckedUpdateManyWithoutUserNestedInput
    request_request_userTouser?: requestUncheckedUpdateManyWithoutUser_request_userTouserNestedInput
    session?: sessionUncheckedUpdateManyWithoutUserNestedInput
  }

  export type requestCreateManyAd_request_adToadInput = {
    id?: string
    user: string
    type: $Enums.request_type
    creation: Date | string
    param?: string | null
  }

  export type viewsCreateManyAd_views_adToadInput = {
    id?: bigint | number
    user: string
    time: Date | string
    points: number
  }

  export type requestUpdateWithoutAd_request_adToadInput = {
    id?: StringFieldUpdateOperationsInput | string
    type?: Enumrequest_typeFieldUpdateOperationsInput | $Enums.request_type
    creation?: DateTimeFieldUpdateOperationsInput | Date | string
    param?: NullableStringFieldUpdateOperationsInput | string | null
    user_request_userTouser?: userUpdateOneRequiredWithoutRequest_request_userTouserNestedInput
  }

  export type requestUncheckedUpdateWithoutAd_request_adToadInput = {
    id?: StringFieldUpdateOperationsInput | string
    user?: StringFieldUpdateOperationsInput | string
    type?: Enumrequest_typeFieldUpdateOperationsInput | $Enums.request_type
    creation?: DateTimeFieldUpdateOperationsInput | Date | string
    param?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type requestUncheckedUpdateManyWithoutAd_request_adToadInput = {
    id?: StringFieldUpdateOperationsInput | string
    user?: StringFieldUpdateOperationsInput | string
    type?: Enumrequest_typeFieldUpdateOperationsInput | $Enums.request_type
    creation?: DateTimeFieldUpdateOperationsInput | Date | string
    param?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type viewsUpdateWithoutAd_views_adToadInput = {
    id?: BigIntFieldUpdateOperationsInput | bigint | number
    time?: DateTimeFieldUpdateOperationsInput | Date | string
    points?: IntFieldUpdateOperationsInput | number
    user_views_userTouser?: userUpdateOneRequiredWithoutViews_views_userTouserNestedInput
  }

  export type viewsUncheckedUpdateWithoutAd_views_adToadInput = {
    id?: BigIntFieldUpdateOperationsInput | bigint | number
    user?: StringFieldUpdateOperationsInput | string
    time?: DateTimeFieldUpdateOperationsInput | Date | string
    points?: IntFieldUpdateOperationsInput | number
  }

  export type viewsUncheckedUpdateManyWithoutAd_views_adToadInput = {
    id?: BigIntFieldUpdateOperationsInput | bigint | number
    user?: StringFieldUpdateOperationsInput | string
    time?: DateTimeFieldUpdateOperationsInput | Date | string
    points?: IntFieldUpdateOperationsInput | number
  }

  export type adCreateManyUserInput = {
    id?: string
    name: string
    path: string
    views?: number
    targetViews: number
    image: string
    type: $Enums.ad_type
    category: $Enums.ad_category
    creation_date: Date | string
    renewal_date: Date | string
    isPublished?: boolean
    keywords: string
  }

  export type requestCreateManyUser_request_userTouserInput = {
    id?: string
    ad?: string | null
    type: $Enums.request_type
    creation: Date | string
    param?: string | null
  }

  export type sessionCreateManyUserInput = {
    id?: string
    ip: string
    last_used: Date | string
    is_reset?: boolean
  }

  export type viewsCreateManyUser_views_userTouserInput = {
    id?: bigint | number
    ad: string
    time: Date | string
    points: number
  }

  export type adUpdateWithoutUserInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    path?: StringFieldUpdateOperationsInput | string
    views?: IntFieldUpdateOperationsInput | number
    targetViews?: IntFieldUpdateOperationsInput | number
    image?: StringFieldUpdateOperationsInput | string
    type?: Enumad_typeFieldUpdateOperationsInput | $Enums.ad_type
    category?: Enumad_categoryFieldUpdateOperationsInput | $Enums.ad_category
    creation_date?: DateTimeFieldUpdateOperationsInput | Date | string
    renewal_date?: DateTimeFieldUpdateOperationsInput | Date | string
    isPublished?: BoolFieldUpdateOperationsInput | boolean
    keywords?: StringFieldUpdateOperationsInput | string
    request_request_adToad?: requestUpdateManyWithoutAd_request_adToadNestedInput
    views_views_adToad?: viewsUpdateManyWithoutAd_views_adToadNestedInput
  }

  export type adUncheckedUpdateWithoutUserInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    path?: StringFieldUpdateOperationsInput | string
    views?: IntFieldUpdateOperationsInput | number
    targetViews?: IntFieldUpdateOperationsInput | number
    image?: StringFieldUpdateOperationsInput | string
    type?: Enumad_typeFieldUpdateOperationsInput | $Enums.ad_type
    category?: Enumad_categoryFieldUpdateOperationsInput | $Enums.ad_category
    creation_date?: DateTimeFieldUpdateOperationsInput | Date | string
    renewal_date?: DateTimeFieldUpdateOperationsInput | Date | string
    isPublished?: BoolFieldUpdateOperationsInput | boolean
    keywords?: StringFieldUpdateOperationsInput | string
    request_request_adToad?: requestUncheckedUpdateManyWithoutAd_request_adToadNestedInput
    views_views_adToad?: viewsUncheckedUpdateManyWithoutAd_views_adToadNestedInput
  }

  export type adUncheckedUpdateManyWithoutUserInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    path?: StringFieldUpdateOperationsInput | string
    views?: IntFieldUpdateOperationsInput | number
    targetViews?: IntFieldUpdateOperationsInput | number
    image?: StringFieldUpdateOperationsInput | string
    type?: Enumad_typeFieldUpdateOperationsInput | $Enums.ad_type
    category?: Enumad_categoryFieldUpdateOperationsInput | $Enums.ad_category
    creation_date?: DateTimeFieldUpdateOperationsInput | Date | string
    renewal_date?: DateTimeFieldUpdateOperationsInput | Date | string
    isPublished?: BoolFieldUpdateOperationsInput | boolean
    keywords?: StringFieldUpdateOperationsInput | string
  }

  export type requestUpdateWithoutUser_request_userTouserInput = {
    id?: StringFieldUpdateOperationsInput | string
    type?: Enumrequest_typeFieldUpdateOperationsInput | $Enums.request_type
    creation?: DateTimeFieldUpdateOperationsInput | Date | string
    param?: NullableStringFieldUpdateOperationsInput | string | null
    ad_request_adToad?: adUpdateOneWithoutRequest_request_adToadNestedInput
  }

  export type requestUncheckedUpdateWithoutUser_request_userTouserInput = {
    id?: StringFieldUpdateOperationsInput | string
    ad?: NullableStringFieldUpdateOperationsInput | string | null
    type?: Enumrequest_typeFieldUpdateOperationsInput | $Enums.request_type
    creation?: DateTimeFieldUpdateOperationsInput | Date | string
    param?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type requestUncheckedUpdateManyWithoutUser_request_userTouserInput = {
    id?: StringFieldUpdateOperationsInput | string
    ad?: NullableStringFieldUpdateOperationsInput | string | null
    type?: Enumrequest_typeFieldUpdateOperationsInput | $Enums.request_type
    creation?: DateTimeFieldUpdateOperationsInput | Date | string
    param?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type sessionUpdateWithoutUserInput = {
    id?: StringFieldUpdateOperationsInput | string
    ip?: StringFieldUpdateOperationsInput | string
    last_used?: DateTimeFieldUpdateOperationsInput | Date | string
    is_reset?: BoolFieldUpdateOperationsInput | boolean
  }

  export type sessionUncheckedUpdateWithoutUserInput = {
    id?: StringFieldUpdateOperationsInput | string
    ip?: StringFieldUpdateOperationsInput | string
    last_used?: DateTimeFieldUpdateOperationsInput | Date | string
    is_reset?: BoolFieldUpdateOperationsInput | boolean
  }

  export type sessionUncheckedUpdateManyWithoutUserInput = {
    id?: StringFieldUpdateOperationsInput | string
    ip?: StringFieldUpdateOperationsInput | string
    last_used?: DateTimeFieldUpdateOperationsInput | Date | string
    is_reset?: BoolFieldUpdateOperationsInput | boolean
  }

  export type viewsUpdateWithoutUser_views_userTouserInput = {
    id?: BigIntFieldUpdateOperationsInput | bigint | number
    time?: DateTimeFieldUpdateOperationsInput | Date | string
    points?: IntFieldUpdateOperationsInput | number
    ad_views_adToad?: adUpdateOneRequiredWithoutViews_views_adToadNestedInput
  }

  export type viewsUncheckedUpdateWithoutUser_views_userTouserInput = {
    id?: BigIntFieldUpdateOperationsInput | bigint | number
    ad?: StringFieldUpdateOperationsInput | string
    time?: DateTimeFieldUpdateOperationsInput | Date | string
    points?: IntFieldUpdateOperationsInput | number
  }

  export type viewsUncheckedUpdateManyWithoutUser_views_userTouserInput = {
    id?: BigIntFieldUpdateOperationsInput | bigint | number
    ad?: StringFieldUpdateOperationsInput | string
    time?: DateTimeFieldUpdateOperationsInput | Date | string
    points?: IntFieldUpdateOperationsInput | number
  }



  /**
   * Batch Payload for updateMany & deleteMany & createMany
   */

  export type BatchPayload = {
    count: number
  }

  /**
   * DMMF
   */
  export const dmmf: runtime.BaseDMMF
}