"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.create_ad_handle = create_ad_handle;
exports.getUserAdsHandle = getUserAdsHandle;
exports.editAdHandle = editAdHandle;
exports.getCategoryAdsHandle = getCategoryAdsHandle;
const ads_utils_1 = require("../utils/ads_utils");
const category_utils_1 = require("../utils/category_utils");
const promises_1 = require("fs/promises");
const view_utils_1 = require("../utils/view_utils");
function create_ad_handle(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const session = req.body.session;
        const id = req.body.id;
        const name = req.body.name;
        const path = req.body.path;
        const image = req.file;
        const type = req.body.type;
        const targetViews = parseInt(req.body.targetViews);
        const category = parseInt(req.body.category);
        const keywords = req.body.keywords;
        if (session && id && name && image && path && ["Dynamic", "Fixed"].includes(type) &&
            (category != null) && keywords && targetViews >= 50) {
            const result = yield (0, ads_utils_1.create_ad)(session, id, name, path, targetViews, image.path, type, (0, category_utils_1.number_to_category)(category), keywords);
            if (!result) {
                yield (0, promises_1.rm)(image.path);
            }
            res.json(result ? "Success" : "No Authority");
        }
        else {
            if (image) {
                yield (0, promises_1.rm)(image.path);
            }
            res.json("Invalid");
        }
    });
}
function getUserAdsHandle(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const id = req.body.id;
        const session = req.body.session;
        if (id) {
            const ads = yield (0, ads_utils_1.get_user_ads)(session, id);
            res.json(ads);
        }
        else {
            res.json([]);
        }
    });
}
function editAdHandle(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const session = req.body.session;
        const id = req.body.ad;
        const name = req.body.name;
        const path = req.body.path;
        const image = req.file;
        const type = req.body.type;
        const targetViews = parseInt(req.body.targetViews);
        const category = parseInt(req.body.category);
        const keywords = req.body.keywords;
        if (session && id && name && path && (category != null) && keywords && targetViews >= 50 &&
            ["Dynamic", "Fixed"].includes(type)) {
            yield (0, ads_utils_1.edit_ad)(session, id, name, path, targetViews, type, image ? image.path : null, (0, category_utils_1.number_to_category)(category), keywords);
            res.json("Success");
        }
        else {
            if (image) {
                yield (0, promises_1.rm)(image.path);
            }
            res.json("Invalid");
        }
    });
}
function getCategoryAdsHandle(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const id = req.body.id;
        const category = parseInt(req.body.category);
        const full = req.body.full === true || req.body.full === "true";
        console.log(`[Fetch Ads] Category: ${category}, Full: ${full}, Raw full value: ${req.body.full}`);
        if ((category != null)) {
            let ads = [];
            if (category == -1) {
                // Fixed ads (للـ Slider في الصفحة الرئيسية)
                ads = yield (0, ads_utils_1.get_fixed_ads)(full ? 100 : 50);
                // Fallback to general ads if no fixed ads available
                if (ads.length === 0) {
                    console.log('[Fetch Ads] No fixed ads found, falling back to general ads');
                    ads = yield (0, ads_utils_1.get_ads)(full ? 100 : 50);
                }
            }
            else if (category == 0) {
                // جميع الإعلانات Dynamic (للصفحة الرئيسية)
                // نجلب مباشرة بدون توصيات معقدة
                ads = yield (0, ads_utils_1.get_ads)(full ? 500 : 100);
                console.log(`[Fetch Ads] Fetched ${ads.length} general dynamic ads`);
            }
            else {
                // Category specific ads
                if (!full)
                    ads = yield (0, ads_utils_1.get_ads_per_category)(id, (0, category_utils_1.number_to_category)(category), 50);
                else
                    ads = yield (0, ads_utils_1.get_ads_per_category)(id, (0, category_utils_1.number_to_category)(category), 100);
            }
            console.log(`[Fetch Ads] Returning ${ads.length} ads`);
            res.json(ads);
        }
        else {
            res.json([]);
        }
    });
}
