"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.login_handle = login_handle;
exports.register_handle = register_handle;
exports.verify_reset_handle = verify_reset_handle;
exports.verify_user_handle = verify_user_handle;
exports.pass_reset_handle = pass_reset_handle;
exports.isVerifiedHandle = isVerifiedHandle;
exports.resend_code_handle = resend_code_handle;
exports.change_pass_handle = change_pass_handle;
exports.logout_handle = logout_handle;
exports.user_profile_handle = user_profile_handle;
exports.user_delete_handle = user_delete_handle;
const user_utils_1 = require("../utils/user_utils");
const crypto_1 = require("crypto");
const session_utils_1 = require("../utils/session_utils");
const auth_response_1 = require("../responses/auth_response");
function login_handle(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const user = req.body.user;
        const pass = req.body.pass;
        if (user && pass) {
            const userid = yield (0, user_utils_1.find_user_by_username)(user);
            if (userid) {
                const data = yield (0, user_utils_1.find_user_by_id)(userid);
                
                // Check if account is deleted (only block deleted accounts, not unverified ones)
                if (data === null || data === void 0 ? void 0 : data.isDeleted) {
                    res.json(auth_response_1.auth_response.custom("Account has been deleted"));
                    return;
                }
                
                // Note: We don't block login for unverified accounts - Flutter will handle routing to verification page
                
                const hash = (0, crypto_1.createHash)("sha256").update(pass).digest("base64");
                if (hash === (data === null || data === void 0 ? void 0 : data.password)) {
                    if (req.ip) {
                        const session = yield (0, session_utils_1.create_session)(userid, req.ip);
                        res.json(auth_response_1.auth_response.valid(userid, session));
                    }
                    else {
                        res.json(auth_response_1.auth_response.custom("Can't Fetch IP, Invalid Request"));
                    }
                }
                else {
                    res.json(auth_response_1.auth_response.invalid_auth());
                }
            }
            else {
                res.json(auth_response_1.auth_response.invalid_auth());
            }
        }
        else {
            res.json(auth_response_1.auth_response.invalid_request());
        }
    });
}
function register_handle(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const name = req.body.name;
        const pass = req.body.pass;
        const user = req.body.user;
        const email = req.body.email;
        const phone = req.body.phone;
        if (name && pass && user && email) {
            if (yield (0, user_utils_1.create_user)(name, user, pass, email, phone)) {
                res.json(auth_response_1.auth_response.success());
            }
            else {
                res.json(auth_response_1.auth_response.custom("User Exists"));
            }
        }
        else {
            res.json(auth_response_1.auth_response.invalid_request());
        }
    });
}
function verify_reset_handle(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const email = req.body.email;
        const session = req.body.session;
        const code = req.body.code;
        if (email && session && code) {
            const id = yield (0, user_utils_1.find_user_by_email)(email);
            if (id) {
                if (yield (0, user_utils_1.verify_user)(id, code)) {
                    res.json(auth_response_1.auth_response.success());
                }
                else {
                    res.json(auth_response_1.auth_response.custom("Can't Verify"));
                }
            }
            else {
                res.json(auth_response_1.auth_response.invalid_auth());
            }
        }
        else {
            res.json(auth_response_1.auth_response.invalid_request());
        }
    });
}
function verify_user_handle(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const id = req.body.id;
        const code = req.body.code;
        if (id && code) {
            if (yield (0, user_utils_1.verify_user)(id, code)) {
                res.json(auth_response_1.auth_response.success());
            }
            else {
                res.json(auth_response_1.auth_response.custom("Can't Verify"));
            }
        }
        else {
            res.json(auth_response_1.auth_response.invalid_request());
        }
    });
}
function pass_reset_handle(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const email = req.body.email;
        const ip = req.ip;
        if (email && ip) {
            const id = yield (0, user_utils_1.find_user_by_email)(email);
            if (id) {
                const session = yield (0, session_utils_1.create_session)(id, ip, true);
                yield (0, user_utils_1.resendCode)(id);
                res.json(auth_response_1.auth_response.valid(email, session));
            }
            else {
                res.json(auth_response_1.auth_response.invalid_auth());
            }
        }
        else {
            res.json(auth_response_1.auth_response.invalid_request());
        }
    });
}
function isVerifiedHandle(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const id = req.body.id;
        if (id) {
            const x = yield (0, user_utils_1.isVerified)(id);
            if (x) {
                res.json(auth_response_1.auth_response.success());
            }
            else {
                res.json(auth_response_1.auth_response.custom("Not Verified"));
            }
        }
        else {
            res.json(auth_response_1.auth_response.invalid_request());
        }
    });
}
function resend_code_handle(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const id = req.body.id;
        const email = req.body.email;
        if (id) {
            const x = yield (0, user_utils_1.resendCode)(id);
            if (x) {
                res.json(auth_response_1.auth_response.success());
            }
            else {
                res.json(auth_response_1.auth_response.custom("Not Verified"));
            }
        }
        else if (email) {
            const id = yield (0, user_utils_1.find_user_by_email)(email);
            if (id) {
                const x = yield (0, user_utils_1.resendCode)(id);
                if (x) {
                    res.json(auth_response_1.auth_response.success());
                }
                else {
                    res.json(auth_response_1.auth_response.custom("Not Verified"));
                }
            }
            else {
                res.json(auth_response_1.auth_response.invalid_auth());
            }
        }
        else {
            res.json(auth_response_1.auth_response.invalid_request());
        }
    });
}
function change_pass_handle(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const email = req.body.email;
        const pass = req.body.pass;
        let id = null;
        if (email) {
            id = yield (0, user_utils_1.find_user_by_email)(email);
        }
        if (id && pass) {
            const hash = (0, crypto_1.createHash)("sha256").update(pass).digest("base64");
            yield (0, user_utils_1.changePass)(id, hash);
            res.json(auth_response_1.auth_response.success());
        }
        else {
            res.json(auth_response_1.auth_response.invalid_request());
        }
    });
}
function logout_handle(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const session = req.body.session;
        if (session) {
            yield (0, session_utils_1.destroy_session)(session);
            res.json(auth_response_1.auth_response.success());
        }
        else {
            res.json(auth_response_1.auth_response.invalid_request());
        }
    });
}
function user_profile_handle(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const id = req.body.id;
        if (id) {
            const user = yield (0, user_utils_1.get_user_profile)(id);
            if (user)
                res.json(user);
            else {
                res.json(auth_response_1.auth_response.invalid_auth());
            }
        }
        else {
            res.json(auth_response_1.auth_response.invalid_request());
        }
    });
}
function user_delete_handle(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const id = req.body.id;
        if (id) {
            const status = yield (0, user_utils_1.delete_user)(id);
            if (status)
                res.json(auth_response_1.auth_response.success());
            else {
                res.json(auth_response_1.auth_response.invalid_auth());
            }
        }
        else {
            res.json(auth_response_1.auth_response.invalid_request());
        }
    });
}
