"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCreateAdsHandle = getCreateAdsHandle;
exports.getRenewAdsHandle = getRenewAdsHandle;
exports.getMoneyRequestHandle = getMoneyRequestHandle;
exports.getMyRequestsHandle = getMyRequestsHandle;
exports.handleRequestHandle = handleRequestHandle;
exports.renewReqHandle = renewReqHandle;
exports.deleteRequestHandle = deleteRequestHandle;
exports.exchangePointstHandle = exchangePointstHandle;
const request_util_1 = require("../utils/request_util");
const client_1 = require("@prisma/client");
function getCreateAdsHandle(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const tier = req.body.tier;
        if (tier != null && tier != undefined) {
            res.json(yield (0, request_util_1.get_ad_requests)(tier));
        }
        else {
            res.json(yield (0, request_util_1.get_ad_requests)());
        }
    });
}
function getRenewAdsHandle(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const tier = req.body.tier;
        if (tier != null && tier != undefined) {
            res.json(yield (0, request_util_1.get_renew_requests)(tier));
        }
        else {
            res.json(yield (0, request_util_1.get_renew_requests)());
        }
    });
}
function getMoneyRequestHandle(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        res.json(yield (0, request_util_1.get_money_requests)());
    });
}
function getMyRequestsHandle(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const user = req.body.id;
        if (user) {
            res.json(yield (0, request_util_1.get_my_requests)(user));
        }
        else {
            res.json([]);
        }
    });
}
function handleRequestHandle(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const reqID = req.body.reqID;
        const state = req.body.state;
        if (reqID && state != null) {
            if (state) {
                yield (0, request_util_1.accept_request)(reqID);
            }
            else {
                yield (0, request_util_1.reject_request)(reqID);
            }
            res.json("Success");
        }
        else {
            res.json("Invalid Request");
        }
    });
}
function renewReqHandle(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const id = req.body.id;
        const ad = req.body.ad;
        const tier = req.body.tier;
        if (id && ad && tier != null) {
            yield (0, request_util_1.create_request)(id, ad, client_1.request_type.Renew, tier);
            res.json("Success");
        }
        else {
            res.json("Invalid Request");
        }
    });
}
function deleteRequestHandle(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const reqID = req.body.reqID;
        if (reqID) {
            yield (0, request_util_1.delete_request)(reqID);
            res.json("Success");
        }
        else {
            res.json("Invalid Request");
        }
    });
}
function exchangePointstHandle(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const user = req.body.id;
        if (user) {
            if (yield (0, request_util_1.exchange_points)(user)) {
                res.json("Success");
            }
            else {
                res.json("No Points");
            }
        }
        else {
            res.json("Invalid Request");
        }
    });
}
