"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.admin_auth_middleware = admin_auth_middleware;
const user_utils_1 = require("../utils/user_utils");
function admin_auth_middleware(req, res, next) {
    return __awaiter(this, void 0, void 0, function* () {
        const id = req.body.id;
        if (id) {
            (yield (0, user_utils_1.is_admin)(id)) ? next() : res.json("No Authority");
        }
        else {
            res.json("Invalid Request");
        }
    });
}
