"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.validate_session_middleware = validate_session_middleware;
const session_utils_1 = require("../utils/session_utils");
const auth_response_1 = require("../responses/auth_response");
const user_utils_1 = require("../utils/user_utils");
function validate_session_middleware(req, res, next) {
    return __awaiter(this, void 0, void 0, function* () {
        const id = req.body.id;
        const session = req.body.session;
        const ip = req.ip;
        const email = req.body.email;
        if (id && session && ip) {
            const val = yield (0, session_utils_1.validate_session)(session, ip, id);
            if (val) {
                next();
            }
            else {
                res.json(auth_response_1.auth_response.invalid_session());
            }
        }
        else if (email && session && ip) {
            const id = yield (0, user_utils_1.find_user_by_email)(email);
            if (id) {
                if (yield (0, session_utils_1.validate_session)(session, ip, id, true)) {
                    next();
                }
                else {
                    res.json(auth_response_1.auth_response.invalid_session());
                }
            }
            else {
                res.json(auth_response_1.auth_response.invalid_session());
            }
        }
        else {
            res.json(auth_response_1.auth_response.invalid_request());
        }
    });
}
