"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteUserRoute = exports.profileRoute = exports.isLoggedinRoute = exports.logoutRoute = exports.validateResetRoute = exports.passResetRoute = exports.changePassRoute = exports.isAdminRoute = exports.resendCodeRoute = exports.isVerifiedRoute = exports.verifyRoute = exports.registerRoute = exports.loginRoute = void 0;
const express_1 = require("express");
const auth_handles_1 = require("../handles/auth_handles");
const validate_session_1 = require("../middlewares/validate_session");
const validate_admin_1 = require("../middlewares/validate_admin");
const loginRoute = (0, express_1.Router)();
exports.loginRoute = loginRoute;
const isLoggedinRoute = (0, express_1.Router)();
exports.isLoggedinRoute = isLoggedinRoute;
const logoutRoute = (0, express_1.Router)();
exports.logoutRoute = logoutRoute;
const registerRoute = (0, express_1.Router)();
exports.registerRoute = registerRoute;
const verifyRoute = (0, express_1.Router)();
exports.verifyRoute = verifyRoute;
const passResetRoute = (0, express_1.Router)();
exports.passResetRoute = passResetRoute;
const validateResetRoute = (0, express_1.Router)();
exports.validateResetRoute = validateResetRoute;
const isVerifiedRoute = (0, express_1.Router)();
exports.isVerifiedRoute = isVerifiedRoute;
const resendCodeRoute = (0, express_1.Router)();
exports.resendCodeRoute = resendCodeRoute;
const changePassRoute = (0, express_1.Router)();
exports.changePassRoute = changePassRoute;
const isAdminRoute = (0, express_1.Router)();
exports.isAdminRoute = isAdminRoute;
const profileRoute = (0, express_1.Router)();
exports.profileRoute = profileRoute;
const deleteUserRoute = (0, express_1.Router)();
exports.deleteUserRoute = deleteUserRoute;
loginRoute.post("/", auth_handles_1.login_handle);
registerRoute.post("/", auth_handles_1.register_handle);
isLoggedinRoute.post("/", validate_session_1.validate_session_middleware, (req, res) => { res.send({ status: "Valid" }); });
verifyRoute.post("/", validate_session_1.validate_session_middleware, auth_handles_1.verify_user_handle);
passResetRoute.post("/", auth_handles_1.pass_reset_handle);
validateResetRoute.post("/", validate_session_1.validate_session_middleware, auth_handles_1.verify_reset_handle);
isVerifiedRoute.post("/", validate_session_1.validate_session_middleware, auth_handles_1.isVerifiedHandle);
resendCodeRoute.post("/", validate_session_1.validate_session_middleware, auth_handles_1.resend_code_handle);
changePassRoute.post("/", validate_session_1.validate_session_middleware, auth_handles_1.change_pass_handle);
logoutRoute.post("/", validate_session_1.validate_session_middleware, auth_handles_1.logout_handle);
deleteUserRoute.delete("/", validate_session_1.validate_session_middleware, auth_handles_1.user_delete_handle);
profileRoute.post("/", validate_session_1.validate_session_middleware, auth_handles_1.user_profile_handle);
isAdminRoute.post("/", validate_session_1.validate_session_middleware, validate_admin_1.admin_auth_middleware, (req, res) => { res.send({ status: "Valid" }); });
