"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.exchangePointsRoute = exports.deleteRequestRoute = exports.renewAdRoute = exports.handleReqRoute = exports.getMyRequestRoute = exports.getMoneyRequestRoute = exports.getRenewAdRoute = exports.getCreateAdRoute = void 0;
const express_1 = require("express");
const validate_session_1 = require("../middlewares/validate_session");
const validate_admin_1 = require("../middlewares/validate_admin");
const request_handle_1 = require("../handles/request_handle");
const request_authority_1 = require("../middlewares/request_authority");
exports.getCreateAdRoute = (0, express_1.Router)();
exports.getRenewAdRoute = (0, express_1.Router)();
exports.getMoneyRequestRoute = (0, express_1.Router)();
exports.getMyRequestRoute = (0, express_1.Router)();
exports.handleReqRoute = (0, express_1.Router)();
exports.renewAdRoute = (0, express_1.Router)();
exports.deleteRequestRoute = (0, express_1.Router)();
exports.exchangePointsRoute = (0, express_1.Router)();
exports.getCreateAdRoute.post("/", validate_session_1.validate_session_middleware, validate_admin_1.admin_auth_middleware, request_handle_1.getCreateAdsHandle);
exports.getRenewAdRoute.post("/", validate_session_1.validate_session_middleware, validate_admin_1.admin_auth_middleware, request_handle_1.getRenewAdsHandle);
exports.getMoneyRequestRoute.post("/", validate_session_1.validate_session_middleware, validate_admin_1.admin_auth_middleware, request_handle_1.getMoneyRequestHandle);
exports.getMyRequestRoute.post("/", validate_session_1.validate_session_middleware, request_handle_1.getMyRequestsHandle);
exports.handleReqRoute.put("/", validate_session_1.validate_session_middleware, validate_admin_1.admin_auth_middleware, request_handle_1.handleRequestHandle);
exports.deleteRequestRoute.delete("/", validate_session_1.validate_session_middleware, request_authority_1.auth_middleware, request_handle_1.deleteRequestHandle);
exports.renewAdRoute.post("/", validate_session_1.validate_session_middleware, request_authority_1.auth_middleware, request_handle_1.renewReqHandle);
exports.exchangePointsRoute.put("/", validate_session_1.validate_session_middleware, request_handle_1.exchangePointstHandle);
