"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.create_ad = create_ad;
exports.get_ad_user = get_ad_user;
exports.get_user_ads = get_user_ads;
exports.get_ads = get_ads;
exports.get_fixed_ads = get_fixed_ads;
exports.get_ads_per_category = get_ads_per_category;
exports.edit_ad = edit_ad;
exports.delete_ad = delete_ad;
const client_1 = require("@prisma/client");
const session_utils_1 = require("./session_utils");
const category_utils_1 = require("./category_utils");
const promises_1 = __importDefault(require("fs/promises"));
const request_util_1 = require("./request_util");
const user_utils_1 = require("./user_utils");
const base_url = `${process.env.HOST}`;
function create_ad(session, user, name, path, targetViews, image, type, category, keywords) {
    return __awaiter(this, void 0, void 0, function* () {
        if (type == client_1.ad_type.Fixed) {
            if (!(yield (0, user_utils_1.is_admin)(user))) {
                return false;
            }
        }
        const prisma = new client_1.PrismaClient();
        const ad = yield prisma.ad.create({ data: {
                userid: user,
                name: name,
                creation_date: new Date(),
                category: category,
                image: image,
                keywords: keywords,
                path: path,
                renewal_date: new Date(),
                targetViews: targetViews,
                type: type,
            } });
        yield (0, request_util_1.create_request)(user, ad.id, client_1.request_type.Create, null);
        yield (0, session_utils_1.update_session)(session);
        yield prisma.$disconnect();
        return true;
    });
}
function get_ad_user(ad) {
    return __awaiter(this, void 0, void 0, function* () {
        const prisma = new client_1.PrismaClient();
        const user = yield prisma.ad.findFirst({
            select: {
                userid: true
            },
            where: {
                id: ad
            }
        });
        yield prisma.$disconnect();
        return user != null ? user.userid : "";
    });
}
function get_user_ads(session, user) {
    return __awaiter(this, void 0, void 0, function* () {
        let res = [];
        const prisma = new client_1.PrismaClient();
        const ads = yield prisma.ad.findMany({ where: { userid: user } });
        ads.forEach((obj) => {
            res.push({
                id: obj.id,
                name: obj.name,
                image: `https://${base_url}/${obj.image}`,
                category: (0, category_utils_1.category_to_number)(obj.category),
                isPublished: obj.isPublished,
                keywords: obj.keywords,
                targetViews: obj.targetViews,
                lastUpdate: obj.renewal_date,
                path: obj.path,
                type: obj.type,
                views: obj.views
            });
        });
        yield (0, session_utils_1.update_session)(session);
        yield prisma.$disconnect();
        return res;
    });
}
function get_ads() {
    return __awaiter(this, arguments, void 0, function* (size = 50) {
        let res = [];
        const prisma = new client_1.PrismaClient();
        
        // Try to get active dynamic ads first
        let ads = yield prisma.ad.findMany({
            where: {
                AND: [
                    {
                        views: {
                            lt: prisma.ad.fields.targetViews
                        },
                    },
                    {
                        isPublished: true,
                        type: client_1.ad_type.Dynamic
                    }
                ]
            },
            orderBy: {
                views: "desc"
            },
            take: size
        });
        
        // Fallback 1: If no active Dynamic ads, get published Dynamic ads regardless of views
        if (ads.length === 0) {
            console.log('[get_ads] No active Dynamic ads, trying all published Dynamic ads...');
            ads = yield prisma.ad.findMany({
                where: {
                    isPublished: true,
                    type: client_1.ad_type.Dynamic  // ✅ Dynamic فقط!
                },
                orderBy: {
                    renewal_date: "desc"
                },
                take: size
            });
        }
        
        // Fallback 2: If still no Dynamic ads, get ANY Dynamic ads
        if (ads.length === 0) {
            console.log('[get_ads] No published Dynamic ads, getting any Dynamic ads...');
            ads = yield prisma.ad.findMany({
                where: {
                    type: client_1.ad_type.Dynamic  // ✅ Dynamic فقط!
                },
                orderBy: {
                    creation_date: "desc"
                },
                take: size
            });
        }
        
        console.log(`[get_ads] Found ${ads.length} ads`);
        
        ads.forEach((obj) => {
            res.push({
                id: obj.id,
                name: obj.name,
                image: `https://${base_url}/${obj.image}`,
                category: (0, category_utils_1.category_to_number)(obj.category),
                isPublished: obj.isPublished,
                keywords: obj.keywords,
                lastUpdate: obj.renewal_date,
                targetViews: obj.targetViews,
                path: obj.path,
                type: obj.type,
                views: obj.views
            });
        });
        yield prisma.$disconnect();
        return res;
    });
}
function get_fixed_ads() {
    return __awaiter(this, arguments, void 0, function* (size = 50) {
        let res = [];
        const prisma = new client_1.PrismaClient();
        
        // Try to get fixed ads first
        let restrcitedAds = yield prisma.ad.findMany({
            where: {
                isPublished: true,
                type: client_1.ad_type.Fixed,
            },
            take: size,
            orderBy: {
                renewal_date: 'desc'
            }
        });
        
        // Fallback: If no fixed ads, get any published ads
        if (restrcitedAds.length === 0) {
            console.log('[get_fixed_ads] No fixed ads found, getting published ads...');
            restrcitedAds = yield prisma.ad.findMany({
                where: {
                    isPublished: true,
                },
                take: size,
                orderBy: {
                    renewal_date: 'desc'
                }
            });
        }
        
        console.log(`[get_fixed_ads] Found ${restrcitedAds.length} ads`);
        
        restrcitedAds.forEach((obj) => {
            res.push({
                id: obj.id,
                name: obj.name,
                image: `https://${base_url}/${obj.image}`,
                category: (0, category_utils_1.category_to_number)(obj.category),
                isPublished: obj.isPublished,
                keywords: obj.keywords,
                lastUpdate: obj.renewal_date,
                path: obj.path,
                targetViews: obj.targetViews,
                type: obj.type,
                views: obj.views
            });
        });
        yield prisma.$disconnect();
        return res;
    });
}
function get_ads_per_category(user_1, category_1) {
    return __awaiter(this, arguments, void 0, function* (user, category, size = 50) {
        let res = [];
        let oldOnes = 0;
        if (user) {
            oldOnes = Math.round(size * 0.8);
        }
        const unRestrcitedOnes = size - oldOnes;
        const prisma = new client_1.PrismaClient();
        let restrcitedAds = [];
        if (user) {
            restrcitedAds = yield prisma.ad.findMany({
                where: {
                    AND: [
                        {
                            category: category,
                        },
                        {
                            views_views_adToad: {
                                none: {
                                    user: {
                                        equals: user
                                    }
                                }
                            },
                        },
                        {
                            views: {
                                lt: prisma.ad.fields.targetViews
                            }
                        },
                        {
                            isPublished: true,
                            type: client_1.ad_type.Dynamic
                        }
                    ]
                },
                orderBy: {
                    renewal_date: "desc"
                },
                take: oldOnes
            });
        }
        const unRestrcitedAds = yield prisma.ad.findMany({
            where: {
                AND: [
                    {
                        category: category,
                    },
                    {
                        id: {
                            notIn: restrcitedAds.map((x) => { return x.id; })
                        }
                    },
                    {
                        views: {
                            lt: prisma.ad.fields.targetViews
                        }
                    },
                    {
                        isPublished: true,
                        type: client_1.ad_type.Dynamic
                    }
                ]
            },
            take: unRestrcitedOnes
        });
        restrcitedAds.forEach((obj) => {
            res.push({
                id: obj.id,
                name: obj.name,
                image: `https://${base_url}/${obj.image}`,
                category: (0, category_utils_1.category_to_number)(obj.category),
                isPublished: obj.isPublished,
                keywords: obj.keywords,
                lastUpdate: obj.renewal_date,
                targetViews: obj.targetViews,
                path: obj.path,
                type: obj.type,
                views: obj.views
            });
        });
        unRestrcitedAds.forEach((obj) => {
            res.push({
                id: obj.id,
                name: obj.name,
                image: `https://${base_url}/${obj.image}`,
                category: (0, category_utils_1.category_to_number)(obj.category),
                isPublished: obj.isPublished,
                keywords: obj.keywords,
                lastUpdate: obj.renewal_date,
                path: obj.path,
                type: obj.type,
                views: obj.views,
                targetViews: obj.targetViews
            });
        });
        yield prisma.$disconnect();
        return res;
    });
}
function edit_ad(session, ad, name, path, targetViews, type, image, category, keywords) {
    return __awaiter(this, void 0, void 0, function* () {
        const prisma = new client_1.PrismaClient();
        const oldData = yield prisma.ad.findFirst({
            select: { image: true },
            where: { id: ad }
        });
        let newData = {};
        if (image) {
            yield promises_1.default.rm(`${oldData === null || oldData === void 0 ? void 0 : oldData.image}`);
            newData = {
                name: name,
                category: category,
                image: image,
                keywords: keywords,
                path: path,
                targetViews: targetViews,
                type: type,
            };
        }
        else {
            newData = {
                name: name,
                category: category,
                keywords: keywords,
                path: path,
                targetViews: targetViews,
                type: type,
            };
        }
        yield prisma.ad.update({ data: newData,
            where: {
                id: ad
            }
        });
        yield (0, session_utils_1.update_session)(session);
        yield prisma.$disconnect();
    });
}
function delete_ad(ad) {
    return __awaiter(this, void 0, void 0, function* () {
        const prisma = new client_1.PrismaClient();
        const oldData = yield prisma.ad.findFirst({
            select: { image: true },
            where: { id: ad }
        });
        yield promises_1.default.rm(`${oldData === null || oldData === void 0 ? void 0 : oldData.image}`);
        yield prisma.views.deleteMany({ where: { ad: ad } });
        yield prisma.ad.delete({
            where: {
                id: ad
            }
        });
        yield prisma.$disconnect();
    });
}
