"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendVerificationCode = sendVerificationCode;
const nodemailer_1 = require("nodemailer");
function sendVerificationCode(email, code, name) {
    const sender = (0, nodemailer_1.createTransport)({
        service: 'gmail',
        port: 465,
        auth: {
            user: process.env.EMAIL,
            pass: process.env.CODE
        }
    });
    const mail = {
        from: "dailyadmag@inovetics.com",
        to: email,
        subject: "🎉 مرحباً بك في الاعلان اليومي - تأكيد حسابك",
        text: `مرحباً ${name}! 👋

أهلاً بك في الاعلان اليومي! 

نحن سعداء جداً بانضمامك لمجتمعنا المميز!

كود التحقق الخاص بك هو: ${code}

يرجى إدخال هذا الكود لإتمام عملية التسجيل. احتفظ به بشكل آمن ولا تشاركه مع أي شخص.

نحن متحمسون لوجودك معنا!

مع أطيب التحيات،
فريق الاعلان اليومي`,
        html: `
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تأكيد حسابك</title>
</head>
<body style="margin: 0; padding: 0; font-family: 'Segoe UI', Tahoma, Arial, sans-serif; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh;">
    <table cellpadding="0" cellspacing="0" border="0" width="100%" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 40px 20px;">
        <tr>
            <td align="center">
                <table cellpadding="0" cellspacing="0" border="0" width="600" style="max-width: 600px; background: #ffffff; border-radius: 20px; box-shadow: 0 20px 60px rgba(0,0,0,0.3); overflow: hidden;">
                    <!-- Header -->
                    <tr>
                        <td style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 40px 30px; text-align: center;">
                            <h1 style="margin: 0; color: #ffffff; font-size: 32px; font-weight: 700; text-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                                🎯 الاعلان اليومي
                            </h1>
                            <p style="margin: 10px 0 0 0; color: #f0f0f0; font-size: 16px; opacity: 0.95;">
                                منصتك للإعلانات
                            </p>
                        </td>
                    </tr>
                    
                    <!-- Content -->
                    <tr>
                        <td style="padding: 50px 40px;">
                            <h2 style="margin: 0 0 20px 0; color: #333333; font-size: 28px; font-weight: 700;">
                                مرحباً ${name}! 👋
                            </h2>
                            <p style="margin: 0 0 25px 0; color: #555555; font-size: 16px; line-height: 1.8;">
                                أهلاً بك في <strong style="color: #667eea;">الاعلان اليومي</strong>! نحن سعداء جداً بانضمامك لمجتمعنا المميز.
                            </p>
                            <p style="margin: 0 0 30px 0; color: #555555; font-size: 16px; line-height: 1.8;">
                                أنت على بُعد <strong>خطوة واحدة فقط</strong> من الاستمتاع بجميع المزايا الرائعة التي نقدمها. لإتمام عملية التسجيل، يرجى تأكيد حسابك باستخدام الكود أدناه:
                            </p>
                            
                            <!-- Verification Code Box -->
                            <table cellpadding="0" cellspacing="0" border="0" width="100%">
                                <tr>
                                    <td align="center" style="padding: 25px 0;">
                                        <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 15px; padding: 30px; display: inline-block; box-shadow: 0 10px 30px rgba(102, 126, 234, 0.4);">
                                            <p style="margin: 0 0 10px 0; color: #ffffff; font-size: 14px; font-weight: 600; letter-spacing: 1px; opacity: 0.9;">
                                                كود التحقق الخاص بك
                                            </p>
                                            <p style="margin: 0; color: #ffffff; font-size: 42px; font-weight: 800; letter-spacing: 8px; font-family: 'Courier New', monospace;">
                                                ${code}
                                            </p>
                                        </div>
                                    </td>
                                </tr>
                            </table>
                            
                            <!-- Security Notice -->
                            <table cellpadding="0" cellspacing="0" border="0" width="100%">
                                <tr>
                                    <td style="background: #fff3cd; border-right: 4px solid #ffc107; padding: 20px; border-radius: 8px; margin: 30px 0;">
                                        <p style="margin: 0; color: #856404; font-size: 14px; line-height: 1.8;">
                                            <strong>🔒 تنبيه أمني:</strong> احتفظ بهذا الكود بشكل سري ولا تشاركه مع أي شخص. فريقنا لن يطلب منك هذا الكود أبداً عبر الهاتف أو البريد الإلكتروني.
                                        </p>
                                    </td>
                                </tr>
                            </table>
                            
                            <p style="margin: 30px 0 0 0; color: #555555; font-size: 16px; line-height: 1.8;">
                                إذا لم تطلب هذا الكود، يرجى تجاهل هذا البريد الإلكتروني أو التواصل مع فريق الدعم فوراً.
                            </p>
                        </td>
                    </tr>
                    
                    <!-- Footer -->
                    <tr>
                        <td style="background: #f8f9fa; padding: 30px 40px; border-top: 1px solid #e9ecef;">
                            <p style="margin: 0 0 15px 0; color: #667eea; font-size: 18px; font-weight: 600;">
                                نحن متحمسون لوجودك معنا! 🚀
                            </p>
                            <p style="margin: 0 0 5px 0; color: #6c757d; font-size: 14px; line-height: 1.8;">
                                مع أطيب التحيات،<br>
                                <strong style="color: #333333;">فريق الاعلان اليومي</strong>
                            </p>
                        </td>
                    </tr>
                    
                    <!-- Footer Note -->
                    <tr>
                        <td style="background: #667eea; padding: 20px 40px; text-align: center;">
                            <p style="margin: 0; color: #ffffff; font-size: 12px; opacity: 0.9;">
                                © 2025 الاعلان اليومي. جميع الحقوق محفوظة.
                            </p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>
</html>
        `
    };
    let res = true;
    sender.sendMail(mail, (error, info) => {
        console.log("Error : " + error);
        console.log("Info : " + info);
        if (error)
            res = false;
    });
    return res;
}
