"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.get_ad_requests = get_ad_requests;
exports.get_renew_requests = get_renew_requests;
exports.get_money_requests = get_money_requests;
exports.get_my_requests = get_my_requests;
exports.create_request = create_request;
exports.delete_request = delete_request;
exports.accept_request = accept_request;
exports.reject_request = reject_request;
exports.get_request_user = get_request_user;
exports.exchange_points = exchange_points;
const client_1 = require("@prisma/client");
const ads_utils_1 = require("./ads_utils");
const req_response_1 = require("../responses/req_response");
const category_utils_1 = require("./category_utils");
const promises_1 = require("fs/promises");
function get_ad_requests() {
    return __awaiter(this, arguments, void 0, function* (type = null) {
        let res = [];
        const prisma = new client_1.PrismaClient();
        let query = {};
        if (type != null) {
            query = {
                type: "Create",
                relatedAd: { type: type },
            };
        }
        else {
            query = {
                type: "Create",
            };
        }
        const data = yield prisma.request.findMany({
            select: {
                id: true,
                ad_request_adToad: {
                    select: {
                        name: true,
                        path: true,
                        image: true,
                        targetViews: true,
                        type: true,
                        category: true,
                    },
                },
                user_request_userTouser: {
                    select: {
                        fullname: true,
                    },
                },
            },
            where: query,
        });
        data.forEach((x) => {
            var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l;
            res.push(new req_response_1.ad_create_req_response(x.id, (_b = (_a = x.ad_request_adToad) === null || _a === void 0 ? void 0 : _a.name) !== null && _b !== void 0 ? _b : "", x.user_request_userTouser.fullname, (_d = (_c = x.ad_request_adToad) === null || _c === void 0 ? void 0 : _c.path) !== null && _d !== void 0 ? _d : "", `https://${process.env.HOST}/${(_e = x.ad_request_adToad) === null || _e === void 0 ? void 0 : _e.image}`, (_g = (_f = x.ad_request_adToad) === null || _f === void 0 ? void 0 : _f.targetViews) !== null && _g !== void 0 ? _g : 0, (_j = (_h = x.ad_request_adToad) === null || _h === void 0 ? void 0 : _h.type) !== null && _j !== void 0 ? _j : "", (0, category_utils_1.category_to_number)((_l = (_k = x.ad_request_adToad) === null || _k === void 0 ? void 0 : _k.category) !== null && _l !== void 0 ? _l : client_1.ad_category.Automotive)));
        });
        yield prisma.$disconnect();
        return res;
    });
}
function get_renew_requests() {
    return __awaiter(this, arguments, void 0, function* (type = null) {
        let res = [];
        const prisma = new client_1.PrismaClient();
        let query = {};
        if (type) {
            query = {
                type: client_1.request_type.Renew,
                relatedAd: { type: type },
            };
        }
        else {
            query = {
                type: "Renew",
            };
        }
        const data = yield prisma.request.findMany({
            select: {
                id: true,
                ad_request_adToad: {
                    select: {
                        name: true,
                        path: true,
                        image: true,
                        views: true,
                        targetViews: true,
                        category: true,
                        creation_date: true,
                        renewal_date: true,
                    },
                },
                param: true,
                user_request_userTouser: {
                    select: {
                        fullname: true,
                        phone: true,
                    },
                },
            },
            where: query,
        });
        data.forEach((x) => {
            var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s;
            res.push(new req_response_1.ad_renew_req_response(x.id, (_b = (_a = x.ad_request_adToad) === null || _a === void 0 ? void 0 : _a.name) !== null && _b !== void 0 ? _b : "", x.user_request_userTouser.fullname, (_c = x.user_request_userTouser.phone) !== null && _c !== void 0 ? _c : "", (_e = (_d = x.ad_request_adToad) === null || _d === void 0 ? void 0 : _d.path) !== null && _e !== void 0 ? _e : "", `https://${process.env.HOST}/${(_f = x.ad_request_adToad) === null || _f === void 0 ? void 0 : _f.image}`, (_h = (_g = x.ad_request_adToad) === null || _g === void 0 ? void 0 : _g.views) !== null && _h !== void 0 ? _h : 0, (_k = (_j = x.ad_request_adToad) === null || _j === void 0 ? void 0 : _j.targetViews) !== null && _k !== void 0 ? _k : 0, (_l = x.param) !== null && _l !== void 0 ? _l : "", (0, category_utils_1.category_to_number)((_o = (_m = x.ad_request_adToad) === null || _m === void 0 ? void 0 : _m.category) !== null && _o !== void 0 ? _o : "Automotive"), (_q = (_p = x.ad_request_adToad) === null || _p === void 0 ? void 0 : _p.creation_date) !== null && _q !== void 0 ? _q : new Date(), (_s = (_r = x.ad_request_adToad) === null || _r === void 0 ? void 0 : _r.renewal_date) !== null && _s !== void 0 ? _s : new Date()));
        });
        yield prisma.$disconnect();
        return res;
    });
}
function get_money_requests() {
    return __awaiter(this, void 0, void 0, function* () {
        let res = [];
        const prisma = new client_1.PrismaClient();
        const data = yield prisma.request.findMany({
            select: {
                id: true,
                param: true,
                user_request_userTouser: {
                    select: {
                        fullname: true,
                        phone: true,
                        joinDate: true,
                        _count: { select: { views_views_userTouser: true } },
                    },
                },
            },
            where: {
                type: "Money",
            },
        });
        data.forEach((x) => {
            var _a, _b;
            res.push(new req_response_1.money_req_response(x.id, x.user_request_userTouser.fullname, (_a = x.user_request_userTouser.phone) !== null && _a !== void 0 ? _a : "", x.user_request_userTouser._count.views_views_userTouser, parseInt((_b = x.param) !== null && _b !== void 0 ? _b : "0"), x.user_request_userTouser.joinDate.toDateString()));
        });
        yield prisma.$disconnect();
        return res;
    });
}
function get_my_requests(user) {
    return __awaiter(this, void 0, void 0, function* () {
        let res = [];
        const prisma = new client_1.PrismaClient();
        const data = yield prisma.request.findMany({
            select: {
                id: true,
                ad_request_adToad: { select: { name: true } },
                type: true,
                creation: true,
            },
            where: {
                user: user,
            },
        });
        data.forEach((x) => {
            var _a, _b;
            res.push(new req_response_1.my_req_response(x.id, (_b = (_a = x.ad_request_adToad) === null || _a === void 0 ? void 0 : _a.name) !== null && _b !== void 0 ? _b : "", x.type, x.creation.toDateString()));
        });
        yield prisma.$disconnect();
        return res;
    });
}
function create_request(user, ad, type, tier) {
    return __awaiter(this, void 0, void 0, function* () {
        const prisma = new client_1.PrismaClient();
        if (type != client_1.request_type.Money && ad == null) {
            yield prisma.$disconnect();
            return;
        }
        yield prisma.request.create({
            data: {
                creation: new Date(),
                type: type,
                ad: ad,
                user: user,
                param: tier,
            },
        });
        yield prisma.ad.update({
            data: {
                isPublished: false,
            },
            where: {
                id: ad !== null && ad !== void 0 ? ad : "",
            },
        });
        yield prisma.$disconnect();
    });
}
function delete_request(request) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b;
        const prisma = new client_1.PrismaClient();
        const data = yield prisma.request.findFirst({ where: { id: request } });
        yield prisma.request.delete({
            where: {
                id: request,
            },
        });
        // FIX: Check data.type not data.user
        if ((data === null || data === void 0 ? void 0 : data.type) == client_1.request_type.Create) {
            yield prisma.ad.delete({ where: { id: (_a = data.ad) !== null && _a !== void 0 ? _a : "" } });
            const img = yield prisma.ad.findFirst({ select: { image: true }, where: { id: data === null || data === void 0 ? void 0 : data.id } });
            yield (0, promises_1.rm)(((_b = img === null || img === void 0 ? void 0 : img.image) !== null && _b !== void 0 ? _b : ""));
        }
        yield prisma.$disconnect();
    });
}
function accept_request(request) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b, _c;
        const prisma = new client_1.PrismaClient();
        const data = yield prisma.request.findFirst({
            select: {
                ad: true,
                type: true,
                ad_request_adToad: { select: { targetViews: true, type: true } },
                param: true,
            },
            where: { id: request },
        });
        switch (data === null || data === void 0 ? void 0 : data.type) {
            case client_1.request_type.Create:
                yield prisma.ad.update({
                    data: { isPublished: true },
                    where: { id: (_a = data.ad) !== null && _a !== void 0 ? _a : "" },
                });
                break;
            case client_1.request_type.Renew:
                yield prisma.ad.update({
                    data: {
                        isPublished: true,
                        targetViews: data.param
                            ? parseInt(data.param) : (_b = data.ad_request_adToad) === null || _b === void 0 ? void 0 : _b.targetViews,
                    },
                    where: { id: (_c = data.ad) !== null && _c !== void 0 ? _c : "" },
                });
                break;
            case client_1.request_type.Money:
                break;
            default:
                break;
        }
        yield delete_request(request);
        yield prisma.$disconnect();
    });
}
function reject_request(request) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b;
        const prisma = new client_1.PrismaClient();
        const data = yield prisma.request.findFirst({ where: { id: request } });
        switch (data === null || data === void 0 ? void 0 : data.type) {
            case client_1.request_type.Create:
                yield (0, ads_utils_1.delete_ad)((_a = data.ad) !== null && _a !== void 0 ? _a : "");
                break;
            case client_1.request_type.Renew:
                yield prisma.ad.update({
                    data: {
                        isPublished: true,
                    },
                    where: { id: (_b = data.ad) !== null && _b !== void 0 ? _b : "" },
                });
                break;
            case client_1.request_type.Money:
                break;
            default:
                break;
        }
        yield delete_request(request);
        yield prisma.$disconnect();
    });
}
function get_request_user(request) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a;
        const prisma = new client_1.PrismaClient();
        const data = yield prisma.request.findFirst({
            select: { user_request_userTouser: { select: { id: true } } },
            where: { id: request },
        });
        yield prisma.$disconnect();
        return (_a = data === null || data === void 0 ? void 0 : data.user_request_userTouser.id) !== null && _a !== void 0 ? _a : "";
    });
}
function exchange_points(user) {
    return __awaiter(this, void 0, void 0, function* () {
        const prisma = new client_1.PrismaClient();
        const data = yield prisma.user.findFirst({ where: { id: user } });
        if (data) {
            const money = Math.floor((data === null || data === void 0 ? void 0 : data.points) / 1000) * 50;
            const reminder = data.points % 1000;
            // FIX: Removed dead code line 'create_request;'
            if (money != 0) {
                yield prisma.user.update({ data: { points: reminder }, where: { id: user } });
                yield prisma.request.create({ data: {
                        creation: new Date(),
                        type: "Money",
                        param: money.toString(),
                        user: user
                    } });
                yield prisma.$disconnect();
                return true;
            }
        }
        yield prisma.$disconnect();
        return false;
    });
}
