"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.create_session = create_session;
exports.validate_session = validate_session;
exports.destroy_session = destroy_session;
exports.clean_sessions = clean_sessions;
exports.update_session = update_session;
const client_1 = require("@prisma/client");
function create_session(user_1, ip_1) {
    return __awaiter(this, arguments, void 0, function* (user, ip, is_reset = false) {
        const prisma = new client_1.PrismaClient();
        // const prevSession = await prisma.session.findFirst({
        //     where: {
        //         ip: ip
        //     }
        // });
        // if (prevSession)
        // {
        //     await prisma.session.delete({
        //         where: {
        //             id: prevSession.id
        //         }
        //     });
        // }
        const session_id = (yield prisma.session.create({
            data: {
                ip: ip,
                userid: user,
                last_used: (new Date()),
                is_reset: is_reset
            }
        })).id;
        yield prisma.$disconnect();
        return session_id;
    });
}
function validate_session(session_id_1, ip_1, user_1) {
    return __awaiter(this, arguments, void 0, function* (session_id, ip, user, is_reset = false) {
        const prisma = new client_1.PrismaClient();
        let res = true;
        const session = yield prisma.session.findFirst({
            where: {
                id: session_id,
                ip: ip,
                userid: user,
                is_reset: is_reset
            }
        });
        res = session !== null;
        yield prisma.$disconnect();
        return res;
    });
}
function destroy_session(session_id) {
    return __awaiter(this, void 0, void 0, function* () {
        const prisma = new client_1.PrismaClient();
        yield prisma.session.delete({
            where: {
                id: session_id
            }
        });
        yield prisma.$disconnect();
    });
}
function clean_sessions() {
    return __awaiter(this, void 0, void 0, function* () {
        const prisma = new client_1.PrismaClient();
        const requiredDate = new Date();
        requiredDate.setDate(requiredDate.getDate() - 10);
        const sessions = yield prisma.session.findMany({ where: { last_used: { lte: requiredDate } } });
        // FIX: Use Promise.all to await all delete operations
        yield Promise.all(sessions.map(obj => 
            prisma.session.delete({ where: { id: obj.id } })
        ));
        yield prisma.$disconnect();
    });
}
function update_session(session) {
    return __awaiter(this, void 0, void 0, function* () {
        const prisma = new client_1.PrismaClient();
        yield prisma.session.update({ data: { last_used: new Date() }, where: { id: session } });
        yield prisma.$disconnect();
    });
}
