"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.create_user = create_user;
exports.find_user_by_id = find_user_by_id;
exports.find_user_by_username = find_user_by_username;
exports.find_user_by_email = find_user_by_email;
exports.find_user_by_phone = find_user_by_phone;
exports.get_user_points = get_user_points;
exports.add_points_to_user = add_points_to_user;
exports.verify_user = verify_user;
exports.isVerified = isVerified;
exports.changePass = changePass;
exports.resendCode = resendCode;
exports.is_admin = is_admin;
exports.get_user_profile = get_user_profile;
exports.delete_user = delete_user;
const client_1 = require("@prisma/client");
const common_utils_1 = require("./common_utils");
const crypto_1 = require("crypto");
const auth_response_1 = require("../responses/auth_response");
const mail_1 = require("./mail");
function create_user(name, username, password, email, phone) {
    return __awaiter(this, void 0, void 0, function* () {
        const prisma = new client_1.PrismaClient();
        let test = (yield find_user_by_username(username)) !== null;
        if (test) {
            yield prisma.$disconnect();
            return false;
        }
        test = (yield find_user_by_email(email)) !== null;
        if (test) {
            yield prisma.$disconnect();
            return false;
        }
        if (phone) {
            test = (yield find_user_by_phone(phone)) !== null;
            if (test) {
                yield prisma.$disconnect();
                return false;
            }
        }
        const verification = (0, common_utils_1.generate_code)();
        const hash = (0, crypto_1.createHash)("sha256").update(password).digest("base64");
        yield prisma.user.create({
            data: {
                fullname: name,
                email: email,
                username: username,
                password: hash,
                joinDate: (new Date()),
                phone: phone,
                verification: verification
            }
        });
        const id = yield find_user_by_email(email);
        yield resendCode(id !== null && id !== void 0 ? id : "");
        yield prisma.$disconnect();
        return true;
    });
}
function find_user_by_id(id) {
    return __awaiter(this, void 0, void 0, function* () {
        const prisma = new client_1.PrismaClient();
        const user = yield prisma.user.findFirst({
            where: {
                id: id,
                isDeleted: false
            }
        });
        let out = null;
        if (user)
            out = user;
        yield prisma.$disconnect();
        return out;
    });
}
function find_user_by_username(username) {
    return __awaiter(this, void 0, void 0, function* () {
        const prisma = new client_1.PrismaClient();
        const user = yield prisma.user.findFirst({
            where: {
                username: username,
                isDeleted: false
            }
        });
        let out = null;
        if (user)
            out = user.id;
        yield prisma.$disconnect();
        return out;
    });
}
function find_user_by_email(email) {
    return __awaiter(this, void 0, void 0, function* () {
        const prisma = new client_1.PrismaClient();
        const user = yield prisma.user.findFirst({
            where: {
                email: email,
                isDeleted: false
            }
        });
        let out = null;
        if (user)
            out = user.id;
        yield prisma.$disconnect();
        return out;
    });
}
function find_user_by_phone(phone) {
    return __awaiter(this, void 0, void 0, function* () {
        const prisma = new client_1.PrismaClient();
        const user = yield prisma.user.findFirst({
            where: {
                phone: phone,
                isDeleted: false
            }
        });
        let out = null;
        if (user)
            out = user.id;
        yield prisma.$disconnect();
        return out;
    });
}
function get_user_points(user) {
    return __awaiter(this, void 0, void 0, function* () {
        const prisma = new client_1.PrismaClient();
        const userdata = yield prisma.user.findFirst({
            where: {
                id: user,
                isDeleted: false
            }
        });
        let out = null;
        if (userdata)
            out = userdata.points;
        yield prisma.$disconnect();
        return out;
    });
}
function add_points_to_user(user, points) {
    return __awaiter(this, void 0, void 0, function* () {
        const prisma = new client_1.PrismaClient();
        const data = yield find_user_by_id(user);
        if (!data) {
            yield prisma.$disconnect();
            return false;
        }
        const curPoints = yield get_user_points(user);
        if (curPoints != null) {
            yield prisma.user.update({
                data: {
                    points: curPoints + points
                },
                where: {
                    id: user
                }
            });
        }
        yield prisma.$disconnect();
        return true;
    });
}
function verify_user(user, code) {
    return __awaiter(this, void 0, void 0, function* () {
        const prisma = new client_1.PrismaClient();
        const userdata = yield find_user_by_id(user);
        let res = false;
        if ((userdata === null || userdata === void 0 ? void 0 : userdata.verification) === code) {
            yield prisma.user.update({
                data: {
                    isVerified: true
                },
                where: {
                    id: user
                }
            });
            res = true;
        }
        yield prisma.$disconnect();
        return res;
    });
}
function isVerified(user) {
    return __awaiter(this, void 0, void 0, function* () {
        const prisma = new client_1.PrismaClient();
        const data = yield find_user_by_id(user);
        if (!data)
            return false;
        yield prisma.$disconnect();
        return data === null || data === void 0 ? void 0 : data.isVerified;
    });
}
function changePass(user, pass) {
    return __awaiter(this, void 0, void 0, function* () {
        const prisma = new client_1.PrismaClient();
        yield prisma.user.update({
            data: {
                password: pass
            },
            where: {
                id: user
            }
        });
        yield prisma.$disconnect();
    });
}
function resendCode(user) {
    return __awaiter(this, void 0, void 0, function* () {
        const prisma = new client_1.PrismaClient();
        const code = (0, common_utils_1.generate_code)();
        const x = yield prisma.user.update({
            data: {
                isVerified: false,
                verification: code
            },
            where: {
                id: user
            }
        });
        //Send Code
        (0, mail_1.sendVerificationCode)(x.email, code, x.fullname);
        yield prisma.$disconnect();
        return true;
    });
}
function is_admin(user) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a;
        const prisma = new client_1.PrismaClient();
        const isAdmin = yield prisma.user.findFirst({
            select: {
                isAdmin: true
            },
            where: {
                id: user,
                isDeleted: false
            }
        });
        yield prisma.$disconnect();
        return (_a = (isAdmin === null || isAdmin === void 0 ? void 0 : isAdmin.isAdmin)) !== null && _a !== void 0 ? _a : false;
    });
}
function get_user_profile(user) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a;
        const prisma = new client_1.PrismaClient();
        const data = yield prisma.user.findFirst({
            select: {
                fullname: true,
                username: true,
                email: true,
                joinDate: true,
                phone: true,
                points: true,
            },
            where: {
                id: user,
                isDeleted: false
            }
        });
        yield prisma.$disconnect();
        if (data) {
            return new auth_response_1.profile_response(data.fullname, data.username, data.email, (_a = data.phone) !== null && _a !== void 0 ? _a : "لا يوجد", data.points, data.joinDate);
        }
        return null;
    });
}
function delete_user(user) {
    return __awaiter(this, void 0, void 0, function* () {
        const prisma = new client_1.PrismaClient();
        const res = yield prisma.user.update({
            data: {
                isDeleted: true
            },
            where: {
                id: user
            }
        });
        yield prisma.$disconnect();
        return res != null;
    });
}
